/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.code;

import gjc.v6.code.Code;
import gjc.v6.code.Flags;
import gjc.v6.code.Kinds;
import gjc.v6.code.Pool;
import gjc.v6.code.Scope;
import gjc.v6.code.Type;
import gjc.v6.code.TypeTags;
import gjc.v6.util.FileEntry;
import gjc.v6.util.List;
import gjc.v6.util.Name;
import gjc.v6.util.Names;

public class Symbol
implements Flags,
Kinds,
TypeTags {
    public int kind;
    public int flags_field;
    public Name name;
    public Type type;
    public Symbol owner;
    public Completer completer;
    public Type erasure_field;
    public boolean isExternal;
    public static PackageSymbol emptyPackage;
    public static TypeSymbol noSymbol;
    public static ClassSymbol errSymbol;
    public static int count;

    public int flags() {
        return this.flags_field;
    }

    public Symbol(int kind, int flags, Name name, Type type, Symbol symbol) {
        this.kind = kind;
        this.flags_field = flags;
        this.name = name;
        this.type = type;
        this.owner = symbol;
        this.completer = null;
        this.erasure_field = null;
    }

    static void init() {
        emptyPackage = new PackageSymbol(Names.empty, null);
        noSymbol = new TypeSymbol(0, Names.empty, Type.noType, emptyPackage);
        Symbol.noSymbol.kind = 0;
        errSymbol = new ClassSymbol(9, Names.any, Type.errType, emptyPackage);
        Symbol.errSymbol.kind = 63;
        Symbol.errSymbol.members_field = Scope.errScope;
        Scope.errScope.owner = errSymbol;
        Type.init();
    }

    public static void reset() {
        Symbol.emptyPackage.members_field = null;
    }

    public String toString() {
        return this.name.toString();
    }

    public String location() {
        return this.owner.name == null || this.owner.name.len == 0 ? "" : String.valueOf(" in ").concat(String.valueOf(this.owner));
    }

    public Type erasure() {
        if (this.erasure_field == null) {
            this.erasure_field = this.type.erasure();
        }
        return this.erasure_field;
    }

    public Type externalType() {
        Type t = this.erasure();
        if (this.name == Names.init && this.owner.hasOuterInstance()) {
            Type type = this.owner.type.outer().erasure();
            return new Type.MethodType(t.argtypes().prepend(type), t.restype(), t.thrown());
        }
        return t;
    }

    public boolean isLocal() {
        return (this.owner.kind & 0x24) != 0 || this.owner.kind == 2 && this.owner.isLocal();
    }

    public boolean isConstructor() {
        return this.name == Names.init;
    }

    public Name fullName() {
        return this.name;
    }

    public Name flatName() {
        return this.fullName();
    }

    public boolean isInner() {
        return this.owner.kind == 4 || this.owner.kind == 32 || this.owner.kind == 2 && (this.flags_field & 8) == 0;
    }

    public boolean isNested() {
        return (this.flags_field & 0x200) == 0 && this.type.outer().tag == 10;
    }

    public boolean hasOuterInstance() {
        return this.isNested() && (this.flags() & 0x200000) == 0;
    }

    public ClassSymbol enclClass() {
        Symbol symbol = this;
        while (symbol != null && (symbol.kind & 2) == 0) {
            symbol = symbol.owner;
        }
        return (ClassSymbol)symbol;
    }

    public ClassSymbol outermostClass() {
        Symbol sym = this;
        Symbol symbol = null;
        while (sym.kind != 1) {
            symbol = sym;
            sym = sym.owner;
        }
        return (ClassSymbol)symbol;
    }

    public boolean subclass(Symbol symbol) {
        throw new InternalError(String.valueOf("subclass ").concat(String.valueOf(this)));
    }

    public Symbol complete() throws CompletionFailure {
        if (this.completer != null) {
            Completer completer = this.completer;
            this.completer = null;
            completer.complete(this);
        }
        return this;
    }

    public Scope members() {
        return null;
    }

    static {
        Symbol.init();
        count = 0;
    }

    public static class CompletionFailure
    extends RuntimeException {
        public Symbol sym;
        public String errmsg;

        public CompletionFailure(Symbol sym, String string) {
            this.sym = sym;
            this.errmsg = string;
        }

        public String getMessage() {
            return this.errmsg;
        }
    }

    public static interface Completer {
        public void complete(Symbol var1) throws CompletionFailure;
    }

    public static class OperatorSymbol
    extends MethodSymbol {
        public int opcode;

        public OperatorSymbol(Name name, Type type, int opcode, Symbol symbol) {
            super(9, name, type, symbol);
            this.opcode = opcode;
        }
    }

    public static class MethodSymbol
    extends Symbol {
        public Code code = null;
        public static final List<MethodSymbol> emptyList = new List();

        public MethodSymbol(int flags, Name name, Type type, Symbol symbol) {
            super(32, flags, name, type, symbol);
        }

        public String toString() {
            if ((this.flags() & 0x80000) != 0) {
                return String.valueOf("body of ").concat(String.valueOf(this.owner));
            }
            String string = this.name == Names.init ? String.valueOf("constructor ").concat(String.valueOf(this.owner.name)) : String.valueOf("method ").concat(String.valueOf(this.name));
            return String.valueOf(String.valueOf(String.valueOf(string).concat(String.valueOf("("))).concat(String.valueOf(this.type.argtypes().toString()))).concat(String.valueOf(")"));
        }

        public String location() {
            Symbol symbol;
            if ((this.flags_field & 0x100000) != 0 && (symbol = this.implemented((TypeSymbol)this.owner)) != null) {
                return symbol.location();
            }
            return super.location();
        }

        private Symbol implemented(TypeSymbol c) {
            Symbol impl = null;
            List<Type> is = c.type.interfaces();
            while (impl == null && is.nonEmpty()) {
                TypeSymbol i = ((Type)is.head).tsym;
                Scope.Entry entry = i.members().lookup(this.name);
                while (impl == null && entry.scope != null) {
                    if (this.overrides(entry.sym, (TypeSymbol)this.owner) && this.type.restype().sameType(this.owner.type.memberType(entry.sym).restype())) {
                        impl = entry.sym;
                    }
                    if (impl == null) {
                        impl = this.implemented(i);
                    }
                    entry = entry.next();
                }
                is = is.tail;
            }
            return impl;
        }

        public boolean overrides(Symbol other, TypeSymbol typeSymbol) {
            return !this.isConstructor() && other.kind == 32 && (other.flags() & 2) == 0 && typeSymbol.type.memberType(this).sameArgs(typeSymbol.type.memberType(other));
        }

        public MethodSymbol implementation(TypeSymbol origin) {
            Type t = origin.type;
            while (t.tag == 10) {
                TypeSymbol c = t.tsym;
                Scope.Entry e = c.members().lookup(this.name);
                while (e.scope != null) {
                    MethodSymbol methodSymbol;
                    if (e.sym.kind == 32 && (methodSymbol = (MethodSymbol)e.sym).overrides(this, origin) && (methodSymbol.flags() & 0x10000) == 0) {
                        return methodSymbol;
                    }
                    e = e.next();
                }
                t = t.supertype();
            }
            return null;
        }
    }

    public static class VarSymbol
    extends Symbol {
        public int pos = 0;
        public int adr = -1;
        public Object constValue;
        public Type mergeType;
        public static final List<VarSymbol> emptyList = new List();

        public VarSymbol(int flags, Name name, Type type, Symbol symbol) {
            super(4, flags, name, type, symbol);
        }

        public String toString() {
            return String.valueOf("variable ").concat(String.valueOf(this.name));
        }
    }

    public static class ClassSymbol
    extends TypeSymbol {
        public Scope members_field = null;
        public Name fullname;
        public Name flatname;
        public Name sourcefile;
        public FileEntry classfile;
        public Pool pool;
        private int rank_field = -1;
        public static final List<ClassSymbol> emptyList = new List();

        public ClassSymbol(int flags, Name name, Type type, Symbol symbol) {
            super(flags, name, type, symbol);
            this.fullname = TypeSymbol.formFullName(name, symbol);
            this.flatname = TypeSymbol.formFlatName(name, symbol);
            this.sourcefile = null;
            this.classfile = null;
            this.pool = null;
        }

        public ClassSymbol(int flags, Name name, Symbol symbol) {
            this(flags, name, new Type.ClassType(Type.noType, Type.emptyList, null), symbol);
            if (this.type != null) {
                this.type.tsym = this;
            }
        }

        public String toString() {
            return String.valueOf((this.flags_field & 0x200) != 0 ? "interface " : "class ").concat(String.valueOf(this.className()));
        }

        public int flags() {
            if (this.completer != null) {
                this.complete();
            }
            return this.flags_field;
        }

        public Scope members() {
            if (this.completer != null) {
                this.complete();
            }
            return this.members_field;
        }

        public Type erasure() {
            if (this.erasure_field == null) {
                this.erasure_field = this.type.isParameterized() ? new Type.ClassType(this.type.outer().erasure(), Type.emptyList, this) : this.type;
            }
            return this.erasure_field;
        }

        public String className() {
            if (this.name.len == 0) {
                return String.valueOf(String.valueOf("<anonymous ").concat(String.valueOf(this.flatname))).concat(String.valueOf(">"));
            }
            return this.fullname.toString();
        }

        public Name fullName() {
            return this.fullname;
        }

        public Name flatName() {
            return this.flatname;
        }

        public boolean subclass(Symbol base) {
            if (this == base) {
                return true;
            }
            if ((base.flags() & 0x200) != 0) {
                Type t = this.type;
                while (t.tag == 10) {
                    List<Type> is = t.interfaces();
                    while (is.nonEmpty()) {
                        if (((Type)is.head).tsym.subclass(base)) {
                            return true;
                        }
                        is = is.tail;
                    }
                    t = t.supertype();
                }
            } else {
                Type type = this.type;
                while (type.tag == 10) {
                    if (type.tsym == base) {
                        return true;
                    }
                    type = type.supertype();
                }
            }
            return false;
        }

        public int rank() {
            if (this.rank_field < 0) {
                if (this.fullName() == Names.java_lang_Object) {
                    this.rank_field = 0;
                } else {
                    int r = this.type.supertype().tsym.rank();
                    List<Type> list = this.type.interfaces();
                    while (list.nonEmpty()) {
                        if (((Type)list.head).tsym.rank() > r) {
                            r = ((Type)list.head).tsym.rank();
                        }
                        list = list.tail;
                    }
                    this.rank_field = r + 1;
                }
            }
            return this.rank_field;
        }

        public boolean precedes(TypeSymbol typeSymbol) {
            return typeSymbol.rank() < this.rank() || typeSymbol.rank() == this.rank() && this.less(typeSymbol.fullName(), this.fullname);
        }

        private boolean less(Name n1, Name n2) {
            int n;
            int i = n1.index + n1.len - 1;
            for (n = n2.index + n2.len - 1; i != n1.index && n != n2.index && Name.names[i] == Name.names[n]; --i, --n) {
            }
            if (n == n2.index) {
                return false;
            }
            if (i == n1.index) {
                return true;
            }
            return Name.names[i] < Name.names[n];
        }
    }

    public static class PackageSymbol
    extends TypeSymbol {
        public Scope members_field;
        public Name fullname;

        public PackageSymbol(Name name, Type type, Symbol symbol) {
            super(0, name, type, symbol);
            this.kind = 1;
            this.members_field = null;
            this.fullname = TypeSymbol.formFullName(name, symbol);
        }

        public PackageSymbol(Name name, Symbol symbol) {
            this(name, null, symbol);
            this.type = new Type.PackageType(this);
        }

        public String toString() {
            return String.valueOf("package ").concat(String.valueOf(this.fullname));
        }

        public Name fullName() {
            return this.fullname;
        }

        public Scope members() {
            if (this.completer != null) {
                this.complete();
            }
            return this.members_field;
        }

        public int flags() {
            if (this.completer != null) {
                this.complete();
            }
            return this.flags_field;
        }

        public boolean exists() {
            return (this.flags() & 0x1000000) != 0 || this.members().elems != null;
        }
    }

    public static class TypeSymbol
    extends Symbol {
        public TypeSymbol(int flags, Name name, Type type, Symbol symbol) {
            super(2, flags, name, type, symbol);
        }

        public String toString() {
            return String.valueOf("type variable ").concat(String.valueOf(this.name));
        }

        public static Name formFullName(Name name, Symbol owner) {
            if (owner == null || (owner.kind & 0x24) != 0) {
                return name;
            }
            Name prefix = owner.fullName();
            if (prefix == null || prefix.len == 0) {
                return name;
            }
            return prefix.append(Names.period).append(name);
        }

        public static Name formFlatName(Name name, Symbol owner) {
            if (owner == null || (owner.kind & 0x24) != 0) {
                return name;
            }
            Name sep = owner.kind == 2 ? Names.dollar : Names.period;
            Name prefix = owner.flatName();
            if (prefix == null || prefix.len == 0) {
                return name;
            }
            return prefix.append(sep).append(name);
        }

        public int rank() {
            throw new InternalError();
        }

        public boolean precedes(TypeSymbol typeSymbol) {
            throw new InternalError();
        }

        public boolean exists() {
            return true;
        }
    }
}

