/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.code;

import gjc.v6.code.Symbol;
import gjc.v6.util.Name;

public class Scope {
    public Scope next;
    public Symbol owner;
    public Entry[] table;
    int hashMask;
    public Entry elems;
    int nelems = 0;
    private static final Entry sentinel = new Entry(null, null, null, null);
    private static final int INITIAL_SIZE = 128;
    public static final Scope emptyScope = new Scope(null, null, new Entry[0]);
    public static final Scope errScope = new Scope(null);
    public static int count = 0;

    Scope(Scope next, Symbol owner, Entry[] entryArray) {
        this.next = next;
        this.owner = owner;
        this.table = entryArray;
        this.hashMask = entryArray.length - 1;
        this.elems = null;
        this.nelems = 0;
    }

    public Scope(Symbol owner) {
        this(null, owner, new Entry[128]);
        for (int i = 0; i < 128; ++i) {
            this.table[i] = sentinel;
        }
    }

    public Scope dup() {
        return new Scope(this, this.owner, this.table);
    }

    public Scope leave() {
        while (this.elems != null) {
            int hash = this.elems.sym.name.index & this.hashMask;
            Entry entry = this.table[hash];
            if (entry != this.elems) {
                throw new InternalError(this.elems.sym.toString());
            }
            this.table[hash] = this.elems.shadowed;
            this.elems = this.elems.sibling;
        }
        return this.next;
    }

    private void dble() {
        Entry[] oldtable = this.table;
        Entry[] newtable = new Entry[oldtable.length * 2];
        Scope s = this;
        do {
            s.table = newtable;
            s.hashMask = newtable.length - 1;
        } while ((s = s.next) != null);
        for (int i = 0; i < newtable.length; ++i) {
            newtable[i] = sentinel;
        }
        for (int i = 0; i < oldtable.length; ++i) {
            this.copy(oldtable[i]);
        }
    }

    private void copy(Entry e) {
        if (e.sym != null) {
            this.copy(e.shadowed);
            int n = e.sym.name.index & this.hashMask;
            e.shadowed = this.table[n];
            this.table[n] = e;
        }
    }

    public void enter(Symbol sym) {
        Entry entry;
        if (this.nelems * 3 >= this.hashMask * 2) {
            this.dble();
        }
        int hash = sym.name.index & this.hashMask;
        this.table[hash] = entry = new Entry(sym, this.table[hash], this.elems, this);
        this.elems = entry;
        ++this.nelems;
    }

    public void enterIfAbsent(Symbol sym) {
        Entry entry = this.lookup(sym.name);
        while (entry.scope == this && entry.sym.kind != sym.kind) {
            entry = entry.next();
        }
        if (entry.scope != this) {
            this.enter(sym);
        }
    }

    public Entry lookup(Name name) {
        Entry entry = this.table[name.index & this.hashMask];
        while (entry.scope != null && entry.sym.name != name) {
            entry = entry.shadowed;
        }
        if (entry.scope == null && this == errScope) {
            return new Entry(Symbol.errSymbol, null, null, null);
        }
        return entry;
    }

    public static class Entry {
        public Symbol sym;
        public Entry shadowed;
        public Entry sibling;
        public Scope scope;
        public static int count = 0;

        public Entry(Symbol sym, Entry shadowed, Entry sibling, Scope scope) {
            this.sym = sym;
            this.shadowed = shadowed;
            this.sibling = sibling;
            this.scope = scope;
        }

        public Entry next() {
            Entry entry = this.shadowed;
            while (entry.scope != null && entry.sym.name != this.sym.name) {
                entry = entry.shadowed;
            }
            return entry;
        }
    }
}

