/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.code;

import gjc.v6.util.Hashtable;

public class Pool {
    int pp;
    Object[] pool;
    Hashtable<Object, Integer> indices;

    public Pool(int pp, Object[] pool) {
        this.pp = pp;
        this.pool = pool;
        this.indices = new Hashtable(pool.length);
        for (int i = 1; i < pp; ++i) {
            if (pool[i] == null) continue;
            this.indices.put(pool[i], new Integer(i));
        }
    }

    public Pool() {
        this(1, new Object[64]);
    }

    public void reset() {
        this.pp = 1;
        this.indices.reset();
    }

    private void doublePool() {
        Object[] objectArray = new Object[this.pool.length * 2];
        System.arraycopy(this.pool, 0, objectArray, 0, this.pool.length);
        this.pool = objectArray;
    }

    public int put(Object value) {
        Integer n = this.indices.get(value);
        if (n == null) {
            n = new Integer(this.pp);
            this.indices.put(value, n);
            if (this.pp == this.pool.length) {
                this.doublePool();
            }
            this.pool[this.pp++] = value;
            if (value instanceof Long || value instanceof Double) {
                if (this.pp == this.pool.length) {
                    this.doublePool();
                }
                this.pool[this.pp++] = null;
            }
        }
        return n;
    }

    public int get(Object o) {
        Integer n = this.indices.get(o);
        return n == null ? -1 : n;
    }
}

