/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.code;

import gjc.v6.code.ByteCodes;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.code.TypeTags;
import gjc.v6.util.Base;
import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;
import gjc.v6.util.Position;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Code
implements ByteCodes,
TypeTags {
    static final boolean debugCode = false;
    public int max_stack = 0;
    public int max_locals = 0;
    public byte[] code = new byte[64];
    public int cp = 0;
    ListBuffer<char[]> catchInfo = new ListBuffer();
    List<char[]> lineInfo = new List();
    char[] lvar_start_pc = new char[4];
    char[] lvar_length = new char[4];
    char[] lvar_reg = new char[4];
    Symbol.VarSymbol[] lvar = new Symbol.VarSymbol[4];
    int nvars = 0;
    public boolean fatcode;
    public boolean alive = true;
    public int stacksize = 0;
    private boolean fixedPc = false;
    public int nextadr = 0;
    private int nextreg = 0;
    private int[] adrmap = new int[64];
    boolean debugInfo;
    private static int[] stackdiff = new int[203];
    private static String[] mnem;

    public Code(boolean fatcode, boolean bl) {
        this.fatcode = fatcode;
        this.debugInfo = bl;
    }

    public static int typecode(Type type) {
        switch (type.tag) {
            case 1: {
                return 5;
            }
            case 3: {
                return 7;
            }
            case 2: {
                return 6;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 8: {
                return 5;
            }
            case 9: {
                return 8;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                return 4;
            }
        }
        throw new InternalError(String.valueOf("typecode ").concat(String.valueOf(type.tag)));
    }

    public static int truncate(int tc) {
        switch (tc) {
            case 5: 
            case 6: 
            case 7: {
                return 0;
            }
        }
        return tc;
    }

    public static int shortcode(Type type) {
        return Code.truncate(Code.typecode(type));
    }

    public static int width(int typecode) {
        switch (typecode) {
            case 1: 
            case 3: {
                return 2;
            }
            case 8: {
                return 0;
            }
        }
        return 1;
    }

    public static int width(Type type) {
        return Code.width(Code.typecode(type));
    }

    public static int width(List<Type> types) {
        int w = 0;
        List<Type> l = types;
        while (l.nonEmpty()) {
            w += Code.width((Type)l.head);
            l = l.tail;
        }
        return w;
    }

    public static int arraycode(Type type) {
        switch (type.tag) {
            case 1: {
                return 8;
            }
            case 8: {
                return 4;
            }
            case 3: {
                return 9;
            }
            case 2: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case 5: {
                return 11;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 10: {
                return 0;
            }
            case 11: {
                return 1;
            }
        }
        throw new InternalError(String.valueOf("arraycode ").concat(String.valueOf(type)));
    }

    public int curPc() {
        this.fixedPc = true;
        return this.cp;
    }

    public void emit1(int od) {
        if (this.alive) {
            if (this.cp == this.code.length) {
                byte[] byArray = new byte[this.cp * 2];
                System.arraycopy(this.code, 0, byArray, 0, this.cp);
                this.code = byArray;
            }
            this.code[this.cp++] = (byte)od;
        }
    }

    public void emit2(int n) {
        if (this.alive) {
            if (this.cp + 2 > this.code.length) {
                this.emit1(n >> 8);
                this.emit1(n);
            } else {
                this.code[this.cp++] = (byte)(n >> 8);
                this.code[this.cp++] = (byte)n;
            }
        }
    }

    public void emit4(int n) {
        if (this.alive) {
            if (this.cp + 4 > this.code.length) {
                this.emit1(n >> 24);
                this.emit1(n >> 16);
                this.emit1(n >> 8);
                this.emit1(n);
            } else {
                this.code[this.cp++] = (byte)(n >> 24);
                this.code[this.cp++] = (byte)(n >> 16);
                this.code[this.cp++] = (byte)(n >> 8);
                this.code[this.cp++] = (byte)n;
            }
        }
    }

    public void emitop(int op, int n) {
        if (this.alive) {
            this.emit1(op);
            if (n <= -1000) {
                this.stacksize = this.stacksize + n + 1000;
                this.alive = false;
                Base._assert(this.stacksize == 0);
            } else {
                this.stacksize += n;
                Base._assert(this.stacksize >= 0);
                if (this.stacksize > this.max_stack) {
                    this.max_stack = this.stacksize;
                }
            }
        }
    }

    public void emitop(int n) {
        this.emitop(n, stackdiff[n]);
    }

    public void emitop1(int op, int n) {
        this.emitop(op);
        this.emit1(n);
    }

    public void emitop1w(int op, int n) {
        if (n > 255) {
            this.emit1(196);
            this.emitop2(op, n);
        } else {
            this.emitop1(op, n);
        }
    }

    public void emitop2(int op, int n) {
        this.emitop(op);
        this.emit2(n);
    }

    public void emitop4(int op, int n) {
        this.emitop(op);
        this.emit4(n);
    }

    public void align(int n) {
        if (this.alive) {
            while (this.cp % n != 0) {
                this.emit1(0);
            }
        }
    }

    public void put1(int pc, int n) {
        this.code[pc] = (byte)n;
    }

    public void put2(int pc, int n) {
        this.put1(pc, n >> 8);
        this.put1(pc + 1, n);
    }

    public void put4(int pc, int n) {
        this.put1(pc, n >> 24);
        this.put1(pc + 1, n >> 16);
        this.put1(pc + 2, n >> 8);
        this.put1(pc + 3, n);
    }

    public int get1(int n) {
        return this.code[n] & 0xFF;
    }

    public int get4(int n) {
        return this.get1(n) << 24 | this.get1(n + 1) << 16 | this.get1(n + 2) << 8 | this.get1(n + 3);
    }

    public void clearStack() {
        this.stacksize = 0;
    }

    public void pushStack(int n) {
        this.stacksize += Code.width(n);
        if (this.stacksize > this.max_stack) {
            this.max_stack = this.stacksize;
        }
    }

    public void popStack(int n) {
        this.stacksize -= Code.width(n);
    }

    public static int negate(int opcode) {
        return (opcode + 1 ^ 1) - 1;
    }

    public void emitJump(Chain chain, int n) {
        if (this.fatcode) {
            if (n == 167 || n == 168) {
                this.emitop4(n + 200 - 167, 0);
            } else {
                this.emitop2(Code.negate(n), 8);
                this.emitop4(200, 0);
                chain.pc += 3;
            }
        } else {
            this.emitop2(n, 0);
        }
    }

    public Chain branch(int opcode) {
        if (opcode == 168 || !this.alive) {
            return null;
        }
        int sdiff = stackdiff[opcode];
        Chain chain = new Chain(this.cp, null, this.stacksize + sdiff);
        this.emitJump(chain, opcode);
        this.fixedPc = this.fatcode;
        if (opcode == 167) {
            this.alive = false;
        }
        return chain;
    }

    public void resolve(Chain chain, int n) {
        if (chain != null) {
            Base._assert(n > chain.pc || this.stacksize == 0);
            if (n > this.cp) {
                n = this.cp;
            }
            if (this.get1(chain.pc) == 167 && chain.pc + 3 == n && n == this.cp && !this.fixedPc) {
                this.cp -= 3;
                n -= 3;
            } else {
                if (this.fatcode) {
                    this.put4(chain.pc + 1, n - chain.pc);
                } else if (n - chain.pc < Short.MIN_VALUE || n - chain.pc > Short.MAX_VALUE) {
                    this.fatcode = true;
                } else {
                    this.put2(chain.pc + 1, n - chain.pc);
                }
                Base._assert(!this.alive || chain.stacksize == this.stacksize);
            }
            this.fixedPc = true;
            this.resolve(chain.next, n);
            if (this.cp == n) {
                this.stacksize = chain.stacksize;
                this.alive = true;
            }
        }
    }

    public void resolve(Chain chain) {
        this.resolve(chain, this.cp);
    }

    public static Chain mergeChains(Chain chain1, Chain chain2) {
        if (chain2 == null) {
            return chain1;
        }
        if (chain1 == null) {
            return chain2;
        }
        Base._assert(chain1.stacksize == chain2.stacksize);
        return new Chain(chain2.pc, Code.mergeChains(chain1, chain2.next), chain2.stacksize);
    }

    public void addCatch(char startPc, char endPc, char handlerPc, char c) {
        this.catchInfo.append(new char[]{startPc, endPc, handlerPc, c});
    }

    public void addLineNumber(char startPc, char c) {
        if (this.debugInfo) {
            if (this.lineInfo.nonEmpty() && ((char[])this.lineInfo.head)[0] == startPc) {
                this.lineInfo = this.lineInfo.tail;
            }
            this.lineInfo = this.lineInfo.prepend(new char[]{startPc, c});
        }
    }

    public void statBegin(int pos) {
        if (pos != 0 && this.alive) {
            Base._assert(this.stacksize == 0);
            int line = Position.line(pos);
            char cp1 = (char)this.cp;
            char c = (char)line;
            if (cp1 == this.cp && c == line) {
                this.addLineNumber(cp1, c);
            }
        }
    }

    public void addLocalVar(int reg, Symbol.VarSymbol v) {
        while (v.adr >= this.lvar.length) {
            char[] new_lvar_start_pc = new char[this.lvar.length * 2];
            char[] new_lvar_length = new char[this.lvar.length * 2];
            char[] new_lvar_reg = new char[this.lvar.length * 2];
            Symbol.VarSymbol[] new_lvar = new Symbol.VarSymbol[this.lvar.length * 2];
            for (int i = 0; i < this.lvar.length; ++i) {
                new_lvar_start_pc[i] = this.lvar_start_pc[i];
                new_lvar_length[i] = this.lvar_length[i];
                new_lvar_reg[i] = this.lvar_reg[i];
                new_lvar[i] = this.lvar[i];
            }
            this.lvar_start_pc = new_lvar_start_pc;
            this.lvar_length = new_lvar_length;
            this.lvar_reg = new_lvar_reg;
            this.lvar = new_lvar;
        }
        this.lvar_start_pc[v.adr] = 65535;
        this.lvar_length[v.adr] = 65535;
        this.lvar_reg[v.adr] = (char)reg;
        this.lvar[v.adr] = v;
        ++this.nvars;
    }

    public void setStartPc(int n) {
        if (this.debugInfo && this.cp < 65535 && n < this.lvar_start_pc.length && this.lvar_start_pc[n] == '\uffff') {
            this.lvar_start_pc[n] = (char)this.cp;
        }
    }

    public void setEndPc(int n) {
        if (this.debugInfo && n < this.lvar_start_pc.length && this.lvar_start_pc[n] != '\uffff' && this.cp - this.lvar_start_pc[n] < 65535 && this.lvar_length[n] == '\uffff') {
            this.lvar_length[n] = (char)(this.curPc() - this.lvar_start_pc[n]);
        }
    }

    public int newLocal(int typecode) {
        int adr = this.nextadr++;
        int w = Code.width(typecode);
        int reg = this.nextreg;
        this.nextreg = reg + w;
        if (this.nextreg > this.max_locals) {
            this.max_locals = this.nextreg;
        }
        while (adr >= this.adrmap.length) {
            int[] nArray = new int[this.adrmap.length * 2];
            System.arraycopy(this.adrmap, 0, nArray, 0, this.adrmap.length);
            this.adrmap = nArray;
        }
        this.adrmap[adr] = w == 2 ? -reg : reg;
        return adr;
    }

    public int newLocal(Type type) {
        return this.newLocal(Code.typecode(type));
    }

    public int newLocal(Symbol.VarSymbol varSymbol) {
        varSymbol.adr = this.newLocal(varSymbol.erasure());
        if (this.debugInfo) {
            this.addLocalVar(this.regOf(varSymbol.adr), varSymbol);
        }
        return varSymbol.adr;
    }

    public int regOf(int adr) {
        int n = this.adrmap[adr];
        if (n < 0) {
            n = -n;
        }
        return n;
    }

    public void newRegSegment() {
        this.nextreg = this.max_locals;
    }

    public void endScopes(int first) {
        if (first < this.nextadr) {
            for (int i = first; i < this.nextadr; ++i) {
                this.setEndPc(i);
            }
            this.nextreg = this.regOf(first);
        }
    }

    static {
        Code.stackdiff[0] = 0;
        Code.stackdiff[1] = 1;
        Code.stackdiff[2] = 1;
        Code.stackdiff[3] = 1;
        Code.stackdiff[4] = 1;
        Code.stackdiff[5] = 1;
        Code.stackdiff[6] = 1;
        Code.stackdiff[7] = 1;
        Code.stackdiff[8] = 1;
        Code.stackdiff[9] = 2;
        Code.stackdiff[10] = 2;
        Code.stackdiff[11] = 1;
        Code.stackdiff[12] = 1;
        Code.stackdiff[13] = 1;
        Code.stackdiff[14] = 2;
        Code.stackdiff[15] = 2;
        Code.stackdiff[16] = 1;
        Code.stackdiff[17] = 1;
        Code.stackdiff[18] = -999;
        Code.stackdiff[19] = -999;
        Code.stackdiff[20] = -999;
        Code.stackdiff[21] = 1;
        Code.stackdiff[22] = 2;
        Code.stackdiff[23] = 1;
        Code.stackdiff[24] = 2;
        Code.stackdiff[25] = 1;
        Code.stackdiff[26] = 1;
        Code.stackdiff[30] = 2;
        Code.stackdiff[34] = 1;
        Code.stackdiff[38] = 2;
        Code.stackdiff[42] = 1;
        Code.stackdiff[27] = 1;
        Code.stackdiff[31] = 2;
        Code.stackdiff[35] = 1;
        Code.stackdiff[39] = 2;
        Code.stackdiff[43] = 1;
        Code.stackdiff[28] = 1;
        Code.stackdiff[32] = 2;
        Code.stackdiff[36] = 1;
        Code.stackdiff[40] = 2;
        Code.stackdiff[44] = 1;
        Code.stackdiff[29] = 1;
        Code.stackdiff[33] = 2;
        Code.stackdiff[37] = 1;
        Code.stackdiff[41] = 2;
        Code.stackdiff[45] = 1;
        Code.stackdiff[46] = -1;
        Code.stackdiff[47] = 0;
        Code.stackdiff[48] = -1;
        Code.stackdiff[49] = 0;
        Code.stackdiff[50] = -1;
        Code.stackdiff[51] = -1;
        Code.stackdiff[52] = -1;
        Code.stackdiff[53] = -1;
        Code.stackdiff[54] = -1;
        Code.stackdiff[55] = -2;
        Code.stackdiff[56] = -1;
        Code.stackdiff[57] = -2;
        Code.stackdiff[58] = -1;
        Code.stackdiff[59] = -1;
        Code.stackdiff[63] = -2;
        Code.stackdiff[67] = -1;
        Code.stackdiff[71] = -2;
        Code.stackdiff[75] = -1;
        Code.stackdiff[60] = -1;
        Code.stackdiff[64] = -2;
        Code.stackdiff[68] = -1;
        Code.stackdiff[72] = -2;
        Code.stackdiff[76] = -1;
        Code.stackdiff[61] = -1;
        Code.stackdiff[65] = -2;
        Code.stackdiff[69] = -1;
        Code.stackdiff[73] = -2;
        Code.stackdiff[77] = -1;
        Code.stackdiff[62] = -1;
        Code.stackdiff[66] = -2;
        Code.stackdiff[70] = -1;
        Code.stackdiff[74] = -2;
        Code.stackdiff[78] = -1;
        Code.stackdiff[79] = -3;
        Code.stackdiff[80] = -4;
        Code.stackdiff[81] = -3;
        Code.stackdiff[82] = -4;
        Code.stackdiff[83] = -3;
        Code.stackdiff[84] = -3;
        Code.stackdiff[85] = -3;
        Code.stackdiff[86] = -3;
        Code.stackdiff[87] = -1;
        Code.stackdiff[88] = -2;
        Code.stackdiff[89] = 1;
        Code.stackdiff[90] = 1;
        Code.stackdiff[91] = 1;
        Code.stackdiff[92] = 2;
        Code.stackdiff[93] = 2;
        Code.stackdiff[94] = 2;
        Code.stackdiff[95] = 0;
        Code.stackdiff[96] = -1;
        Code.stackdiff[97] = -2;
        Code.stackdiff[98] = -1;
        Code.stackdiff[99] = -2;
        Code.stackdiff[100] = -1;
        Code.stackdiff[101] = -2;
        Code.stackdiff[102] = -1;
        Code.stackdiff[103] = -2;
        Code.stackdiff[104] = -1;
        Code.stackdiff[105] = -2;
        Code.stackdiff[106] = -1;
        Code.stackdiff[107] = -2;
        Code.stackdiff[108] = -1;
        Code.stackdiff[109] = -2;
        Code.stackdiff[110] = -1;
        Code.stackdiff[111] = -2;
        Code.stackdiff[112] = -1;
        Code.stackdiff[113] = -2;
        Code.stackdiff[114] = -1;
        Code.stackdiff[115] = -2;
        Code.stackdiff[116] = 0;
        Code.stackdiff[117] = 0;
        Code.stackdiff[118] = 0;
        Code.stackdiff[119] = 0;
        Code.stackdiff[120] = -1;
        Code.stackdiff[121] = -1;
        Code.stackdiff[122] = -1;
        Code.stackdiff[123] = -1;
        Code.stackdiff[124] = -1;
        Code.stackdiff[125] = -1;
        Code.stackdiff[126] = -1;
        Code.stackdiff[127] = -2;
        Code.stackdiff[128] = -1;
        Code.stackdiff[129] = -2;
        Code.stackdiff[130] = -1;
        Code.stackdiff[131] = -2;
        Code.stackdiff[132] = 0;
        Code.stackdiff[133] = 1;
        Code.stackdiff[134] = 0;
        Code.stackdiff[135] = 1;
        Code.stackdiff[136] = -1;
        Code.stackdiff[137] = -1;
        Code.stackdiff[138] = 0;
        Code.stackdiff[139] = 0;
        Code.stackdiff[140] = 1;
        Code.stackdiff[141] = 1;
        Code.stackdiff[142] = -1;
        Code.stackdiff[143] = 0;
        Code.stackdiff[144] = -1;
        Code.stackdiff[145] = 0;
        Code.stackdiff[146] = 0;
        Code.stackdiff[147] = 0;
        Code.stackdiff[148] = -3;
        Code.stackdiff[149] = -1;
        Code.stackdiff[150] = -1;
        Code.stackdiff[151] = -3;
        Code.stackdiff[152] = -3;
        Code.stackdiff[153] = -1;
        Code.stackdiff[154] = -1;
        Code.stackdiff[155] = -1;
        Code.stackdiff[156] = -1;
        Code.stackdiff[157] = -1;
        Code.stackdiff[158] = -1;
        Code.stackdiff[159] = -2;
        Code.stackdiff[160] = -2;
        Code.stackdiff[161] = -2;
        Code.stackdiff[162] = -2;
        Code.stackdiff[163] = -2;
        Code.stackdiff[164] = -2;
        Code.stackdiff[165] = -2;
        Code.stackdiff[166] = -2;
        Code.stackdiff[167] = 0;
        Code.stackdiff[168] = 0;
        Code.stackdiff[169] = 0;
        Code.stackdiff[170] = -1;
        Code.stackdiff[171] = -1;
        Code.stackdiff[172] = -1001;
        Code.stackdiff[173] = -1002;
        Code.stackdiff[174] = -1001;
        Code.stackdiff[175] = -1002;
        Code.stackdiff[176] = -1001;
        Code.stackdiff[177] = -1000;
        Code.stackdiff[178] = -999;
        Code.stackdiff[179] = -999;
        Code.stackdiff[180] = -999;
        Code.stackdiff[181] = -999;
        Code.stackdiff[182] = -999;
        Code.stackdiff[183] = -999;
        Code.stackdiff[184] = -999;
        Code.stackdiff[185] = -999;
        Code.stackdiff[186] = 0;
        Code.stackdiff[187] = 1;
        Code.stackdiff[188] = 0;
        Code.stackdiff[189] = 0;
        Code.stackdiff[190] = 0;
        Code.stackdiff[191] = -1001;
        Code.stackdiff[192] = 0;
        Code.stackdiff[193] = 0;
        Code.stackdiff[194] = -1;
        Code.stackdiff[195] = -1;
        Code.stackdiff[196] = 0;
        Code.stackdiff[197] = -999;
        Code.stackdiff[198] = -1;
        Code.stackdiff[199] = -1;
        Code.stackdiff[200] = 0;
        Code.stackdiff[201] = 0;
        Code.stackdiff[202] = 0;
        mnem = new String[203];
    }

    public static class Chain {
        public Chain next;
        public int pc;
        public int stacksize;

        public Chain(int pc, Chain next, int n) {
            this.pc = pc;
            this.next = next;
            this.stacksize = n;
        }
    }
}

