/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.code;

import gjc.v6.code.ClassFile;
import gjc.v6.code.Code;
import gjc.v6.code.Flags;
import gjc.v6.code.Kinds;
import gjc.v6.code.Pool;
import gjc.v6.code.Scope;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.code.TypeTags;
import gjc.v6.util.Base;
import gjc.v6.util.ByteBuffer;
import gjc.v6.util.Convert;
import gjc.v6.util.Hashtable;
import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;
import gjc.v6.util.Name;
import gjc.v6.util.Names;
import gjc.v6.util.Set;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassWriter
extends ClassFile
implements Flags,
Kinds,
TypeTags {
    public File outDir = null;
    public boolean verbose;
    public boolean scramble;
    public boolean scrambleAll;
    public boolean retrofit;
    static final int DATA_BUF_SIZE = 65536;
    static final int POOL_BUF_SIZE = 131072;
    ByteBuffer databuf = new ByteBuffer(65536);
    ByteBuffer poolbuf = new ByteBuffer(131072);
    Pool pool;
    Set<Symbol.ClassSymbol> innerClasses;
    ListBuffer<Symbol.ClassSymbol> innerClassesQueue;

    public ClassWriter(Hashtable<String, String> options) {
        this.verbose = options.get("-verbose") != null;
        this.scramble = options.get("-scramble") != null;
        this.scrambleAll = options.get("-scrambleAll") != null;
        this.retrofit = options.get("-retrofit") != null;
        String string = options.get("-d");
        if (string != null) {
            this.outDir = new File(string);
        }
    }

    void putChar(ByteBuffer buf, int op, int n) {
        buf.elems[op] = (byte)(n >> 8 & 0xFF);
        buf.elems[op + 1] = (byte)(n & 0xFF);
    }

    void putInt(ByteBuffer buf, int adr, int n) {
        buf.elems[adr] = (byte)(n >> 24 & 0xFF);
        buf.elems[adr + 1] = (byte)(n >> 16 & 0xFF);
        buf.elems[adr + 2] = (byte)(n >> 8 & 0xFF);
        buf.elems[adr + 3] = (byte)(n & 0xFF);
    }

    void assembleSig(ByteBuffer buf, Type type) {
        switch (type.tag) {
            case 1: {
                buf.appendByte(66);
                break;
            }
            case 3: {
                buf.appendByte(83);
                break;
            }
            case 2: {
                buf.appendByte(67);
                break;
            }
            case 4: {
                buf.appendByte(73);
                break;
            }
            case 5: {
                buf.appendByte(74);
                break;
            }
            case 6: {
                buf.appendByte(70);
                break;
            }
            case 7: {
                buf.appendByte(68);
                break;
            }
            case 8: {
                buf.appendByte(90);
                break;
            }
            case 9: {
                buf.appendByte(86);
                break;
            }
            case 10: {
                Type.ClassType ct = (Type.ClassType)type;
                Symbol.ClassSymbol c = (Symbol.ClassSymbol)ct.tsym;
                this.enterInner(c);
                if (ct.outer().allParams().nonEmpty()) {
                    this.assembleSig(buf, ct.outer());
                    buf.appendByte(46);
                }
                buf.appendByte(76);
                buf.appendBytes(ClassFile.externalize(c.flatname));
                if (ct.typarams().nonEmpty()) {
                    buf.appendByte(60);
                    this.assembleSig(buf, ct.typarams());
                    buf.appendByte(62);
                }
                buf.appendByte(59);
                break;
            }
            case 11: {
                Type.ArrayType at = (Type.ArrayType)type;
                buf.appendByte(91);
                this.assembleSig(buf, at.elemtype);
                break;
            }
            case 12: {
                Type.MethodType mt = (Type.MethodType)type;
                buf.appendByte(40);
                this.assembleSig(buf, mt.argtypes);
                buf.appendByte(41);
                this.assembleSig(buf, mt.restype);
                break;
            }
            case 14: {
                buf.appendByte(84);
                buf.appendName(type.tsym.name);
                buf.appendByte(59);
                break;
            }
            case 15: {
                Type.ForAll forAll = (Type.ForAll)type;
                this.assembleParamsSig(buf, forAll.tvars);
                this.assembleSig(buf, forAll.qtype);
                break;
            }
            default: {
                throw new InternalError(String.valueOf("typeSig").concat(String.valueOf(type.tag)));
            }
        }
    }

    void assembleSig(ByteBuffer buf, List<Type> types) {
        List<Type> list = types;
        while (list.nonEmpty()) {
            this.assembleSig(buf, (Type)list.head);
            list = list.tail;
        }
    }

    void assembleParamsSig(ByteBuffer buf, List<Type> typarams) {
        buf.appendByte(60);
        List<Type> ts = typarams;
        while (ts.nonEmpty()) {
            Type.TypeVar typeVar = (Type.TypeVar)ts.head;
            buf.appendName(typeVar.tsym.name);
            buf.appendByte(58);
            this.assembleSig(buf, typeVar.bound);
            ts = ts.tail;
        }
        buf.appendByte(62);
    }

    Name typeSig(Type type) {
        ByteBuffer byteBuffer = new ByteBuffer();
        this.assembleSig(byteBuffer, type);
        return byteBuffer.toName();
    }

    public Name xClassName(Type type) {
        if (type.tag == 10) {
            return Name.fromUtf(ClassFile.externalize(type.tsym.flatName()));
        }
        if (type.tag == 11) {
            return this.typeSig(type.erasure());
        }
        throw new InternalError("xClassName");
    }

    void writePool(Pool _pool) {
        int poolCountIdx = this.poolbuf.length;
        this.poolbuf.appendChar(0);
        for (int i = 1; i < _pool.pp; ++i) {
            Object value = _pool.pool[i];
            Base._assert(value != null);
            if (value instanceof Name) {
                this.poolbuf.appendByte(1);
                byte[] bs = ((Name)value).toUtf();
                this.poolbuf.appendChar(bs.length);
                this.poolbuf.appendBytes(bs, 0, bs.length);
                continue;
            }
            if (value instanceof Symbol.ClassSymbol) {
                Symbol.ClassSymbol c = (Symbol.ClassSymbol)value;
                if (c.owner.kind == 2) {
                    _pool.put(c.owner);
                }
                this.poolbuf.appendByte(7);
                this.poolbuf.appendChar(_pool.put(Name.fromUtf(ClassFile.externalize(c.flatname))));
                this.enterInner(c);
                continue;
            }
            if (value instanceof Symbol.MethodSymbol) {
                Symbol.MethodSymbol m = (Symbol.MethodSymbol)value;
                this.poolbuf.appendByte((m.owner.flags() & 0x200) != 0 ? 11 : 10);
                this.poolbuf.appendChar(_pool.put(m.owner));
                this.poolbuf.appendChar(_pool.put(this.nameType(m)));
                continue;
            }
            if (value instanceof Symbol.VarSymbol) {
                Symbol.VarSymbol v = (Symbol.VarSymbol)value;
                this.poolbuf.appendByte(9);
                this.poolbuf.appendChar(_pool.put(v.owner));
                this.poolbuf.appendChar(_pool.put(this.nameType(v)));
                continue;
            }
            if (value instanceof ClassFile.NameAndType) {
                ClassFile.NameAndType nameAndType = (ClassFile.NameAndType)value;
                this.poolbuf.appendByte(12);
                this.poolbuf.appendChar(_pool.put(nameAndType.fst));
                this.poolbuf.appendChar(_pool.put(this.typeSig((Type)nameAndType.snd)));
                continue;
            }
            if (value instanceof Integer) {
                this.poolbuf.appendByte(3);
                this.poolbuf.appendInt((Integer)value);
                continue;
            }
            if (value instanceof Long) {
                this.poolbuf.appendByte(5);
                this.poolbuf.appendLong((Long)value);
                ++i;
                continue;
            }
            if (value instanceof Float) {
                this.poolbuf.appendByte(4);
                this.poolbuf.appendFloat(((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                this.poolbuf.appendByte(6);
                this.poolbuf.appendDouble((Double)value);
                ++i;
                continue;
            }
            if (value instanceof String) {
                this.poolbuf.appendByte(8);
                this.poolbuf.appendChar(_pool.put(Name.fromString((String)value)));
                continue;
            }
            if (value instanceof Type) {
                this.poolbuf.appendByte(7);
                this.poolbuf.appendChar(_pool.put(this.xClassName((Type)value)));
                continue;
            }
            throw new InternalError(String.valueOf("writePool ").concat(String.valueOf(value)));
        }
        this.putChar(this.poolbuf, poolCountIdx, _pool.pp);
    }

    Name fieldName(Symbol symbol) {
        if (this.scramble && (symbol.flags() & 2) != 0 || this.scrambleAll && (symbol.flags() & 5) == 0) {
            return Name.fromString(String.valueOf("_$").concat(String.valueOf(symbol.name.index)));
        }
        return symbol.name;
    }

    ClassFile.NameAndType nameType(Symbol symbol) {
        return new ClassFile.NameAndType(this.fieldName(symbol), this.retrofit ? symbol.erasure() : symbol.externalType());
    }

    int writeAttr(Name name) {
        this.databuf.appendChar(this.pool.put(name));
        this.databuf.appendInt(0);
        return this.databuf.length;
    }

    void endAttr(int n) {
        this.putInt(this.databuf, n - 4, this.databuf.length - n);
    }

    int beginAttrs() {
        this.databuf.appendChar(0);
        return this.databuf.length;
    }

    void endAttrs(int index, int n) {
        this.putChar(this.databuf, index - 2, n);
    }

    void enterInner(Symbol.ClassSymbol classSymbol) {
        if (!(classSymbol.owner.kind == 1 || this.innerClasses != null && this.innerClasses.contains(classSymbol))) {
            if (classSymbol.owner.kind == 2) {
                this.enterInner((Symbol.ClassSymbol)classSymbol.owner);
            }
            this.pool.put(classSymbol);
            this.pool.put(classSymbol.name);
            if (this.innerClasses == null) {
                this.innerClasses = Set.make();
                this.innerClassesQueue = new ListBuffer();
                this.pool.put(Names.InnerClasses);
            }
            this.innerClasses.put(classSymbol);
            this.innerClassesQueue.append(classSymbol);
        }
    }

    void writeField(Symbol.VarSymbol v) {
        int alenIdx;
        this.databuf.appendChar(v.flags());
        this.databuf.appendChar(this.pool.put(this.fieldName(v)));
        this.databuf.appendChar(this.pool.put(this.typeSig(v.erasure())));
        int acountIdx = this.beginAttrs();
        int acount = 0;
        if (v.constValue != null) {
            alenIdx = this.writeAttr(Names.ConstantValue);
            this.databuf.appendChar(this.pool.put(v.constValue));
            this.endAttr(alenIdx);
            ++acount;
        }
        if ((v.flags() & 0x20000) != 0) {
            alenIdx = this.writeAttr(Names.Deprecated);
            this.endAttr(alenIdx);
            ++acount;
        }
        if ((v.flags() & 0x10000) != 0) {
            alenIdx = this.writeAttr(Names.Synthetic);
            this.endAttr(alenIdx);
            ++acount;
        }
        if (!v.type.sameType(v.erasure())) {
            int n = this.writeAttr(Names.Signature);
            this.databuf.appendChar(this.pool.put(this.typeSig(v.type)));
            this.endAttr(n);
            ++acount;
        }
        this.endAttrs(acountIdx, acount);
    }

    void writeMethod(Symbol.MethodSymbol m) {
        int alenIdx;
        List<Symbol.ClassSymbol> thrown;
        int nthrown;
        this.databuf.appendChar(m.flags());
        this.databuf.appendChar(this.pool.put(this.fieldName(m)));
        this.databuf.appendChar(this.pool.put(this.typeSig(m.externalType())));
        int acountIdx = this.beginAttrs();
        int acount = 0;
        if (m.code != null) {
            int alenIdx2 = this.writeAttr(Names.Code);
            this.writeCode(m.code);
            m.code = null;
            this.endAttr(alenIdx2);
            ++acount;
        }
        if ((nthrown = (thrown = m.type.thrown()).length()) != 0) {
            alenIdx = this.writeAttr(Names.Exceptions);
            this.databuf.appendChar(nthrown);
            List<Symbol.ClassSymbol> l = thrown;
            while (l.nonEmpty()) {
                this.databuf.appendChar(this.pool.put(l.head));
                l = l.tail;
            }
            this.endAttr(alenIdx);
            ++acount;
        }
        if ((m.flags() & 0x20000) != 0) {
            alenIdx = this.writeAttr(Names.Deprecated);
            this.endAttr(alenIdx);
            ++acount;
        }
        if ((m.flags() & 0x10000) != 0) {
            alenIdx = this.writeAttr(Names.Synthetic);
            this.endAttr(alenIdx);
            ++acount;
        }
        if (m.type != m.erasure()) {
            int n = this.writeAttr(Names.Signature);
            this.databuf.appendChar(this.pool.put(this.typeSig(m.type)));
            this.endAttr(n);
            ++acount;
        }
        this.endAttrs(acountIdx, acount);
    }

    void writeCode(Code code) {
        int alenIdx;
        this.databuf.appendChar(code.max_stack);
        this.databuf.appendChar(code.max_locals);
        this.databuf.appendInt(code.cp);
        this.databuf.appendBytes(code.code, 0, code.cp);
        this.databuf.appendChar(code.catchInfo.length());
        List<Object> l = code.catchInfo.toList();
        while (l.nonEmpty()) {
            for (int i = 0; i < ((char[])l.head).length; ++i) {
                this.databuf.appendChar(((char[])l.head)[i]);
            }
            l = l.tail;
        }
        int acountIdx = this.beginAttrs();
        int acount = 0;
        if (code.lineInfo.nonEmpty()) {
            alenIdx = this.writeAttr(Names.LineNumberTable);
            this.databuf.appendChar(code.lineInfo.length());
            List<Object> l2 = code.lineInfo.reverse();
            while (l2.nonEmpty()) {
                for (int i = 0; i < ((char[])l2.head).length; ++i) {
                    this.databuf.appendChar(((char[])l2.head)[i]);
                }
                l2 = l2.tail;
            }
            this.endAttr(alenIdx);
            ++acount;
        }
        if (code.nvars > 0) {
            alenIdx = this.writeAttr(Names.LocalVariableTable);
            int nvars = code.nvars;
            this.databuf.appendChar(0);
            int lvcountIdx = this.databuf.length;
            int lvcount = 0;
            for (int i = 0; i < nvars; ++i) {
                if (code.lvar[i] == null || code.lvar_start_pc[i] == '\uffff') continue;
                this.databuf.appendChar(code.lvar_start_pc[i]);
                this.databuf.appendChar(code.lvar_length[i]);
                this.databuf.appendChar(this.pool.put(code.lvar[i].name));
                this.databuf.appendChar(this.pool.put(this.typeSig(code.lvar[i].erasure())));
                this.databuf.appendChar(code.lvar_reg[i]);
                ++lvcount;
            }
            this.putChar(this.databuf, lvcountIdx - 2, lvcount);
            this.endAttr(alenIdx);
            ++acount;
        }
        this.endAttrs(acountIdx, acount);
    }

    void writeFields(Scope.Entry entry) {
        if (entry != null) {
            this.writeFields(entry.sibling);
            if (entry.sym.kind == 4) {
                this.writeField((Symbol.VarSymbol)entry.sym);
            }
        }
    }

    void writeMethods(Scope.Entry entry) {
        if (entry != null) {
            this.writeMethods(entry.sibling);
            if (entry.sym.kind == 32) {
                this.writeMethod((Symbol.MethodSymbol)entry.sym);
            }
        }
    }

    public void writeClassFile(OutputStream out, Symbol.ClassSymbol c) throws IOException {
        int alenIdx;
        this.databuf.reset();
        this.poolbuf.reset();
        this.pool = c.pool;
        this.innerClasses = null;
        this.innerClassesQueue = null;
        Type supertype = c.type.supertype();
        List<Type> interfaces = c.type.interfaces();
        List<Type> typarams = c.type.typarams();
        int flags = c.flags();
        if ((flags & 4) != 0) {
            flags |= 1;
        }
        this.databuf.appendChar(flags & 0x2000E11 | 0x20);
        this.databuf.appendChar(this.pool.put(c));
        this.databuf.appendChar(supertype.tag == 10 ? this.pool.put(supertype.tsym) : 0);
        this.databuf.appendChar(interfaces.length());
        List<Type> l = interfaces;
        while (l.nonEmpty()) {
            this.databuf.appendChar(this.pool.put(((Type)l.head).tsym));
            l = l.tail;
        }
        int fieldsCount = 0;
        int methodsCount = 0;
        Scope.Entry e = c.members().elems;
        while (e != null) {
            switch (e.sym.kind) {
                case 4: {
                    ++fieldsCount;
                    break;
                }
                case 32: {
                    ++methodsCount;
                    break;
                }
                case 2: {
                    this.enterInner((Symbol.ClassSymbol)e.sym);
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
            e = e.sibling;
        }
        this.databuf.appendChar(fieldsCount);
        this.writeFields(c.members().elems);
        this.databuf.appendChar(methodsCount);
        this.writeMethods(c.members().elems);
        int acountIdx = this.beginAttrs();
        int acount = 0;
        boolean sigReq = typarams.length() != 0 || supertype.typarams().length() != 0;
        List<Type> l2 = interfaces;
        while (!sigReq && l2.nonEmpty()) {
            sigReq = ((Type)l2.head).typarams().length() != 0;
            l2 = l2.tail;
        }
        if (sigReq) {
            alenIdx = this.writeAttr(Names.Signature);
            ByteBuffer buf = new ByteBuffer();
            if (typarams.length() != 0) {
                this.assembleParamsSig(buf, typarams);
            }
            this.assembleSig(buf, supertype);
            List<Type> l3 = interfaces;
            while (l3.nonEmpty()) {
                this.assembleSig(buf, (Type)l3.head);
                l3 = l3.tail;
            }
            this.databuf.appendChar(this.pool.put(buf.toName()));
            this.endAttr(alenIdx);
            ++acount;
        }
        if (c.sourcefile != null) {
            alenIdx = this.writeAttr(Names.SourceFile);
            this.databuf.appendChar(c.pool.put(c.sourcefile));
            this.endAttr(alenIdx);
            ++acount;
        }
        if ((c.flags() & 0x10000) != 0) {
            alenIdx = this.writeAttr(Names.Synthetic);
            this.endAttr(alenIdx);
            ++acount;
        }
        if ((c.flags() & 0x20000) != 0) {
            alenIdx = this.writeAttr(Names.Deprecated);
            this.endAttr(alenIdx);
            ++acount;
        }
        this.poolbuf.appendInt(-889275714);
        this.poolbuf.appendChar(3);
        this.poolbuf.appendChar(45);
        this.writePool(c.pool);
        if (c.pool.pp > 65535) {
            throw new IOException("too many constants");
        }
        if (this.innerClasses != null) {
            alenIdx = this.writeAttr(Names.InnerClasses);
            this.databuf.appendChar(this.innerClassesQueue.length());
            List<Symbol.ClassSymbol> l4 = this.innerClassesQueue.toList();
            while (l4.nonEmpty()) {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)l4.head;
                this.databuf.appendChar(this.pool.get(classSymbol));
                this.databuf.appendChar(classSymbol.owner.kind == 2 ? this.pool.get(classSymbol.owner) : 0);
                this.databuf.appendChar(classSymbol.name.len != 0 ? this.pool.get(classSymbol.name) : 0);
                this.databuf.appendChar(classSymbol.flags_field);
                l4 = l4.tail;
            }
            this.endAttr(alenIdx);
            ++acount;
        }
        this.endAttrs(acountIdx, acount);
        this.poolbuf.appendBytes(this.databuf.elems, 0, this.databuf.length);
        out.write(this.poolbuf.elems, 0, this.poolbuf.length);
        c.pool = null;
    }

    public File outputFile(Symbol.ClassSymbol c, String extension) throws IOException {
        if (this.outDir == null) {
            String filename = String.valueOf(Convert.shortName(c.flatname)).concat(String.valueOf(extension));
            if (c.sourcefile == null) {
                return new File(filename);
            }
            String string = new File(c.sourcefile.toString()).getParent();
            if (string == null) {
                return new File(filename);
            }
            return new File(string, filename);
        }
        return this.outputFile(this.outDir, c.flatname.toString(), extension);
    }

    File outputFile(File outdir, String name, String extension) throws IOException {
        int start = 0;
        int n = name.indexOf(46);
        while (n >= start) {
            if (!(outdir = new File(outdir, name.substring(start, n))).exists()) {
                outdir.mkdir();
            }
            start = n + 1;
            n = name.indexOf(46, start);
        }
        return new File(outdir, String.valueOf(name.substring(start)).concat(String.valueOf(extension)));
    }
}

