/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6;

import gjc.v6.JavaCompiler;
import gjc.v6.Main;
import gjc.v6.Win32;
import gjc.v6.code.ClassReader;
import gjc.v6.code.ClassWriter;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.jp.JPSymtab;
import gjc.v6.jp.RemoteNames;
import gjc.v6.jp.SourceGenerator;
import gjc.v6.jp.Tools;
import gjc.v6.jp.TransportableGenerator;
import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;
import gjc.v6.util.Log;
import gjc.v6.util.Name;
import java.io.File;
import java.io.FileWriter;

public class RetroTransport
extends Main {
    public static boolean mainCompile(String[] args) throws Exception {
        Main.SRC_EXTENSION = "";
        if (args.length == 0) {
            Main.help();
        } else {
            JPSymtab syms;
            List<String> filenames = Main.processArgs(Win32.expand(args));
            Log log = new Log(Main.options.get("-prompt") != null, Main.options.get("-nowarn") == null);
            JavaCompiler compiler = null;
            RemoteNames rnames = null;
            try {
                ClassReader reader = new ClassReader(Main.options);
                ClassWriter writer = new ClassWriter(Main.options);
                rnames = new RemoteNames(Main.options);
                syms = new JPSymtab(reader, writer, rnames);
                compiler = JavaCompiler.make(Main.options, log, syms);
            }
            catch (Symbol.CompletionFailure ex) {
                log.error(0, ex.getMessage());
                return false;
            }
            Tools tools = new Tools(Main.options, syms, compiler.make, rnames);
            TransportableGenerator trans = new TransportableGenerator(tools);
            if (filenames != null) {
                File base = compiler.syms.writer.outDir;
                if (base != null && !base.isDirectory()) {
                    log.error(0, String.valueOf("base directory does not exist: ").concat(String.valueOf(base)));
                    return false;
                }
                ListBuffer trees = new ListBuffer();
                List<String> l = filenames;
                while (l.nonEmpty()) {
                    Type.ClassType clazz = (Type.ClassType)compiler.syms.reader.loadClass((Name)Name.fromString((String)((String)l.head))).type;
                    Symbol.ClassSymbol csym = (Symbol.ClassSymbol)clazz.tsym;
                    if (!tools.isInterface(csym)) {
                        File path;
                        SourceGenerator code = new SourceGenerator();
                        trans.generate(code, csym);
                        String flatname = csym.flatName().toString();
                        int lastDotIdx = flatname.lastIndexOf(46);
                        String className = flatname.substring(lastDotIdx + 1);
                        String packageName = lastDotIdx >= 0 ? flatname.substring(0, lastDotIdx) : "";
                        String pathName = packageName.replace('.', File.separatorChar);
                        File file = path = base != null ? new File(base, pathName) : new File(".");
                        if (path.exists()) {
                            if (!path.isDirectory()) {
                                log.error(0, String.valueOf("package exists but is no directory: ").concat(String.valueOf(path)));
                                return false;
                            }
                        } else {
                            path.mkdirs();
                        }
                        FileWriter out = new FileWriter(new File(path, String.valueOf(className).concat(String.valueOf(".h"))));
                        out.write(code.toString());
                        out.close();
                    }
                    l = l.tail;
                }
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        if (!RetroTransport.mainCompile(args)) {
            System.exit(1);
        }
    }
}

