/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6;

import gjc.v6.JavaCompiler;
import gjc.v6.Retro;
import gjc.v6.Win32;
import gjc.v6.code.Scope;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.comp.Items;
import gjc.v6.tree.Tree;
import gjc.v6.util.Hashtable;
import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    static String[][] possibleOptions = new String[][]{{"-classpath", "pathname", "use given classpath"}, {"-bootclasspath", "pathname", "use given bootclasspath"}, {"-d", "filename", "redirect classfile output"}, {"-experimental", "", "enable experimental features"}, {"-g", "", "include debug information"}, {"-1.1", "", "accept only standard Java 1.1 input"}, {"-moreinfo", "", "print extended information for type variables"}, {"-nowarn", "", "suppress warning messages"}, {"-printtree", "", "print abstract syntax tree for internal debugging"}, {"-printsearch", "", "print information where classfiles are searched"}, {"-prompt", "", "stop after each error"}, {"-retrofit", "pathname", "retrofit existing classfiles with generic types"}, {"-s", "", "emit java sources instead of classfiles"}, {"-scramble", "", "scramble private identifiers in bytecode"}, {"-scrambleall", "", "scramble package visible identifiers in bytecode"}, {"-switchcheck", "", "warn about fall-through in switches"}, {"-unchecked", "", "suppress \"unchecked\" warnings"}, {"-verbose", "", "print detailed log"}, {"-version", "", "version information"}, {"-genjpsource", "pathname", "emit JP transformed code as source"}, {"-local", "", "neither remote nor replicated object transformation"}, {"-skelonly", "", "generate only skeletons"}, {"-stubdebug", "", "generate stubs and skeletons with debug code"}, {"-bootstrap", "", "bootstrap mode for JP environment classes"}};
    protected static String SRC_EXTENSION = ".java";
    public static Hashtable<String, String> options;

    static void help() {
        System.err.println(String.valueOf(String.valueOf("Usage: gjc [ possibleOptions ] file").concat(String.valueOf(SRC_EXTENSION))).concat(String.valueOf(" ... ")));
        System.err.println("where possibleOptions include:");
        for (int i = 0; i < possibleOptions.length; ++i) {
            String s = String.valueOf(String.valueOf(String.valueOf("  ").concat(String.valueOf(possibleOptions[i][0]))).concat(String.valueOf(" "))).concat(String.valueOf(possibleOptions[i][1]));
            System.err.print(s);
            for (int j = s.length(); j < 28; ++j) {
                System.err.print(" ");
            }
            System.err.println(possibleOptions[i][2]);
        }
        System.err.println();
    }

    static void error(String arg) {
        System.err.println(String.valueOf("gjc: ").concat(String.valueOf(arg)));
        Main.help();
    }

    public static List<String> processArgs(List<String> args) {
        options = Hashtable.make();
        ListBuffer<String> filenames = new ListBuffer<String>();
        List<String> l = args;
        while (l.nonEmpty()) {
            String arg = (String)l.head;
            l = l.tail;
            if (arg.startsWith("-")) {
                int j;
                for (j = 0; j < possibleOptions.length && !possibleOptions[j][0].equals(arg); ++j) {
                }
                if (j == possibleOptions.length) {
                    Main.error(String.valueOf("invalid flag: ").concat(String.valueOf(arg)));
                    return null;
                }
                String operand = possibleOptions[j][1];
                if (operand.length() != 0) {
                    if (l.isEmpty()) {
                        Main.error(String.valueOf(arg).concat(String.valueOf(" requires argument")));
                        return null;
                    }
                    operand = (String)l.head;
                    l = l.tail;
                }
                if (arg.equals("-moreinfo")) {
                    Type.moreInfo = true;
                    continue;
                }
                options.put(arg, operand);
                continue;
            }
            if (arg.endsWith(SRC_EXTENSION)) {
                filenames.append(arg);
                continue;
            }
            Main.error(String.valueOf("invalid argument: ").concat(String.valueOf(arg)));
            return null;
        }
        return filenames.toList();
    }

    public static boolean mainCompile(String[] args) throws Exception {
        if (args.length == 0) {
            Main.help();
        } else {
            List<String> filenames = Main.processArgs(Win32.expand(args));
            if (options.get("-version") != null) {
                System.err.println(String.valueOf("GJC ").concat(String.valueOf(JavaCompiler.version())));
                System.err.println("Copyright (c) 1997,98 Martin Odersky.");
                System.err.println("Copyright (c) 1998-2006 The JavaParty Team.");
            }
            JavaCompiler comp = JavaCompiler.make(options);
            if (filenames != null && comp != null) {
                List<Symbol.ClassSymbol> cs = comp.compile(filenames);
                if (options.get("-retrofit") != null) {
                    while (cs.nonEmpty()) {
                        Retro retro = new Retro(comp, options);
                        retro.fitClass((Symbol.ClassSymbol)cs.head);
                        cs = cs.tail;
                    }
                }
                System.err.flush();
                if (comp.log.nerrors == 0) {
                    return true;
                }
            }
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        boolean success = Main.mainCompile(args);
        if (!success) {
            System.exit(-1);
        }
    }

    protected static void printStats() {
        System.out.println(String.valueOf(Tree.count).concat(String.valueOf(" trees")));
        System.out.println(String.valueOf(Symbol.count).concat(String.valueOf(" symbols")));
        System.out.println(String.valueOf(Type.count).concat(String.valueOf(" types")));
        System.out.println(String.valueOf(Scope.count).concat(String.valueOf(" scopes")));
        System.out.println(String.valueOf(Scope.Entry.count).concat(String.valueOf(" scope entries")));
        System.out.println(String.valueOf(Items.count).concat(String.valueOf(" items")));
    }
}

