/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6;

import gjc.v6.JavaCompiler;
import gjc.v6.Main;
import gjc.v6.Win32;
import gjc.v6.code.ClassReader;
import gjc.v6.code.ClassWriter;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.jp.ConfigurationException;
import gjc.v6.jp.JPSymtab;
import gjc.v6.jp.KaRMIcGenerator;
import gjc.v6.jp.RemoteNames;
import gjc.v6.jp.SourceGenerator;
import gjc.v6.jp.Tools;
import gjc.v6.tree.Tree;
import gjc.v6.util.Hashtable;
import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;
import gjc.v6.util.Log;
import gjc.v6.util.Name;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KaRMIc
extends Main {
    public static Properties getProperties() {
        Properties props = new Properties();
        try {
            Class<?> probe = Class.forName("uka.karmi.Probe");
            InputStream stream = probe.getResourceAsStream("/uka/karmi/system.properties");
            props.load(stream);
        }
        catch (Exception ex) {
            throw new ConfigurationException(String.valueOf(String.valueOf("Can not load KaRMI system properties 'system.properties' (").concat(String.valueOf(ex))).concat(String.valueOf("). Make sure that karmi.jar is in your CLASSPATH.")));
        }
        return props;
    }

    private static void getImplicitOptions(Properties props) {
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = props.getProperty(name);
            Main.options.put(name, value);
        }
    }

    public static List<String> processArgs(List<String> args) {
        List<String> filenames = Main.processArgs(args);
        return filenames;
    }

    private static void adjustClasspath(Hashtable<String, String> _options, ClassReader reader) {
        String classPath;
        String destPath = _options.get("-d");
        if (destPath == null) {
            destPath = ".";
            _options.put("-d", destPath);
        }
        classPath = (classPath = reader.classPath) == null ? destPath : String.valueOf(String.valueOf(destPath).concat(String.valueOf(":"))).concat(String.valueOf(classPath));
        reader.classPath = classPath;
    }

    public static boolean mainCompile(String[] args) throws Exception {
        Main.SRC_EXTENSION = "";
        if (args.length == 0) {
            Main.help();
            return false;
        }
        List<String> filenames = KaRMIc.processArgs(Win32.expand(args));
        KaRMIc.getImplicitOptions(KaRMIc.getProperties());
        Log log = new Log(Main.options.get("-prompt") != null, Main.options.get("-nowarn") == null);
        JavaCompiler compiler = null;
        RemoteNames rnames = null;
        JPSymtab syms = null;
        try {
            ClassReader reader = new ClassReader(Main.options);
            KaRMIc.adjustClasspath(Main.options, reader);
            ClassWriter writer = new ClassWriter(Main.options);
            rnames = new RemoteNames(Main.options);
            syms = new JPSymtab(reader, writer, rnames);
            compiler = JavaCompiler.make(Main.options, log, syms);
        }
        catch (Symbol.CompletionFailure ex) {
            log.error(0, ex.getMessage());
        }
        if (log.nerrors != 0) {
            return false;
        }
        Tools tools = new Tools(Main.options, syms, compiler.make, rnames);
        if (compiler.verbose) {
            rnames.printConfig(log);
        }
        if (filenames != null) {
            KaRMIcGenerator karmic = new KaRMIcGenerator(Main.options, tools, log);
            ListBuffer<Tree> trees = new ListBuffer<Tree>();
            List<String> l = filenames;
            while (l.nonEmpty()) {
                Type.ClassType clazz = (Type.ClassType)compiler.syms.reader.loadClass((Name)Name.fromString((String)((String)l.head))).type;
                if (tools.isAbstract(clazz.tsym) && !rnames.karmi_with_smartstubs) {
                    log.error(0, String.valueOf(clazz.tsym).concat(String.valueOf(" is abstract")));
                } else {
                    List<SourceGenerator> code = karmic.generate(clazz);
                    while (code.nonEmpty()) {
                        String filename = String.valueOf(((SourceGenerator)code.head).getName()).concat(String.valueOf(".java"));
                        FileWriter out = new FileWriter(new File(karmic.syms.writer.outDir, filename));
                        out.write(((SourceGenerator)code.head).toString());
                        out.close();
                        trees.append(compiler.parse(filename, ((SourceGenerator)code.head).getInputStream()));
                        code = code.tail;
                    }
                }
                l = l.tail;
            }
            if (log.nerrors != 0) {
                return false;
            }
            compiler.compile(trees);
            if (compiler.log.nerrors != 0) {
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        if (!KaRMIc.mainCompile(args)) {
            System.exit(1);
        }
    }
}

