/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6;

import gjc.v6.JavaCompiler;
import gjc.v6.KaRMIc;
import gjc.v6.code.ClassReader;
import gjc.v6.code.ClassWriter;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.comp.AttrContext;
import gjc.v6.comp.Enter;
import gjc.v6.comp.Env;
import gjc.v6.comp.Gen;
import gjc.v6.comp.Infer;
import gjc.v6.comp.Items;
import gjc.v6.comp.Resolve;
import gjc.v6.jp.Context;
import gjc.v6.jp.JPAttr;
import gjc.v6.jp.JPCheck;
import gjc.v6.jp.JPScanner;
import gjc.v6.jp.JPSymtab;
import gjc.v6.jp.RemoteClassBundle;
import gjc.v6.jp.RemoteNames;
import gjc.v6.jp.ReplicatedClassBundle;
import gjc.v6.jp.ReplicatedContext;
import gjc.v6.jp.ReplicatedNames;
import gjc.v6.jp.SourceGenerator;
import gjc.v6.jp.Tools;
import gjc.v6.jp.TransClean;
import gjc.v6.parser.Parser;
import gjc.v6.parser.Scanner;
import gjc.v6.tree.Pretty;
import gjc.v6.tree.Tree;
import gjc.v6.tree.TreeMaker;
import gjc.v6.util.Hashtable;
import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;
import gjc.v6.util.Log;
import gjc.v6.util.Name;
import gjc.v6.util.Names;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringBufferInputStream;
import java.util.Properties;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPCompiler
extends JavaCompiler {
    public boolean secondRun = false;
    final RemoteNames rnames;
    private Tools tools;
    private JavaCompiler jc;
    private Context context;
    private ReplicatedContext replicatedContext;
    private ListBuffer<Tree> trafoTrees;
    private static final String versionstring;
    private String sourceOutRootDir;
    protected boolean rep_signature = false;
    protected ListBuffer<Tree> treesForSecondRun = new ListBuffer();

    protected static String version() {
        return versionstring;
    }

    private static String adjustClasspath(Hashtable<String, String> options, String classPath) {
        String destPath = options.get("-d");
        if (destPath == null) {
            destPath = ".";
            options.put("-d", destPath);
        }
        classPath = classPath == null ? destPath : String.valueOf(String.valueOf(destPath).concat(String.valueOf(File.pathSeparator))).concat(String.valueOf(classPath));
        return classPath;
    }

    protected JPCompiler(Hashtable<String, String> options, Log log, JPSymtab syms, JPCheck chk, Infer infer, Resolve rs, TreeMaker make, Enter enter, JPAttr attr, Items items, Gen gen, RemoteNames rnames, Tools tools, Context context, ReplicatedContext replicatedContext, JavaCompiler javaCompiler) {
        super(options, log, syms, chk, infer, rs, make, enter, attr, items, gen);
        this.rnames = rnames;
        this.tools = tools;
        this.context = context;
        this.replicatedContext = replicatedContext;
        this.jc = javaCompiler;
        this.sourceOutRootDir = options.get("-genjpsource");
        if (this.sourceOutRootDir != null && !new File(this.sourceOutRootDir).isDirectory()) {
            log.fatal(0, "jp source generation directory does not exist");
        }
    }

    public static JPCompiler make(Hashtable<String, String> options) {
        Log log = new Log(options.get("-prompt") != null, options.get("-nowarn") == null);
        ClassReader reader = new ClassReader(options);
        reader.classPath = JPCompiler.adjustClasspath(options, reader.classPath);
        reader.mode_include_classes = ClassReader.MODE_LOAD_SIG_FILE;
        ClassWriter writer = new ClassWriter(options);
        RemoteNames rnames = new RemoteNames(options);
        ReplicatedNames replicatedNames = new ReplicatedNames(options);
        JPSymtab syms = new JPSymtab(reader, writer, rnames);
        TreeMaker make = new TreeMaker();
        Tools tools = new Tools(options, syms, make, rnames, replicatedNames);
        Context context = new Context(options, log, tools);
        ReplicatedContext replicatedContext = new ReplicatedContext(options, log, tools);
        JPCheck chk = new JPCheck(log, syms, options, tools);
        Infer infer = new Infer(log, syms, chk);
        Resolve rs = new Resolve(log, syms, chk, infer);
        Enter enter = new Enter(log, syms, rs, chk, make);
        JPAttr attr = new JPAttr(options, log, syms, rs, chk, infer, make, tools);
        Items items = new Items();
        Gen gen = new Gen(log, syms, chk, rs, make, items, options);
        return new JPCompiler(options, log, syms, chk, infer, rs, make, enter, attr, items, gen, rnames, tools, context, replicatedContext, null);
    }

    public static JavaCompiler makeJavac(Hashtable<String, String> options, Log log) {
        ClassReader reader = new ClassReader(options);
        reader.classPath = JPCompiler.adjustClasspath(options, reader.classPath);
        ClassWriter writer = new ClassWriter(options);
        RemoteNames rnames = new RemoteNames(options);
        JPSymtab syms = new JPSymtab(reader, writer, rnames);
        return JavaCompiler.make(options, log, syms);
    }

    @Override
    protected void genCode(Env<AttrContext> env, Tree.ClassDef classDef) throws IOException {
        this.gen.genClass(env, classDef);
        if (this.rep_signature) {
            this.writeClass(classDef.sym, ".rep_signature");
            this.rep_signature = false;
        } else {
            this.writeClass(classDef.sym, ".signature");
        }
    }

    private String getSourceFileName(String sourceDir, Name clazzName) {
        String string = String.valueOf(String.valueOf(File.separator).concat(String.valueOf(clazzName))).concat(String.valueOf(".java"));
        if (sourceDir != null) {
            string = String.valueOf(sourceDir).concat(String.valueOf(string));
        }
        return string;
    }

    @Override
    protected Scanner createScanner(InputStream in, Log _log) {
        JPScanner jPScanner = new JPScanner(in, _log, this.context.f, this.rnames);
        jPScanner.nextToken();
        return jPScanner;
    }

    private void parseRemoteClassSource(String sourceDir, Name clazzName, SourceGenerator src) {
        String fileName = this.getSourceFileName(sourceDir, clazzName);
        if (sourceDir != null) {
            try {
                File file = new File(fileName);
                if (file.exists()) {
                    this.log.warning(0, String.valueOf("skip source generation, file exists: ").concat(String.valueOf(fileName)));
                } else {
                    FileWriter out = new FileWriter(file);
                    out.write(src.toString());
                    out.close();
                }
            }
            catch (IOException iOException) {
                this.log.warning(0, String.valueOf("can not generate source to: ").concat(String.valueOf(fileName)));
            }
        }
        this.trafoTrees.append(this.parse(fileName, src.getInputStream()));
    }

    private void parseReplicatedClassSource(String sourceDir, Name[] clazzNames, SourceGenerator[] srcs) {
        String fileName0 = this.getSourceFileName(sourceDir, clazzNames[0]);
        String string = this.getSourceFileName(sourceDir, clazzNames[1]);
        this.treesForSecondRun.append(this.parse(fileName0, srcs[0].getInputStream()));
        this.treesForSecondRun.append(this.parse(string, srcs[1].getInputStream()));
    }

    private String createSourceDir(Symbol clazz) {
        Symbol pkg = clazz.owner;
        String string = this.sourceOutRootDir;
        if (string != null) {
            if (pkg != Symbol.emptyPackage) {
                string = String.valueOf(String.valueOf(string).concat(String.valueOf(File.separator))).concat(String.valueOf(pkg.fullName().toString().replace('.', File.separatorChar)));
            }
            new File(string).mkdirs();
        }
        return string;
    }

    private void parseReplicatedClassBundle(Env<AttrContext> env, ReplicatedClassBundle bundle) {
        Symbol.ClassSymbol clazz = env.enclClass.sym;
        Name clazzName = JPCompiler.flatLocalName(clazz);
        String sourceDir = this.createSourceDir(clazz);
        Name[] clazzNames = new Name[]{clazzName, clazzName.append(this.rnames.classImplSuffix)};
        SourceGenerator[] sourceGeneratorArray = new SourceGenerator[]{bundle.replicatedClass, bundle.classImpl};
        this.parseReplicatedClassSource(sourceDir, clazzNames, sourceGeneratorArray);
    }

    private void parseRemoteClassBundle(Env<AttrContext> env, RemoteClassBundle bundle) {
        Symbol.ClassSymbol clazz = env.enclClass.sym;
        Name clazzName = JPCompiler.flatLocalName(clazz);
        String string = this.createSourceDir(clazz);
        this.parseRemoteClassSource(string, clazzName, bundle.handle);
        this.parseRemoteClassSource(string, clazzName.append(this.rnames.instanceIntfSuffix), bundle.instanceIntf);
        this.parseRemoteClassSource(string, clazzName.append(this.rnames.instanceImplSuffix), bundle.instanceImpl);
        this.parseRemoteClassSource(string, clazzName.append(this.rnames.classIntfSuffix), bundle.classIntf);
        this.parseRemoteClassSource(string, clazzName.append(this.rnames.classImplSuffix), bundle.classImpl);
        if (bundle.instanceStub != null) {
            this.parseRemoteClassSource(string, clazzName.append(this.rnames.instanceImplSuffix).append(Name.fromString("_KStub")), bundle.instanceStub);
        }
    }

    private void genLocalClassSource(Env<AttrContext> env, Tree.TopLevel top, Name flatLocalName) throws IOException {
        Symbol.ClassSymbol clazz = env.enclClass.sym;
        String sourceDir = this.createSourceDir(clazz);
        String fileName = this.getSourceFileName(sourceDir, flatLocalName);
        File file = new File(fileName);
        if (file.exists()) {
            this.log.warning(0, String.valueOf("skip source generation, file exists: ").concat(String.valueOf(fileName)));
        } else {
            PrintStream print = new PrintStream(new FileOutputStream(file));
            Pretty pretty = new Pretty(print);
            pretty.printStat(top);
            print.close();
        }
    }

    private static Name flatLocalName(Symbol sym) {
        Name name = sym.name;
        while (sym.owner != null && sym.owner.kind == 2) {
            name = JPCompiler.flatLocalName(sym.owner).append(Names.dollar).append(name);
        }
        return name;
    }

    private boolean applyJPReplicatedTrafo(Env<AttrContext> env, Tree.ClassDef cdef, boolean needsInnerClassesPatch) throws IOException {
        this.replicatedContext.setTopLevel(env.toplevel);
        Name flatLocalName = JPCompiler.flatLocalName(cdef.sym);
        Tree copy = cdef.visit(this.replicatedContext.transCopy, this.replicatedContext.f);
        this.replicatedContext.transReplicated.setContext(this.context);
        ReplicatedClassBundle replicatedClassBundle = copy.visit(this.replicatedContext.transReplicated, this.replicatedContext);
        this.parseReplicatedClassBundle(env, replicatedClassBundle);
        return false;
    }

    private boolean applyJPTrafo(Env<AttrContext> env, Tree.ClassDef cdef, boolean needsInnerClassesPatch) throws IOException {
        if (this.log.nerrors == 0) {
            this.context.setTopLevel(env.toplevel);
            Name flatLocalName = JPCompiler.flatLocalName(cdef.sym);
            if (this.rnames.local_only || !this.tools.implementsOrExtendsRemote(cdef.sym)) {
                Tree.ClassDef localClass = cdef;
                if (!this.rnames.local_only) {
                    localClass = (Tree.ClassDef)cdef.visit(this.context.transBody, this.context);
                }
                Symbol.TypeSymbol serializableRoot = cdef.sym;
                while (serializableRoot.type.supertype() != null && this.tools.isSerializable(serializableRoot.type.supertype().tsym)) {
                    serializableRoot = serializableRoot.type.supertype().tsym;
                }
                Symbol.TypeSymbol externalRoot = cdef.sym;
                while (externalRoot.type.supertype() != null && !externalRoot.type.supertype().tsym.isExternal) {
                    externalRoot = externalRoot.type.supertype().tsym;
                }
                externalRoot = externalRoot.type.supertype().tsym;
                if (!(this.tools.transportableGenerator == null || this.tools.isInterface(cdef.sym) || this.tools.isTransportable(cdef.sym) || this.rnames.local_only && !this.tools.isSerializable(cdef.sym) || externalRoot != null && this.tools.isSerializable(externalRoot) && !this.tools.isTransportable(externalRoot) || this.tools.hasWriteObjectMethod(cdef.sym))) {
                    boolean isTransportableRoot = externalRoot == null || !this.rnames.local_only && cdef.sym.type.supertype().tsym == externalRoot && !this.tools.isTransportable(externalRoot) || this.rnames.local_only && !this.tools.isSerializable(cdef.sym.type.supertype().tsym);
                    SourceGenerator transportCode = new SourceGenerator();
                    this.tools.transportableGenerator.generate(transportCode, cdef.sym, isTransportableRoot);
                    Scanner scanner = this.createScanner(new StringBufferInputStream(String.valueOf(String.valueOf("{").concat(String.valueOf(transportCode.toString()))).concat(String.valueOf("}"))), this.log);
                    Parser parser = new Parser(scanner, this.make, this.log);
                    List<Tree> transportTrees = parser.classOrInterfaceBody(cdef.sym.name, false);
                    localClass.defs = localClass.defs.prepend(transportTrees);
                    localClass.flags = localClass.flags & 0xFFFFFFF8 | 1;
                    if (!this.tools.isExternalizable(cdef.sym)) {
                        localClass.implementing = localClass.implementing.prepend(this.tools.getRef(this.tools.getTransportableType().tsym.fullName().toList()));
                    }
                    if (this.tools.requiresPatchableInjection(localClass.sym)) {
                        localClass.implementing = localClass.implementing.prepend(this.tools.getRef(this.tools.getPatchableType().tsym.fullName().toList()));
                    }
                }
                Tree.TopLevel topLevel = this.tools.makeTopLevel(localClass, env.toplevel);
                if (needsInnerClassesPatch) {
                    topLevel.sourcefile = flatLocalName.append(Names.period).append(Name.fromString("java"));
                }
                this.trafoTrees.append(topLevel);
                if (this.sourceOutRootDir != null) {
                    this.genLocalClassSource(env, topLevel, flatLocalName);
                }
                topLevel.sourcefile = Name.fromString(this.getSourceFileName(this.createSourceDir(env.enclClass.sym), flatLocalName));
                topLevel.visit(new TransClean(), new Integer(42));
                return true;
            }
            Tree copy = cdef.visit(this.context.transCopy, this.context.f);
            this.context.transRemote.setReplicatedContext(this.replicatedContext);
            RemoteClassBundle bundle = copy.visit(this.context.transRemote, this.context);
            this.parseRemoteClassBundle(env, bundle);
            if (this.log.nerrors > 0) {
                throw new InternalError("remote transformation failed");
            }
        }
        return false;
    }

    @Override
    protected boolean postFlowCheckWork(Env<AttrContext> env) throws IOException {
        if (this.rnames.karmi_with_transport) {
            if (this.tools.implementsOrExtendsReplicated(env.enclClass) && !this.secondRun && !this.tools.isJPReplicatedObject(env.enclClass)) {
                this.rep_signature = true;
                return this.applyJPReplicatedTrafo(env, env.enclClass, false);
            }
            if (!this.secondRun) {
                env.enclClass = (Tree.ClassDef)((Tree)env.enclClass).visit(this.replicatedContext.transReplicatedBody, this.replicatedContext);
                SourceGenerator sg = new SourceGenerator();
                SourceGenerator.Scope s = new SourceGenerator.Scope();
                s.set("output", this.tools.makeTopLevel(env.enclClass, env.toplevel, JPCompiler.flatLocalName(env.enclClass.sym).append(Name.fromString(".java"))));
                sg.append(s, "@output@");
                String sourceDir = this.sourceOutRootDir;
                String string = this.getSourceFileName(sourceDir, JPCompiler.flatLocalName(env.enclClass.sym));
                this.treesForSecondRun.append(this.parse(string, sg.getInputStream()));
                return true;
            }
        }
        return this.applyJPTrafo(env, env.enclClass, false);
    }

    private void rmic(ListBuffer<Name> rmiServers) throws Exception {
        if (rmiServers.length() > 0) {
            String classPath;
            String destPath;
            List<Name> servers = rmiServers.toList();
            ListBuffer<String> cmd = new ListBuffer<String>();
            ListBuffer cmdImpls = new ListBuffer();
            if (this.options.get("-g") != null) {
                cmd.append("-g");
            }
            if ((destPath = this.options.get("-d")) != null) {
                cmd.append("-d").append(destPath);
            }
            if ((classPath = this.syms.reader.classPath) != null) {
                cmd.append("-classpath").append(classPath);
            }
            cmdImpls.append(cmd.toList()).append("-skelonly");
            System.err.println("Generating stubs & skeletons for");
            List<Name> name = servers;
            while (name.nonEmpty()) {
                String serverName = ((Name)name.head).toString();
                if (this.rnames.jp_with_smarthandles && serverName.endsWith("_instance_impl")) {
                    System.err.println(String.valueOf(String.valueOf(" ").concat(String.valueOf(serverName))).concat(String.valueOf(" (skeleton only)")));
                    cmdImpls.append(serverName);
                } else {
                    System.err.println(String.valueOf(" ").concat(String.valueOf(serverName)));
                    cmd.append(serverName);
                }
                name = name.tail;
            }
            if (this.rnames.with_karmi) {
                boolean ok = true;
                boolean bl = ok = ok && KaRMIc.mainCompile(cmd.toList().copy(new String[cmd.length()]));
                if (this.rnames.jp_with_smarthandles) {
                    boolean bl2 = ok = ok && KaRMIc.mainCompile(cmdImpls.toList().copy(new String[cmdImpls.length()]));
                }
                if (!ok) {
                    this.log.error(0, "Stubs & skeletons generation failed");
                }
            } else {
                String[] rmic = cmd.prepend("rmic").toList().copy((String[])new String[cmd.length()]);
                Process p = Runtime.getRuntime().exec(rmic);
                if (p.waitFor() != 0) {
                    int cnt;
                    this.log.error(0, "Stubs & skeletons generation failed");
                    byte[] buffer = new byte[1024];
                    InputStream inputStream = p.getInputStream();
                    while ((cnt = inputStream.read(buffer)) >= 0) {
                        System.out.write(buffer, 0, cnt);
                    }
                    inputStream = p.getErrorStream();
                    while ((cnt = inputStream.read(buffer)) >= 0) {
                        System.err.write(buffer, 0, cnt);
                    }
                }
            }
        }
    }

    private List<Symbol.ClassSymbol> compileTransformed(ListBuffer<Tree> trees) throws Exception {
        if (this.log.nerrors == 0) {
            this.jc = JPCompiler.makeJavac(this.options, this.log);
            List<Symbol.ClassSymbol> list = this.jc.compile(trees);
            if (this.log.nerrors > 0) {
                throw new InternalError("errors in generated code");
            }
            return list;
        }
        return new List<Symbol.ClassSymbol>();
    }

    @Override
    public List<Symbol.ClassSymbol> compile(ListBuffer<Tree> trees) throws Exception {
        this.trafoTrees = new ListBuffer();
        ListBuffer<Symbol.ClassSymbol> classes = new ListBuffer<Symbol.ClassSymbol>();
        super.compile(trees);
        if (this.log.nerrors > 0) {
            System.err.println(String.valueOf(this.log.nerrors).concat(String.valueOf(" errors")));
            System.err.flush();
            System.exit(-1);
        }
        if (!this.secondRun) {
            JPCompiler c = JPCompiler.make(this.options);
            c.secondRun = true;
            ClassReader.secondRun = true;
            ((JPAttr)c.attr).secondRun = true;
            try {
                c.compile(this.treesForSecondRun);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.error(0, String.valueOf("An exception occured in compile(ListBuffer<Tree>): ").concat(String.valueOf(e)));
            }
        }
        classes.append(this.compileTransformed(this.trafoTrees));
        ListBuffer<Name> rmiServers = new ListBuffer<Name>();
        List list = classes.toList();
        while (this.log.nerrors == 0 && list.nonEmpty()) {
            if (!this.rnames.local_only && this.isRMIServer(((Symbol.ClassSymbol)list.head).type)) {
                rmiServers.append(((Symbol.ClassSymbol)list.head).flatName());
            }
            list = list.tail;
        }
        this.rmic(rmiServers);
        return classes.toList();
    }

    public final boolean isRMIServer(Type type) {
        JPSymtab jPSymtab = (JPSymtab)this.jc.syms;
        return type.subType(jPSymtab.remoteIntf) && !this.tools.isInterface(type.tsym) && !type.subType(jPSymtab.remoteStubType) && (this.rnames.jp_with_smarthandles || !this.tools.isAbstract(type.tsym)) && type != Type.allType;
    }

    static {
        Properties props = new Properties();
        try {
            props.load(Class.forName("gjc.v6.JavaCompiler").getResourceAsStream("/gjc/v6/version.properties"));
        }
        catch (Exception ex) {
            System.err.println("Couldn't get version.");
        }
        versionstring = String.valueOf("jpc/").concat(String.valueOf(props.getProperty("version")));
    }
}

