/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6;

import gjc.v6.JPCompiler;
import gjc.v6.KaRMIc;
import gjc.v6.Main;
import gjc.v6.Win32;
import gjc.v6.jp.ConfigurationException;
import gjc.v6.util.List;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPC
extends Main {
    public static Properties getProperties() {
        Properties props = new Properties();
        try {
            Class<?> resident = Class.forName("jp.lang.Resident");
            InputStream stream = resident.getResourceAsStream("/jp/system.properties");
            props.load(stream);
        }
        catch (Exception ex) {
            throw new ConfigurationException(String.valueOf(String.valueOf("Can not load properties 'jp/system.properties' (").concat(String.valueOf(ex))).concat(String.valueOf("). Make sure that jp.jar is in your CLASSPATH.")));
        }
        return props;
    }

    private static void getImplicitOptions(Properties props) {
        if (props != null) {
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String name = null;
                try {
                    name = (String)names.nextElement();
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
                String value = props.getProperty(name);
                Main.options.put(name, value);
            }
        }
    }

    public static List<String> processArgs(List<String> args) {
        List<String> filenames = Main.processArgs(args);
        return filenames;
    }

    public static boolean mainCompile(String[] args) throws Exception {
        try {
            if (args.length == 0) {
                Main.help();
            } else {
                List<String> filenames = JPC.processArgs(Win32.expand(args));
                if (Main.options.get("-version") != null) {
                    System.err.println(String.valueOf("JPC ").concat(String.valueOf(JPCompiler.version())));
                    System.err.println("Copyright (c) 1998-2006 The JavaParty Team.");
                }
                if (Main.options.get("-local") == null) {
                    JPC.getImplicitOptions(JPC.getProperties());
                    if (Boolean.valueOf(Main.options.get("jp.with_karmi")).booleanValue()) {
                        JPC.getImplicitOptions(KaRMIc.getProperties());
                    }
                }
                JPCompiler comp = JPCompiler.make(Main.options);
                if (comp.verbose) {
                    comp.rnames.printConfig(comp.log);
                }
                comp.rnames.checkJPConfig();
                if (filenames != null) {
                    comp.compile(filenames);
                    System.err.flush();
                    if (comp.log.nerrors == 0) {
                        return true;
                    }
                }
            }
        }
        catch (ConfigurationException ex) {
            System.err.println(String.valueOf("Configuration problem: ").concat(String.valueOf(ex.getMessage())));
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        if (!JPC.mainCompile(args)) {
            System.exit(-1);
        }
    }
}

