/********************************************************************

   Module Name:     RowsetAccessHelper.java
   Creation Date:   8/28/97
   Description:     Utility methods to help create/manage RowsetAccess DataItems

*********************************************************************/

/*
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */




import java.sql.Types;

class RowsetAccessHelper
{

    /**
     * Given column datatype number, return datatype name.
     * @param int typenum the column datatype number (see java.sql.Types)
     */
    public final static String getDatatypeName(int typenum)
    {
        switch(typenum)
        {
			case java.sql.Types.BIGINT:	         return "BIGINT";
			case java.sql.Types.BINARY:	         return "BINARY";
			case java.sql.Types.BIT:	         return "BIT";
			case java.sql.Types.CHAR:	         return "CHAR";
			case java.sql.Types.DATE:	         return "DATE";
			case java.sql.Types.DECIMAL:	     return "DECIMAL";
			case java.sql.Types.DOUBLE:	         return "DOUBLE";
			case java.sql.Types.FLOAT :	         return "FLOAT";
			case java.sql.Types.INTEGER :	     return "INTEGER";
			case java.sql.Types.LONGVARBINARY :	 return "LONGVARBINARY";
			case java.sql.Types.LONGVARCHAR :	 return "LONGVARCHAR";
			case java.sql.Types.NULL :	         return "NULL";
			case java.sql.Types.NUMERIC :	     return "NUMERIC";
			case java.sql.Types.OTHER :	         return "OTHER";
			case java.sql.Types.REAL :	         return "REAL";
			case java.sql.Types.SMALLINT :	     return "SMALLINT";
			case java.sql.Types.TIME :	         return "TIME";
			case java.sql.Types.TIMESTAMP :	     return "TIMESTAMP";
			case java.sql.Types.TINYINT :	     return "TINYINT";
			case java.sql.Types.VARBINARY :	     return "VARBINARY";
			case java.sql.Types.VARCHAR:	     return "VARCHAR";
			default:                             return "(unknown datatype number"+typenum+")";
        }
    } // getDatatypeName

    /**
     * Given column datatype name, return datatype number using java.sql.Types encoding.
     * @param String typename
     */
    public final static int getDatatypeNumber(String typename)
    {
        if (typename.equalsIgnoreCase("BIGINT"))
            return java.sql.Types.BIGINT;
        else if (typename.equalsIgnoreCase("BINARY"))
            return java.sql.Types.BINARY;
        else if (typename.equalsIgnoreCase("BIT"))
            return java.sql.Types.BIT;
        else if (typename.equalsIgnoreCase("CHAR"))
            return java.sql.Types.CHAR;
        else if (typename.equalsIgnoreCase("DATE"))
            return java.sql.Types.DATE;
        else if (typename.equalsIgnoreCase("DECIMAL"))
            return java.sql.Types.DECIMAL;
        else if (typename.equalsIgnoreCase("DOUBLE"))
            return java.sql.Types.DOUBLE;
        else if (typename.equalsIgnoreCase("FLOAT"))
            return java.sql.Types.FLOAT;
        else if (typename.equalsIgnoreCase("INTEGER"))
            return java.sql.Types.INTEGER;
        else if (typename.equalsIgnoreCase("LONGVARBINARY"))
            return java.sql.Types.LONGVARBINARY;
        else if (typename.equalsIgnoreCase("LONGVARCHAR"))
            return java.sql.Types.LONGVARCHAR;
        else if (typename.equalsIgnoreCase("NULL"))
            return java.sql.Types.NULL;
        else if (typename.equalsIgnoreCase("NUMERIC"))
            return java.sql.Types.NUMERIC;
        else if (typename.equalsIgnoreCase("OTHER"))
            return java.sql.Types.OTHER;
        else if (typename.equalsIgnoreCase("REAL"))
            return java.sql.Types.REAL;
        else if (typename.equalsIgnoreCase("SMALLINT"))
            return java.sql.Types.SMALLINT;
        else if (typename.equalsIgnoreCase("TIME"))
            return java.sql.Types.TIME;
        else if (typename.equalsIgnoreCase("TIMESTAMP"))
            return java.sql.Types.TIMESTAMP;
        else if (typename.equalsIgnoreCase("TINYINT"))
            return java.sql.Types.TINYINT;
        else if (typename.equalsIgnoreCase("VARBINARY"))
            return java.sql.Types.VARBINARY;
        else if (typename.equalsIgnoreCase("VARCHAR"))
            return java.sql.Types.VARCHAR;

        return -1;

    } // getDatatypeNumber

}