/*
 * Decompiled with CFR 0.152.
 */
package javax.infobus;

import java.util.Enumeration;
import java.util.Vector;
import javax.infobus.DataItemAddedEvent;
import javax.infobus.DataItemChangeListener;
import javax.infobus.DataItemDeletedEvent;
import javax.infobus.DataItemRevokedEvent;
import javax.infobus.DataItemShapeChangeListener;
import javax.infobus.DataItemShapeChangedEvent;
import javax.infobus.DataItemValueChangedEvent;
import javax.infobus.InfoBusPropertyMap;
import javax.infobus.RowsetCursorMovedEvent;

public class DataItemChangeManagerSupport {
    static final byte Copyright_1997_1998_Lotus_Development_Corporation_All_Rights_Reserved = 1;
    protected Object m_source;
    protected Vector m_changeListeners;

    public DataItemChangeManagerSupport(Object object) {
        this.m_source = object;
    }

    public synchronized void addDataItemChangeListener(DataItemChangeListener dataItemChangeListener) {
        if (this.m_changeListeners == null) {
            this.m_changeListeners = new Vector(5, 5);
        }
        this.m_changeListeners.addElement(dataItemChangeListener);
    }

    public synchronized void removeDataItemChangeListener(DataItemChangeListener dataItemChangeListener) {
        if (this.m_changeListeners != null) {
            this.m_changeListeners.removeElement(dataItemChangeListener);
            if (this.m_changeListeners.isEmpty()) {
                this.m_changeListeners = null;
            }
        }
    }

    public synchronized void removeAllListeners() {
        if (this.m_changeListeners != null) {
            this.m_changeListeners.removeAllElements();
            this.m_changeListeners = null;
        }
    }

    protected synchronized Enumeration enumerateListeners() {
        Enumeration enumeration = null;
        if (this.m_changeListeners != null) {
            enumeration = ((Vector)this.m_changeListeners.clone()).elements();
        }
        return enumeration;
    }

    public void fireItemValueChanged(Object object, InfoBusPropertyMap infoBusPropertyMap) {
        Enumeration enumeration = this.enumerateListeners();
        if (enumeration != null) {
            DataItemValueChangedEvent dataItemValueChangedEvent = new DataItemValueChangedEvent(this.m_source, object, infoBusPropertyMap);
            while (enumeration.hasMoreElements()) {
                DataItemChangeListener dataItemChangeListener = (DataItemChangeListener)enumeration.nextElement();
                dataItemChangeListener.dataItemValueChanged(dataItemValueChangedEvent);
            }
        }
    }

    public void fireItemAdded(Object object, Object object2, InfoBusPropertyMap infoBusPropertyMap) {
        Enumeration enumeration = this.enumerateListeners();
        if (enumeration != null) {
            DataItemAddedEvent dataItemAddedEvent = new DataItemAddedEvent(this.m_source, object, object2, infoBusPropertyMap);
            while (enumeration.hasMoreElements()) {
                DataItemChangeListener dataItemChangeListener = (DataItemChangeListener)enumeration.nextElement();
                dataItemChangeListener.dataItemAdded(dataItemAddedEvent);
            }
        }
    }

    public void fireItemDeleted(Object object, Object object2, InfoBusPropertyMap infoBusPropertyMap) {
        Enumeration enumeration = this.enumerateListeners();
        if (enumeration != null) {
            DataItemDeletedEvent dataItemDeletedEvent = new DataItemDeletedEvent(this.m_source, object, object2, infoBusPropertyMap);
            while (enumeration.hasMoreElements()) {
                DataItemChangeListener dataItemChangeListener = (DataItemChangeListener)enumeration.nextElement();
                dataItemChangeListener.dataItemDeleted(dataItemDeletedEvent);
            }
        }
    }

    public void fireItemRevoked(Object object, InfoBusPropertyMap infoBusPropertyMap) {
        Enumeration enumeration = this.enumerateListeners();
        if (enumeration != null) {
            DataItemRevokedEvent dataItemRevokedEvent = new DataItemRevokedEvent(this.m_source, object, infoBusPropertyMap);
            while (enumeration.hasMoreElements()) {
                DataItemChangeListener dataItemChangeListener = (DataItemChangeListener)enumeration.nextElement();
                dataItemChangeListener.dataItemRevoked(dataItemRevokedEvent);
            }
        }
    }

    public void fireRowsetCursorMoved(Object object, InfoBusPropertyMap infoBusPropertyMap) {
        Enumeration enumeration = this.enumerateListeners();
        if (enumeration != null) {
            RowsetCursorMovedEvent rowsetCursorMovedEvent = new RowsetCursorMovedEvent(this.m_source, object, infoBusPropertyMap);
            while (enumeration.hasMoreElements()) {
                DataItemChangeListener dataItemChangeListener = (DataItemChangeListener)enumeration.nextElement();
                dataItemChangeListener.rowsetCursorMoved(rowsetCursorMovedEvent);
            }
        }
    }

    public void fireItemShapeChanged(Object object, InfoBusPropertyMap infoBusPropertyMap) {
        Enumeration enumeration = this.enumerateListeners();
        if (enumeration != null) {
            DataItemShapeChangedEvent dataItemShapeChangedEvent = new DataItemShapeChangedEvent(this.m_source, object, infoBusPropertyMap);
            while (enumeration.hasMoreElements()) {
                DataItemChangeListener dataItemChangeListener = (DataItemChangeListener)enumeration.nextElement();
                if (!(dataItemChangeListener instanceof DataItemShapeChangeListener)) continue;
                ((DataItemShapeChangeListener)dataItemChangeListener).dataItemShapeChanged(dataItemShapeChangedEvent);
            }
        }
    }
}

