/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.TokenRuntimeException;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.Functions;

public abstract class RSAPkcsParameters
implements Parameters {
    protected Mechanism hashAlgorithm_;
    protected long maskGenerationFunction_;

    protected RSAPkcsParameters(Mechanism mechanism, long l) {
        if (mechanism == null) {
            throw new NullPointerException("Argument \"hashAlgorithm\" must not be null.");
        }
        if (l != 1L && l != 2L && l != 3L && l != 4L) {
            throw new IllegalArgumentException("Illegal value for argument\"maskGenerationFunction\": " + Functions.toHexString(l));
        }
        this.hashAlgorithm_ = mechanism;
        this.maskGenerationFunction_ = l;
    }

    public Object clone() {
        RSAPkcsParameters rSAPkcsParameters;
        try {
            rSAPkcsParameters = (RSAPkcsParameters)super.clone();
            rSAPkcsParameters.hashAlgorithm_ = (Mechanism)this.hashAlgorithm_.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", cloneNotSupportedException);
        }
        return rSAPkcsParameters;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof RSAPkcsParameters) {
            RSAPkcsParameters rSAPkcsParameters = (RSAPkcsParameters)object;
            bl = this == rSAPkcsParameters || this.hashAlgorithm_.equals(rSAPkcsParameters.hashAlgorithm_) && this.maskGenerationFunction_ == rSAPkcsParameters.maskGenerationFunction_;
        }
        return bl;
    }

    public Mechanism getHashAlgorithm() {
        return this.hashAlgorithm_;
    }

    public long getMaskGenerationFunction() {
        return this.maskGenerationFunction_;
    }

    public abstract Object getPKCS11ParamsObject();

    public int hashCode() {
        return this.hashAlgorithm_.hashCode() ^ (int)this.maskGenerationFunction_;
    }

    public void setHashAlgorithm(Mechanism mechanism) {
        if (mechanism == null) {
            throw new NullPointerException("Argument \"hashAlgorithm\" must not be null.");
        }
        this.hashAlgorithm_ = mechanism;
    }

    public void setMaskGenerationFunction(long l) {
        if (l != 1L && l != 2L && l != 3L && l != 4L) {
            throw new IllegalArgumentException("Illegal value for argument\"maskGenerationFunction\": " + Functions.toHexString(l));
        }
        this.maskGenerationFunction_ = l;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  ");
        stringBuffer.append("Hash Algorithm: ");
        stringBuffer.append(this.hashAlgorithm_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Mask Generation Function: ");
        if (this.maskGenerationFunction_ == 1L) {
            stringBuffer.append("SHA-1");
        } else if (this.maskGenerationFunction_ == 2L) {
            stringBuffer.append("SHA-256");
        } else if (this.maskGenerationFunction_ == 3L) {
            stringBuffer.append("SHA-384");
        } else if (this.maskGenerationFunction_ == 4L) {
            stringBuffer.append("SHA-512");
        } else {
            stringBuffer.append("<unknown>");
        }
        return stringBuffer.toString();
    }

    public static interface MessageGenerationFunctionType {
        public static final long SHA1 = 1L;
        public static final long SHA256 = 2L;
        public static final long SHA384 = 3L;
        public static final long SHA512 = 4L;
    }
}

