/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.TokenRuntimeException;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.wrapper.CK_PBE_PARAMS;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.Functions;

public class PBEParameters
implements Parameters {
    protected char[] initializationVector_;
    protected char[] password_;
    protected char[] salt_;
    protected long iterations_;

    public PBEParameters(char[] cArray, char[] cArray2, char[] cArray3, long l) {
        if (cArray != null && cArray.length != 8) {
            throw new IllegalArgumentException("Argument \"initializationVector\" must be null or must have length 8, if it is not null.");
        }
        if (cArray2 == null) {
            throw new NullPointerException("Argument \"password\" must not be null.");
        }
        if (cArray3 == null) {
            throw new NullPointerException("Argument \"salt\" must not be null.");
        }
        this.initializationVector_ = cArray;
        this.password_ = cArray2;
        this.salt_ = cArray3;
        this.iterations_ = l;
    }

    public Object clone() {
        PBEParameters pBEParameters;
        try {
            pBEParameters = (PBEParameters)super.clone();
            pBEParameters.initializationVector_ = (char[])this.initializationVector_.clone();
            pBEParameters.password_ = (char[])this.password_.clone();
            pBEParameters.salt_ = (char[])this.salt_.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", cloneNotSupportedException);
        }
        return pBEParameters;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof PBEParameters) {
            PBEParameters pBEParameters = (PBEParameters)object;
            bl = this == pBEParameters || Functions.equals(this.initializationVector_, pBEParameters.initializationVector_) && Functions.equals(this.password_, pBEParameters.password_) && Functions.equals(this.salt_, pBEParameters.salt_) && this.iterations_ == pBEParameters.iterations_;
        }
        return bl;
    }

    public char[] getInitializationVector() {
        return this.initializationVector_;
    }

    public long getIterations() {
        return this.iterations_;
    }

    public Object getPKCS11ParamsObject() {
        CK_PBE_PARAMS cK_PBE_PARAMS = new CK_PBE_PARAMS();
        cK_PBE_PARAMS.pInitVector = this.initializationVector_;
        cK_PBE_PARAMS.pPassword = this.password_;
        cK_PBE_PARAMS.pSalt = this.salt_;
        cK_PBE_PARAMS.ulIteration = this.iterations_;
        return cK_PBE_PARAMS;
    }

    public char[] getPassword() {
        return this.password_;
    }

    public char[] getSalt() {
        return this.salt_;
    }

    public int hashCode() {
        return Functions.hashCode(this.initializationVector_) ^ Functions.hashCode(this.password_) ^ Functions.hashCode(this.salt_) ^ (int)this.iterations_;
    }

    public void setInitializationVector(char[] cArray) {
        if (cArray != null && cArray.length != 8) {
            throw new IllegalArgumentException("Argument \"initializationVector\" must be null or must have length 8, if it is not null.");
        }
        this.initializationVector_ = cArray;
    }

    public void setIterations(long l) {
        this.iterations_ = l;
    }

    public void setPassword(char[] cArray) {
        if (cArray == null) {
            throw new NullPointerException("Argument \"password\" must not be null.");
        }
        this.password_ = cArray;
    }

    public void setSalt(char[] cArray) {
        if (cArray == null) {
            throw new NullPointerException("Argument \"salt\" must not be null.");
        }
        this.salt_ = cArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  ");
        stringBuffer.append("Initialization Vector: ");
        stringBuffer.append(this.initializationVector_ != null ? new String(this.initializationVector_) : null);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Password: ");
        stringBuffer.append(this.password_ != null ? new String(this.password_) : null);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Salt: ");
        stringBuffer.append(this.salt_ != null ? new String(this.salt_) : null);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Iterations (dec): ");
        stringBuffer.append(this.iterations_);
        return stringBuffer.toString();
    }
}

