/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.TokenRuntimeException;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.Functions;

public abstract class CbcEncryptDataParameters
implements Parameters {
    protected int blockSize_;
    protected byte[] iv_;
    protected byte[] data_;

    protected CbcEncryptDataParameters(int n, byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"iv\" must not be null.");
        }
        if (byArray.length != n) {
            throw new IllegalArgumentException("Argument \"iv\" must have length blockSize.");
        }
        if (byArray2 == null) {
            throw new NullPointerException("Argument \"data\" must not be null.");
        }
        if (byArray2.length % n != 0) {
            throw new IllegalArgumentException("Argument \"data\" must have a length that is a multiple of blockSize.");
        }
        this.blockSize_ = n;
        this.iv_ = byArray;
        this.data_ = byArray2;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", cloneNotSupportedException);
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof CbcEncryptDataParameters) {
            CbcEncryptDataParameters cbcEncryptDataParameters = (CbcEncryptDataParameters)object;
            bl = this == cbcEncryptDataParameters || this.blockSize_ == cbcEncryptDataParameters.blockSize_ && Functions.equals(this.iv_, cbcEncryptDataParameters.iv_) && Functions.equals(this.data_, cbcEncryptDataParameters.data_);
        }
        return bl;
    }

    public int getBlockSize() {
        return this.blockSize_;
    }

    public byte[] getData() {
        return this.data_;
    }

    public byte[] getInitializationVector() {
        return this.iv_;
    }

    public abstract Object getPKCS11ParamsObject();

    public int hashCode() {
        return Functions.hashCode(this.iv_) ^ Functions.hashCode(this.data_);
    }

    public void setData(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"data\" must not be null.");
        }
        if (byArray.length % this.blockSize_ != 0) {
            throw new IllegalArgumentException("Argument \"data\" must have a length that is a multiple of getBlockSize().");
        }
        this.data_ = byArray;
    }

    public void setInitializationVector(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"iv\" must not be null.");
        }
        if (byArray.length != this.blockSize_) {
            throw new IllegalArgumentException("Argument \"iv\" must have length getBlockSize().");
        }
        this.iv_ = byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  ");
        stringBuffer.append("Initialization Vector (hex): ");
        stringBuffer.append(Functions.toHexString(this.iv_));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Data (hex): ");
        stringBuffer.append(Functions.toHexString(this.data_));
        return stringBuffer.toString();
    }
}

