/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class KEAPublicKey
extends PublicKey {
    protected ByteArrayAttribute prime_;
    protected ByteArrayAttribute subprime_;
    protected ByteArrayAttribute base_;
    protected ByteArrayAttribute value_;

    public KEAPublicKey() {
        this.keyType_.setLongValue(Key.KeyType.KEA);
    }

    protected KEAPublicKey(Session session, long l) throws TokenException {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.KEA);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.prime_ = new ByteArrayAttribute(Attribute.PRIME);
        this.subprime_ = new ByteArrayAttribute(Attribute.SUBPRIME);
        this.base_ = new ByteArrayAttribute(Attribute.BASE);
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        KEAPublicKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        KEAPublicKey kEAPublicKey = (KEAPublicKey)super.clone();
        kEAPublicKey.prime_ = (ByteArrayAttribute)this.prime_.clone();
        kEAPublicKey.subprime_ = (ByteArrayAttribute)this.subprime_.clone();
        kEAPublicKey.base_ = (ByteArrayAttribute)this.base_.clone();
        kEAPublicKey.value_ = (ByteArrayAttribute)this.value_.clone();
        KEAPublicKey.putAttributesInTable(kEAPublicKey);
        return kEAPublicKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof KEAPublicKey) {
            KEAPublicKey kEAPublicKey = (KEAPublicKey)object;
            bl = this == kEAPublicKey || super.equals(kEAPublicKey) && this.prime_.equals(kEAPublicKey.prime_) && this.subprime_.equals(kEAPublicKey.subprime_) && this.base_.equals(kEAPublicKey.base_) && this.value_.equals(kEAPublicKey.value_);
        }
        return bl;
    }

    public ByteArrayAttribute getBase() {
        return this.base_;
    }

    public static Object getInstance(Session session, long l) throws TokenException {
        return new KEAPublicKey(session, l);
    }

    public ByteArrayAttribute getPrime() {
        return this.prime_;
    }

    public ByteArrayAttribute getSubprime() {
        return this.subprime_;
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    protected static void putAttributesInTable(KEAPublicKey kEAPublicKey) {
        if (kEAPublicKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        kEAPublicKey.attributeTable_.put(Attribute.PRIME, kEAPublicKey.prime_);
        kEAPublicKey.attributeTable_.put(Attribute.SUBPRIME, kEAPublicKey.subprime_);
        kEAPublicKey.attributeTable_.put(Attribute.BASE, kEAPublicKey.base_);
        kEAPublicKey.attributeTable_.put(Attribute.VALUE, kEAPublicKey.value_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValues(session, this.objectHandle_, new Attribute[]{this.prime_, this.subprime_, this.base_, this.value_});
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Prime (hex): ");
        stringBuffer.append(this.prime_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Subprime (hex): ");
        stringBuffer.append(this.subprime_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Base (hex): ");
        stringBuffer.append(this.base_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        return stringBuffer.toString();
    }
}

