/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class KEAPrivateKey
extends PrivateKey {
    protected ByteArrayAttribute prime_;
    protected ByteArrayAttribute subprime_;
    protected ByteArrayAttribute base_;
    protected ByteArrayAttribute value_;

    public KEAPrivateKey() {
        this.keyType_.setLongValue(Key.KeyType.KEA);
    }

    protected KEAPrivateKey(Session session, long l) throws TokenException {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.KEA);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.prime_ = new ByteArrayAttribute(Attribute.PRIME);
        this.subprime_ = new ByteArrayAttribute(Attribute.SUBPRIME);
        this.base_ = new ByteArrayAttribute(Attribute.BASE);
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        KEAPrivateKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        KEAPrivateKey kEAPrivateKey = (KEAPrivateKey)super.clone();
        kEAPrivateKey.prime_ = (ByteArrayAttribute)this.prime_.clone();
        kEAPrivateKey.subprime_ = (ByteArrayAttribute)this.subprime_.clone();
        kEAPrivateKey.base_ = (ByteArrayAttribute)this.base_.clone();
        kEAPrivateKey.value_ = (ByteArrayAttribute)this.value_.clone();
        KEAPrivateKey.putAttributesInTable(kEAPrivateKey);
        return kEAPrivateKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof KEAPrivateKey) {
            KEAPrivateKey kEAPrivateKey = (KEAPrivateKey)object;
            bl = this == kEAPrivateKey || super.equals(kEAPrivateKey) && this.prime_.equals(kEAPrivateKey.prime_) && this.subprime_.equals(kEAPrivateKey.subprime_) && this.base_.equals(kEAPrivateKey.base_) && this.value_.equals(kEAPrivateKey.value_);
        }
        return bl;
    }

    public ByteArrayAttribute getBase() {
        return this.base_;
    }

    public static Object getInstance(Session session, long l) throws TokenException {
        return new KEAPrivateKey(session, l);
    }

    public ByteArrayAttribute getPrime() {
        return this.prime_;
    }

    public ByteArrayAttribute getSubprime() {
        return this.subprime_;
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    protected static void putAttributesInTable(KEAPrivateKey kEAPrivateKey) {
        if (kEAPrivateKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        kEAPrivateKey.attributeTable_.put(Attribute.PRIME, kEAPrivateKey.prime_);
        kEAPrivateKey.attributeTable_.put(Attribute.SUBPRIME, kEAPrivateKey.subprime_);
        kEAPrivateKey.attributeTable_.put(Attribute.BASE, kEAPrivateKey.base_);
        kEAPrivateKey.attributeTable_.put(Attribute.VALUE, kEAPrivateKey.value_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValues(session, this.objectHandle_, new Attribute[]{this.prime_, this.subprime_, this.base_});
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Prime (hex): ");
        stringBuffer.append(this.prime_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Subprime (hex): ");
        stringBuffer.append(this.subprime_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Base (hex): ");
        stringBuffer.append(this.base_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        return stringBuffer.toString();
    }
}

