/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class CAST5SecretKey
extends SecretKey {
    protected ByteArrayAttribute value_;
    protected LongAttribute valueLen_;

    public CAST5SecretKey() {
        this.keyType_.setLongValue(Key.KeyType.CAST5);
    }

    protected CAST5SecretKey(Session session, long l) throws TokenException {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.CAST5);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        this.valueLen_ = new LongAttribute(Attribute.VALUE_LEN);
        CAST5SecretKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        CAST5SecretKey cAST5SecretKey = (CAST5SecretKey)super.clone();
        cAST5SecretKey.value_ = (ByteArrayAttribute)this.value_.clone();
        cAST5SecretKey.valueLen_ = (LongAttribute)this.valueLen_.clone();
        CAST5SecretKey.putAttributesInTable(cAST5SecretKey);
        return cAST5SecretKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof CAST5SecretKey) {
            CAST5SecretKey cAST5SecretKey = (CAST5SecretKey)object;
            bl = this == cAST5SecretKey || super.equals(cAST5SecretKey) && this.value_.equals(cAST5SecretKey.value_) && this.valueLen_.equals(cAST5SecretKey.valueLen_);
        }
        return bl;
    }

    public static Object getInstance(Session session, long l) throws TokenException {
        return new CAST5SecretKey(session, l);
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    public LongAttribute getValueLen() {
        return this.valueLen_;
    }

    protected static void putAttributesInTable(CAST5SecretKey cAST5SecretKey) {
        if (cAST5SecretKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        cAST5SecretKey.attributeTable_.put(Attribute.VALUE, cAST5SecretKey.value_);
        cAST5SecretKey.attributeTable_.put(Attribute.VALUE_LEN, cAST5SecretKey.valueLen_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
        Object.getAttributeValue(session, this.objectHandle_, this.valueLen_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value Length (dec): ");
        stringBuffer.append(this.valueLen_.toString(10));
        return stringBuffer.toString();
    }
}

