/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class BatonSecretKey
extends SecretKey {
    protected ByteArrayAttribute value_;

    public BatonSecretKey() {
        this.keyType_.setLongValue(Key.KeyType.BATON);
    }

    protected BatonSecretKey(Session session, long l) throws TokenException {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.BATON);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        BatonSecretKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        BatonSecretKey batonSecretKey = (BatonSecretKey)super.clone();
        batonSecretKey.value_ = (ByteArrayAttribute)this.value_.clone();
        BatonSecretKey.putAttributesInTable(batonSecretKey);
        return batonSecretKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof BatonSecretKey) {
            BatonSecretKey batonSecretKey = (BatonSecretKey)object;
            bl = this == batonSecretKey || super.equals(batonSecretKey) && this.value_.equals(batonSecretKey.value_);
        }
        return bl;
    }

    public static Object getInstance(Session session, long l) throws TokenException {
        return new BatonSecretKey(session, l);
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    protected static void putAttributesInTable(BatonSecretKey batonSecretKey) {
        if (batonSecretKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        batonSecretKey.attributeTable_.put(Attribute.VALUE, batonSecretKey.value_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        return stringBuffer.toString();
    }
}

