/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.TokenRuntimeException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.Version;
import iaik.pkcs.pkcs11.wrapper.CK_TOKEN_INFO;
import iaik.pkcs.pkcs11.wrapper.Constants;
import java.util.Date;

public class TokenInfo
implements Cloneable {
    public static final long EFFECTIVELY_INFINITE = 0L;
    public static final long UNAVAILABLE_INFORMATION = 0xFFFFFFFFL;
    protected String label_;
    protected String manufacturerID_;
    protected String model_;
    protected String serialNumber_;
    protected long maxSessionCount_;
    protected long sessionCount_;
    protected long maxRwSessionCount_;
    protected long rwSessionCount_;
    protected long maxPinLen_;
    protected long minPinLen_;
    protected long totalPublicMemory_;
    protected long freePublicMemory_;
    protected long totalPrivateMemory_;
    protected long freePrivateMemory_;
    protected Version hardwareVersion_;
    protected Version firmwareVersion_;
    protected Date time_;
    protected boolean rng_;
    protected boolean writeProtected_;
    protected boolean loginRequired_;
    protected boolean userPinInitialized_;
    protected boolean restoreKeyNotNeeded_;
    protected boolean clockOnToken_;
    protected boolean protectedAuthenticationPath_;
    protected boolean dualCryptoOperations_;
    protected boolean tokenInitialized_;
    protected boolean secondaryAuthentication_;
    protected boolean userPinCountLow_;
    protected boolean userPinFinalTry_;
    protected boolean userPinLocked_;
    protected boolean userPinToBeChanged_;
    protected boolean soPinCountLow_;
    protected boolean soPinFinalTry_;
    protected boolean soPinLocked_;
    protected boolean soPinToBeChanged_;

    protected TokenInfo(CK_TOKEN_INFO cK_TOKEN_INFO) {
        if (cK_TOKEN_INFO == null) {
            throw new NullPointerException("Argument \"ckTokenInfo\" must not be null.");
        }
        this.label_ = new String(cK_TOKEN_INFO.label);
        this.manufacturerID_ = new String(cK_TOKEN_INFO.manufacturerID);
        this.model_ = new String(cK_TOKEN_INFO.model);
        this.serialNumber_ = new String(cK_TOKEN_INFO.serialNumber);
        this.maxSessionCount_ = cK_TOKEN_INFO.ulMaxSessionCount;
        this.sessionCount_ = cK_TOKEN_INFO.ulSessionCount;
        this.maxRwSessionCount_ = cK_TOKEN_INFO.ulMaxRwSessionCount;
        this.rwSessionCount_ = cK_TOKEN_INFO.ulRwSessionCount;
        this.maxPinLen_ = cK_TOKEN_INFO.ulMaxPinLen;
        this.minPinLen_ = cK_TOKEN_INFO.ulMinPinLen;
        this.totalPublicMemory_ = cK_TOKEN_INFO.ulTotalPublicMemory;
        this.freePublicMemory_ = cK_TOKEN_INFO.ulFreePublicMemory;
        this.totalPrivateMemory_ = cK_TOKEN_INFO.ulTotalPrivateMemory;
        this.freePrivateMemory_ = cK_TOKEN_INFO.ulFreePrivateMemory;
        this.hardwareVersion_ = new Version(cK_TOKEN_INFO.hardwareVersion);
        this.firmwareVersion_ = new Version(cK_TOKEN_INFO.firmwareVersion);
        this.time_ = Util.parseTime(cK_TOKEN_INFO.utcTime);
        this.rng_ = (cK_TOKEN_INFO.flags & 1L) != 0L;
        this.writeProtected_ = (cK_TOKEN_INFO.flags & 2L) != 0L;
        this.loginRequired_ = (cK_TOKEN_INFO.flags & 4L) != 0L;
        this.userPinInitialized_ = (cK_TOKEN_INFO.flags & 8L) != 0L;
        this.restoreKeyNotNeeded_ = (cK_TOKEN_INFO.flags & 0x20L) != 0L;
        this.clockOnToken_ = (cK_TOKEN_INFO.flags & 0x40L) != 0L;
        this.protectedAuthenticationPath_ = (cK_TOKEN_INFO.flags & 0x100L) != 0L;
        this.dualCryptoOperations_ = (cK_TOKEN_INFO.flags & 0x200L) != 0L;
        this.tokenInitialized_ = (cK_TOKEN_INFO.flags & 0x400L) != 0L;
        this.secondaryAuthentication_ = (cK_TOKEN_INFO.flags & 0x800L) != 0L;
        this.userPinCountLow_ = (cK_TOKEN_INFO.flags & 0x10000L) != 0L;
        this.userPinFinalTry_ = (cK_TOKEN_INFO.flags & 0x20000L) != 0L;
        this.userPinLocked_ = (cK_TOKEN_INFO.flags & 0x40000L) != 0L;
        this.userPinToBeChanged_ = (cK_TOKEN_INFO.flags & 0x80000L) != 0L;
        this.soPinCountLow_ = (cK_TOKEN_INFO.flags & 0x100000L) != 0L;
        this.soPinFinalTry_ = (cK_TOKEN_INFO.flags & 0x200000L) != 0L;
        this.soPinLocked_ = (cK_TOKEN_INFO.flags & 0x400000L) != 0L;
        this.soPinToBeChanged_ = (cK_TOKEN_INFO.flags & 0x800000L) != 0L;
    }

    public Object clone() {
        TokenInfo tokenInfo;
        try {
            tokenInfo = (TokenInfo)super.clone();
            tokenInfo.hardwareVersion_ = (Version)this.hardwareVersion_.clone();
            tokenInfo.firmwareVersion_ = (Version)this.firmwareVersion_.clone();
            tokenInfo.time_ = new Date(this.time_.getTime());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", cloneNotSupportedException);
        }
        return tokenInfo;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof TokenInfo) {
            TokenInfo tokenInfo = (TokenInfo)object;
            bl = this == tokenInfo || this.label_.equals(tokenInfo.label_) && this.manufacturerID_.equals(tokenInfo.manufacturerID_) && this.model_.equals(tokenInfo.model_) && this.serialNumber_.equals(tokenInfo.serialNumber_) && this.maxSessionCount_ == tokenInfo.maxSessionCount_ && this.sessionCount_ == tokenInfo.sessionCount_ && this.maxRwSessionCount_ == tokenInfo.maxRwSessionCount_ && this.rwSessionCount_ == tokenInfo.rwSessionCount_ && this.maxPinLen_ == tokenInfo.maxPinLen_ && this.minPinLen_ == tokenInfo.minPinLen_ && this.totalPublicMemory_ == tokenInfo.totalPublicMemory_ && this.freePublicMemory_ == tokenInfo.freePublicMemory_ && this.totalPrivateMemory_ == tokenInfo.totalPrivateMemory_ && this.freePrivateMemory_ == tokenInfo.freePrivateMemory_ && this.hardwareVersion_.equals(tokenInfo.hardwareVersion_) && this.firmwareVersion_.equals(tokenInfo.firmwareVersion_) && this.time_.equals(tokenInfo.time_) && this.rng_ == tokenInfo.rng_ && this.writeProtected_ == tokenInfo.writeProtected_ && this.loginRequired_ == tokenInfo.loginRequired_ && this.userPinInitialized_ == tokenInfo.userPinInitialized_ && this.restoreKeyNotNeeded_ == tokenInfo.restoreKeyNotNeeded_ && this.clockOnToken_ == tokenInfo.clockOnToken_ && this.protectedAuthenticationPath_ == tokenInfo.protectedAuthenticationPath_ && this.dualCryptoOperations_ == tokenInfo.dualCryptoOperations_ && this.tokenInitialized_ == tokenInfo.tokenInitialized_ && this.secondaryAuthentication_ == tokenInfo.secondaryAuthentication_ && this.userPinCountLow_ == tokenInfo.userPinCountLow_ && this.userPinFinalTry_ == tokenInfo.userPinFinalTry_ && this.userPinLocked_ == tokenInfo.userPinLocked_ && this.userPinToBeChanged_ == tokenInfo.userPinToBeChanged_ && this.soPinCountLow_ == tokenInfo.soPinCountLow_ && this.soPinFinalTry_ == tokenInfo.soPinFinalTry_ && this.soPinLocked_ == tokenInfo.soPinLocked_ && this.soPinToBeChanged_ == tokenInfo.soPinToBeChanged_;
        }
        return bl;
    }

    public Version getFirmwareVersion() {
        return this.firmwareVersion_;
    }

    public long getFreePrivateMemory() {
        return this.freePrivateMemory_;
    }

    public long getFreePublicMemory() {
        return this.freePublicMemory_;
    }

    public Version getHardwareVersion() {
        return this.hardwareVersion_;
    }

    public String getLabel() {
        return this.label_;
    }

    public String getManufacturerID() {
        return this.manufacturerID_;
    }

    public long getMaxPinLen() {
        return this.maxPinLen_;
    }

    public long getMaxRwSessionCount() {
        return this.maxRwSessionCount_;
    }

    public long getMaxSessionCount() {
        return this.maxSessionCount_;
    }

    public long getMinPinLen() {
        return this.minPinLen_;
    }

    public String getModel() {
        return this.model_;
    }

    public long getRwSessionCount() {
        return this.rwSessionCount_;
    }

    public String getSerialNumber() {
        return this.serialNumber_;
    }

    public long getSessionCount() {
        return this.sessionCount_;
    }

    public Date getTime() {
        return this.time_;
    }

    public long getTotalPrivateMemory() {
        return this.totalPrivateMemory_;
    }

    public long getTotalPublicMemory() {
        return this.totalPublicMemory_;
    }

    public int hashCode() {
        return this.label_.hashCode() ^ this.manufacturerID_.hashCode() ^ this.model_.hashCode() ^ this.serialNumber_.hashCode();
    }

    public boolean isClockOnToken() {
        return this.clockOnToken_;
    }

    public boolean isDualCryptoOperations() {
        return this.dualCryptoOperations_;
    }

    public boolean isLoginRequired() {
        return this.loginRequired_;
    }

    public boolean isProtectedAuthenticationPath() {
        return this.protectedAuthenticationPath_;
    }

    public boolean isRNG() {
        return this.rng_;
    }

    public boolean isRestoreKeyNotNeeded() {
        return this.restoreKeyNotNeeded_;
    }

    public boolean isSecondaryAuthentication() {
        return this.secondaryAuthentication_;
    }

    public boolean isSoPinCountLow() {
        return this.soPinCountLow_;
    }

    public boolean isSoPinFinalTry() {
        return this.soPinFinalTry_;
    }

    public boolean isSoPinLocked() {
        return this.soPinLocked_;
    }

    public boolean isSoPinToBeChanged() {
        return this.soPinToBeChanged_;
    }

    public boolean isTokenInitialized() {
        return this.tokenInitialized_;
    }

    public boolean isUserPinCountLow() {
        return this.userPinCountLow_;
    }

    public boolean isUserPinFinalTry() {
        return this.userPinFinalTry_;
    }

    public boolean isUserPinInitialized() {
        return this.userPinInitialized_;
    }

    public boolean isUserPinLocked() {
        return this.userPinLocked_;
    }

    public boolean isUserPinToBeChanged() {
        return this.userPinToBeChanged_;
    }

    public boolean isWriteProtected() {
        return this.writeProtected_;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Label: ");
        stringBuffer.append(this.label_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Manufacturer ID: ");
        stringBuffer.append(this.manufacturerID_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Model: ");
        stringBuffer.append(this.model_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Serial Number: ");
        stringBuffer.append(this.serialNumber_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Random Number Generator: ");
        stringBuffer.append(this.rng_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Write protected: ");
        stringBuffer.append(this.writeProtected_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Login required: ");
        stringBuffer.append(this.loginRequired_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("User PIN initialized: ");
        stringBuffer.append(this.userPinInitialized_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Restore Key not needed: ");
        stringBuffer.append(this.restoreKeyNotNeeded_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Clock on Token: ");
        stringBuffer.append(this.clockOnToken_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Protected Authentication Path: ");
        stringBuffer.append(this.protectedAuthenticationPath_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Dual Crypto Operations: ");
        stringBuffer.append(this.dualCryptoOperations_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Token initialized: ");
        stringBuffer.append(this.tokenInitialized_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Secondary Authentication: ");
        stringBuffer.append(this.secondaryAuthentication_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("User PIN-Count low: ");
        stringBuffer.append(this.userPinCountLow_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("User PIN final Try: ");
        stringBuffer.append(this.userPinFinalTry_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("User PIN locked: ");
        stringBuffer.append(this.userPinLocked_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("User PIN to be changed: ");
        stringBuffer.append(this.userPinToBeChanged_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Security Officer PIN-Count low: ");
        stringBuffer.append(this.soPinCountLow_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Security Officer PIN final Try: ");
        stringBuffer.append(this.soPinFinalTry_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Security Officer PIN locked: ");
        stringBuffer.append(this.soPinLocked_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Security Officer PIN to be changed: ");
        stringBuffer.append(this.soPinToBeChanged_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Maximum Session Count: ");
        stringBuffer.append(this.maxSessionCount_ == 0xFFFFFFFFL ? "<Information unavailable>" : (this.maxSessionCount_ == 0L ? "<effectively infinite>" : Long.toString(this.maxSessionCount_)));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Session Count: ");
        stringBuffer.append(this.sessionCount_ == 0xFFFFFFFFL ? "<Information unavailable>" : Long.toString(this.sessionCount_));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Maximum Read/Write Session Count: ");
        stringBuffer.append(this.maxRwSessionCount_ == 0xFFFFFFFFL ? "<Information unavailable>" : (this.maxRwSessionCount_ == 0L ? "<effectively infinite>" : Long.toString(this.maxRwSessionCount_)));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Read/Write Session Count: ");
        stringBuffer.append(this.rwSessionCount_ == 0xFFFFFFFFL ? "<Information unavailable>" : Long.toString(this.rwSessionCount_));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Maximum PIN Length: ");
        stringBuffer.append(this.maxPinLen_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Minimum PIN Length: ");
        stringBuffer.append(this.minPinLen_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Total Public Memory: ");
        stringBuffer.append(this.totalPublicMemory_ == 0xFFFFFFFFL ? "<Information unavailable>" : Long.toString(this.totalPublicMemory_));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Free Public Memory: ");
        stringBuffer.append(this.freePublicMemory_ == 0xFFFFFFFFL ? "<Information unavailable>" : Long.toString(this.freePublicMemory_));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Total Private Memory: ");
        stringBuffer.append(this.totalPrivateMemory_ == 0xFFFFFFFFL ? "<Information unavailable>" : Long.toString(this.totalPrivateMemory_));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Free Private Memory: ");
        stringBuffer.append(this.freePrivateMemory_ == 0xFFFFFFFFL ? "<Information unavailable>" : Long.toString(this.freePrivateMemory_));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Hardware Version: ");
        stringBuffer.append(this.hardwareVersion_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Firmware Version: ");
        stringBuffer.append(this.firmwareVersion_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("Time: ");
        stringBuffer.append(this.time_);
        return stringBuffer.toString();
    }
}

