/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import iaik.pkcs.pkcs7.SignedDataStream;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.security.provider.IAIK;
import iaik.x509.X509Certificate;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;

public class VerifyPKCS7SignedData {
    public static void main(String[] stringArray) {
        if (stringArray.length != 1 && stringArray.length != 2) {
            VerifyPKCS7SignedData.printUsage();
            System.exit(1);
        }
        try {
            int n;
            Security.addProvider((Provider)new IAIK());
            System.out.println("Verifying PKCS#7 signed data from file: " + stringArray[0]);
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            SignedDataStream signedDataStream = new SignedDataStream((InputStream)fileInputStream);
            InputStream inputStream = signedDataStream.getInputStream();
            FileOutputStream fileOutputStream = stringArray.length == 2 ? new FileOutputStream(stringArray[1]) : null;
            byte[] byArray = new byte[1024];
            if (fileOutputStream != null) {
                while ((n = inputStream.read(byArray)) > 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                System.out.println("Verified content written to: " + stringArray[1]);
                System.out.println("________________________________________________________________________________");
            } else {
                System.out.println("The signed content data is: ");
                System.out.println("________________________________________________________________________________");
                while ((n = inputStream.read(byArray)) > 0) {
                    System.out.write(byArray, 0, n);
                }
                System.out.println();
                System.out.println("________________________________________________________________________________");
            }
            SignerInfo[] signerInfoArray = signedDataStream.getSignerInfos();
            int n2 = 0;
            while (n2 < signerInfoArray.length) {
                try {
                    X509Certificate x509Certificate = signedDataStream.verify(n2);
                    System.out.println("Signature OK from signer with certificate: ");
                    System.out.println(x509Certificate);
                    System.out.println();
                }
                catch (SignatureException signatureException) {
                    System.out.println("Signature ERROR from signer with certificate: ");
                    System.out.println(signedDataStream.getCertificate(signerInfoArray[n2].getIssuerAndSerialNumber()));
                    System.out.println();
                    signatureException.printStackTrace();
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printUsage() {
        System.out.println("Usage: VerifyPKCS7SignedData <PKCS#7 signed data file> <verified content data>");
        System.out.println(" e.g.: VerifyPKCS7SignedData signedData.p7 verifiedContentData.dat");
    }
}

