/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import demo.pkcs.pkcs11.KeyAndCertificate;
import demo.pkcs.pkcs11.Util;
import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import iaik.pkcs.pkcs7.DigestInfo;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.pkcs.pkcs7.SignedData;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.x509.X509Certificate;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;

public class SignPKCS7 {
    static PrintWriter output_;
    static BufferedReader input_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            SignPKCS7.printUsage();
            System.exit(1);
        }
        try {
            try {
                int n;
                MechanismInfo mechanismInfo;
                List<Mechanism> list;
                Module module = Module.getInstance((String)stringArray[0]);
                module.initialize(null);
                Token token = Util.selectToken(module, output_, input_);
                if (token == null) {
                    output_.println("We have no token to proceed. Finished.");
                    output_.flush();
                    System.exit(0);
                }
                if (!(list = Arrays.asList(token.getMechanismList())).contains(Mechanism.RSA_PKCS)) {
                    output_.print("This token does not support raw RSA signing!");
                    output_.flush();
                    System.exit(0);
                } else {
                    mechanismInfo = token.getMechanismInfo(Mechanism.RSA_PKCS);
                    if (!mechanismInfo.isSign()) {
                        output_.print("This token does not support RSA signing according to PKCS!");
                        output_.flush();
                        System.exit(0);
                    }
                }
                mechanismInfo = Util.openAuthorizedSession(token, false, output_, input_);
                RSAPrivateKey rSAPrivateKey = new RSAPrivateKey();
                rSAPrivateKey.getSign().setBooleanValue(Boolean.TRUE);
                KeyAndCertificate keyAndCertificate = Util.selectKeyAndCertificate((Session)mechanismInfo, (Key)rSAPrivateKey, output_, input_);
                if (keyAndCertificate == null) {
                    output_.println("We have no signature key to proceed. Finished.");
                    output_.flush();
                    System.exit(0);
                }
                PrivateKey privateKey = (PrivateKey)keyAndCertificate.getKey();
                X509PublicKeyCertificate x509PublicKeyCertificate = keyAndCertificate.getCertificate();
                X509Certificate x509Certificate = x509PublicKeyCertificate != null ? new X509Certificate(x509PublicKeyCertificate.getValue().getByteArrayValue()) : null;
                output_.println("################################################################################");
                output_.println("signing data from file: " + stringArray[1]);
                FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                while ((n = ((InputStream)fileInputStream).read(byArray)) >= 0) {
                    messageDigest.update(byArray, 0, n);
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byte[] byArray2 = messageDigest.digest();
                byteArrayOutputStream.close();
                SignedData signedData = new SignedData(byteArrayOutputStream.toByteArray(), 1);
                signedData.setCertificates(new X509Certificate[]{x509Certificate});
                SignerInfo signerInfo = new SignerInfo(new IssuerAndSerialNumber((java.security.cert.X509Certificate)x509Certificate), AlgorithmID.sha1, null);
                Attribute[] attributeArray = new Attribute[]{new Attribute(ObjectID.contentType, new ASN1Object[]{ObjectID.pkcs7_data}), new Attribute(ObjectID.signingTime, new ASN1Object[]{new ChoiceOfTime().toASN1Object()}), new Attribute(ObjectID.messageDigest, new ASN1Object[]{new OCTET_STRING(byArray2)})};
                signerInfo.setAuthenticatedAttributes(attributeArray);
                byte[] byArray3 = DerCoder.encode((ASN1Object)ASN.createSetOf((ASN1Type[])attributeArray, (boolean)true));
                byte[] byArray4 = messageDigest.digest(byArray3);
                DigestInfo digestInfo = new DigestInfo(AlgorithmID.sha1, byArray4);
                byte[] byArray5 = digestInfo.toByteArray();
                mechanismInfo.signInit(Mechanism.RSA_PKCS, (Key)privateKey);
                byte[] byArray6 = mechanismInfo.sign(byArray5);
                signerInfo.setEncryptedDigest(byArray6);
                signedData.addSignerInfo(signerInfo);
                output_.println("Writing signature to file: " + stringArray[2]);
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[2]);
                signedData.writeTo((OutputStream)fileOutputStream);
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                output_.println("################################################################################");
                mechanismInfo.closeSession();
                module.finalize(null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            Object var2_26 = null;
            output_.close();
        }
        catch (Throwable throwable) {
            Object var2_27 = null;
            output_.close();
            throw throwable;
        }
    }

    public static void printUsage() {
        output_.println("Usage: SignPKCS7 <PKCS#11 module> <file to be signed> <PKCS#7 signed data file>");
        output_.println(" e.g.: SignPKCS7 pk2priv.dll data.dat signedData.p7");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

