/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import demo.pkcs.pkcs11.AlgorithmIDAdapter;
import demo.pkcs.pkcs11.KeyAndCertificate;
import demo.pkcs.pkcs11.PKCS11SignatureEngine;
import demo.pkcs.pkcs11.TokenPrivateKey;
import demo.pkcs.pkcs11.Util;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.GeneralName;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import iaik.x509.X509Certificate;
import iaik.x509.ocsp.OCSPRequest;
import iaik.x509.ocsp.ReqCert;
import iaik.x509.ocsp.Request;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Arrays;
import java.util.List;

public class SignOCSPRequest {
    static PrintWriter output_;
    static BufferedReader input_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            SignOCSPRequest.printUsage();
            System.exit(1);
        }
        try {
            try {
                Object object;
                MechanismInfo mechanismInfo;
                List<Mechanism> list;
                Module module = Module.getInstance((String)stringArray[0]);
                module.initialize(null);
                Token token = Util.selectToken(module, output_, input_);
                if (token == null) {
                    output_.println("We have no token to proceed. Finished.");
                    output_.flush();
                    System.exit(0);
                }
                if (!(list = Arrays.asList(token.getMechanismList())).contains(Mechanism.RSA_PKCS)) {
                    output_.print("This token does not support raw RSA signing!");
                    output_.flush();
                    System.exit(0);
                } else {
                    mechanismInfo = token.getMechanismInfo(Mechanism.RSA_PKCS);
                    if (!mechanismInfo.isSign()) {
                        output_.print("This token does not support RSA signing according to PKCS!");
                        output_.flush();
                        System.exit(0);
                    }
                }
                mechanismInfo = Util.openAuthorizedSession(token, false, output_, input_);
                RSAPrivateKey rSAPrivateKey = new RSAPrivateKey();
                rSAPrivateKey.getSign().setBooleanValue(Boolean.TRUE);
                KeyAndCertificate keyAndCertificate = Util.selectKeyAndCertificate((Session)mechanismInfo, (Key)rSAPrivateKey, output_, input_);
                if (keyAndCertificate == null) {
                    output_.println("We have no signature key to proceed. Finished.");
                    output_.flush();
                    System.exit(0);
                }
                iaik.pkcs.pkcs11.objects.PrivateKey privateKey = (iaik.pkcs.pkcs11.objects.PrivateKey)keyAndCertificate.getKey();
                X509PublicKeyCertificate x509PublicKeyCertificate = keyAndCertificate.getCertificate();
                X509Certificate x509Certificate = x509PublicKeyCertificate != null ? new X509Certificate(x509PublicKeyCertificate.getValue().getByteArrayValue()) : null;
                output_.println("################################################################################");
                output_.println("creating and signing OCSP request");
                FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
                X509Certificate x509Certificate2 = new X509Certificate((InputStream)fileInputStream);
                ReqCert reqCert = new ReqCert(2, (Object)x509Certificate2);
                Request request = new Request(reqCert);
                OCSPRequest oCSPRequest = new OCSPRequest();
                oCSPRequest.setRequestList(new Request[]{request});
                if (x509Certificate != null) {
                    object = new GeneralName(4, (Object)x509Certificate.getSubjectDN());
                    oCSPRequest.setRequestorName(object);
                    oCSPRequest.setCertificates(new X509Certificate[]{x509Certificate});
                }
                object = new PKCS11SignatureEngine("SHA1withRSA", (Session)mechanismInfo, Mechanism.RSA_PKCS, AlgorithmID.sha1);
                AlgorithmIDAdapter algorithmIDAdapter = new AlgorithmIDAdapter(AlgorithmID.sha1WithRSAEncryption);
                algorithmIDAdapter.setSignatureInstance((Signature)object);
                TokenPrivateKey tokenPrivateKey = new TokenPrivateKey(privateKey);
                output_.print("signing OCSP request... ");
                oCSPRequest.sign((AlgorithmID)algorithmIDAdapter, (PrivateKey)tokenPrivateKey);
                output_.println("finished");
                output_.print("writing OCSP request to file \"");
                output_.print(stringArray[2]);
                output_.print("\"... ");
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[2]);
                oCSPRequest.writeTo((OutputStream)fileOutputStream);
                output_.println("finished");
                output_.println("################################################################################");
                mechanismInfo.closeSession();
                module.finalize(null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            Object var2_20 = null;
            output_.close();
        }
        catch (Throwable throwable) {
            Object var2_21 = null;
            output_.close();
            throw throwable;
        }
    }

    public static void printUsage() {
        output_.println("Usage: SignOCSPRequest <PKCS#11 module> <DER-encoded X.509 subject certificate> <DER-encoded OCSP request output file>");
        output_.println(" e.g.: SignOCSPRequest pk2priv.dll subjectCert.der signedOCSPrequest.der");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

