/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import demo.pkcs.pkcs11.AlgorithmIDAdapter;
import demo.pkcs.pkcs11.KeyAndCertificate;
import demo.pkcs.pkcs11.PKCS11SignatureEngine;
import demo.pkcs.pkcs11.TokenPrivateKey;
import demo.pkcs.pkcs11.Util;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.x509.X509Certificate;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.List;

public class SignCertificate {
    static PrintWriter output_;
    static BufferedReader input_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            SignCertificate.printUsage();
            System.exit(1);
        }
        try {
            try {
                MechanismInfo mechanismInfo;
                List<Mechanism> list;
                Module module = Module.getInstance((String)stringArray[0]);
                module.initialize(null);
                Token token = Util.selectToken(module, output_, input_);
                if (token == null) {
                    output_.println("We have no token to proceed. Finished.");
                    output_.flush();
                    System.exit(0);
                }
                if (!(list = Arrays.asList(token.getMechanismList())).contains(Mechanism.RSA_PKCS)) {
                    output_.print("This token does not support raw RSA signing!");
                    output_.flush();
                    System.exit(0);
                } else {
                    mechanismInfo = token.getMechanismInfo(Mechanism.RSA_PKCS);
                    if (!mechanismInfo.isSign()) {
                        output_.print("This token does not support RSA signing according to PKCS!");
                        output_.flush();
                        System.exit(0);
                    }
                }
                mechanismInfo = Util.openAuthorizedSession(token, false, output_, input_);
                RSAPrivateKey rSAPrivateKey = new RSAPrivateKey();
                rSAPrivateKey.getSign().setBooleanValue(Boolean.TRUE);
                KeyAndCertificate keyAndCertificate = Util.selectKeyAndCertificate((Session)mechanismInfo, (Key)rSAPrivateKey, output_, input_);
                if (keyAndCertificate == null) {
                    output_.println("We have no signature key to proceed. Finished.");
                    output_.flush();
                    System.exit(0);
                }
                iaik.pkcs.pkcs11.objects.PrivateKey privateKey = (iaik.pkcs.pkcs11.objects.PrivateKey)keyAndCertificate.getKey();
                output_.println("################################################################################");
                output_.println("signing demo certificate");
                PKCS11SignatureEngine pKCS11SignatureEngine = new PKCS11SignatureEngine("SHA1withRSA", (Session)mechanismInfo, Mechanism.RSA_PKCS, AlgorithmID.sha1);
                AlgorithmIDAdapter algorithmIDAdapter = new AlgorithmIDAdapter(AlgorithmID.sha1WithRSAEncryption);
                algorithmIDAdapter.setSignatureInstance(pKCS11SignatureEngine);
                FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
                X509Certificate x509Certificate = new X509Certificate((InputStream)fileInputStream);
                TokenPrivateKey tokenPrivateKey = new TokenPrivateKey(privateKey);
                output_.print("signing certificate... ");
                x509Certificate.sign((AlgorithmID)algorithmIDAdapter, (PrivateKey)tokenPrivateKey);
                output_.println("finished");
                output_.print("writing certificate to file \"");
                output_.print(stringArray[2]);
                output_.print("\"... ");
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[2]);
                x509Certificate.writeTo((OutputStream)fileOutputStream);
                output_.println("finished");
                output_.println("################################################################################");
                mechanismInfo.closeSession();
                module.finalize(null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            Object var2_15 = null;
            output_.close();
        }
        catch (Throwable throwable) {
            Object var2_16 = null;
            output_.close();
            throw throwable;
        }
    }

    public static void printUsage() {
        output_.println("Usage: SignCertificate <PKCS#11 module> <DER-encoded X.509 template certificate> <DER-encoded certificate output file>");
        output_.println(" e.g.: SignCertificate pk2priv.dll templateCert.der signedCert.der");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

