/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class SetPIN {
    static PrintWriter output_;
    static BufferedReader input_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            SetPIN.printUsage();
            System.exit(1);
        }
        try {
            Slot slot;
            Module module = Module.getInstance((String)stringArray[0]);
            module.initialize(null);
            Slot[] slotArray = module.getSlotList(true);
            if (slotArray.length == 0) {
                output_.println("No slot with present token found!");
                System.exit(0);
            }
            Token token = null;
            if (slotArray.length == 1) {
                slot = slotArray[0];
                token = slot.getToken();
            } else {
                output_.println("Found several tokens: ");
                int n = 0;
                while (n < slotArray.length) {
                    token = slotArray[n].getToken();
                    output_.println("________________________________________________________________________________");
                    output_.print("Info of Token number ");
                    output_.println(n);
                    output_.println(token.getTokenInfo());
                    output_.println("________________________________________________________________________________");
                    ++n;
                }
                output_.println();
                output_.print("For which token do you want to set the PIN? Please enter its number [0..");
                output_.print(slotArray.length);
                output_.print("]: ");
                output_.flush();
                String string = input_.readLine();
                int n2 = Integer.parseInt(string);
                token = slotArray[n2].getToken();
            }
            slot = token.getTokenInfo();
            output_.println("################################################################################");
            output_.println("Information of selsected Token:");
            output_.println(slot);
            output_.println("################################################################################");
            boolean bl = true;
            if (stringArray[1].equalsIgnoreCase("USER")) {
                bl = true;
            } else if (stringArray[1].equalsIgnoreCase("SO")) {
                bl = false;
            } else {
                output_.println("Unknown user type: " + stringArray[1]);
                SetPIN.printUsage();
                module.finalize(null);
                System.exit(1);
            }
            String string = bl ? "user" : "security officer";
            output_.println("################################################################################");
            output_.println("setting " + string + " PIN");
            Session session = token.openSession(true, true, null, null);
            if (slot.isLoginRequired()) {
                if (slot.isProtectedAuthenticationPath()) {
                    session.login(bl, null);
                    session.setPIN(null, null);
                } else {
                    output_.print("Enter current " + string + " PIN: ");
                    output_.flush();
                    String string2 = input_.readLine();
                    char[] cArray = string2.toCharArray();
                    session.login(bl, cArray);
                    char[] cArray2 = null;
                    boolean bl2 = false;
                    do {
                        output_.print("Enter new " + string + " PIN: ");
                        output_.flush();
                        String string3 = input_.readLine();
                        output_.print("Enter new " + string + " PIN again for confirmation: ");
                        output_.flush();
                        String string4 = input_.readLine();
                        if (!string3.equals(string4)) {
                            output_.println("The two entries do not match. Try again.");
                            bl2 = true;
                            continue;
                        }
                        cArray2 = string3.toCharArray();
                        bl2 = false;
                    } while (bl2);
                    session.setPIN(cArray, cArray2);
                }
            } else {
                output_.println("This token does not require a login. It does not use a PIN.");
            }
            output_.println("FINISHED");
            output_.println("################################################################################");
            module.finalize(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printUsage() {
        output_.println("Usage: SetPIN <PKCS#11 module> (USER|SO)");
        output_.println(" e.g.: SetPIN pk2priv.dll USER");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

