/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import demo.pkcs.pkcs11.AlgorithmIDAdapter;
import demo.pkcs.pkcs11.KeyAndCertificate;
import demo.pkcs.pkcs11.PKCS11SignatureEngine;
import demo.pkcs.pkcs11.TokenPrivateKey;
import demo.pkcs.pkcs11.Util;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Name;
import iaik.asn1.structures.PolicyInformation;
import iaik.asn1.structures.PolicyQualifierInfo;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.security.rsa.RSAPublicKey;
import iaik.utils.RFC2253NameParser;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.CertificatePolicies;
import iaik.x509.extensions.KeyUsage;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

public class SelfSignCertificate {
    static PrintWriter output_;
    static BufferedReader input_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            SelfSignCertificate.printUsage();
            System.exit(1);
        }
        try {
            try {
                CertificatePolicies certificatePolicies;
                MechanismInfo mechanismInfo;
                List<Mechanism> list;
                Module module = Module.getInstance((String)stringArray[0]);
                module.initialize(null);
                Token token = Util.selectToken(module, output_, input_);
                if (token == null) {
                    output_.println("We have no token to proceed. Finished.");
                    output_.flush();
                    System.exit(0);
                }
                if (!(list = Arrays.asList(token.getMechanismList())).contains(Mechanism.RSA_PKCS)) {
                    output_.print("This token does not support raw RSA signing!");
                    output_.flush();
                    System.exit(0);
                } else {
                    mechanismInfo = token.getMechanismInfo(Mechanism.RSA_PKCS);
                    if (!mechanismInfo.isSign()) {
                        output_.print("This token does not support RSA signing according to PKCS!");
                        output_.flush();
                        System.exit(0);
                    }
                }
                mechanismInfo = Util.openAuthorizedSession(token, false, output_, input_);
                RSAPrivateKey rSAPrivateKey = new RSAPrivateKey();
                rSAPrivateKey.getSign().setBooleanValue(Boolean.TRUE);
                KeyAndCertificate keyAndCertificate = Util.selectKeyAndCertificate((Session)mechanismInfo, (Key)rSAPrivateKey, output_, input_);
                if (keyAndCertificate == null) {
                    output_.println("We have no signature key to proceed. Finished.");
                    output_.flush();
                    System.exit(0);
                }
                RSAPrivateKey rSAPrivateKey2 = (RSAPrivateKey)keyAndCertificate.getKey();
                byte[] byArray = rSAPrivateKey2.getModulus().getByteArrayValue();
                byte[] byArray2 = rSAPrivateKey2.getPublicExponent().getByteArrayValue();
                RSAPublicKey rSAPublicKey = new RSAPublicKey(new BigInteger(1, byArray), new BigInteger(1, byArray2));
                output_.println("################################################################################");
                output_.println("slef-signing demo certificate");
                PKCS11SignatureEngine pKCS11SignatureEngine = new PKCS11SignatureEngine("SHA1withRSA", (Session)mechanismInfo, Mechanism.RSA_PKCS, AlgorithmID.sha1);
                AlgorithmIDAdapter algorithmIDAdapter = new AlgorithmIDAdapter(AlgorithmID.sha1WithRSAEncryption);
                algorithmIDAdapter.setSignatureInstance(pKCS11SignatureEngine);
                RFC2253NameParser rFC2253NameParser = new RFC2253NameParser(stringArray[1]);
                Name name = rFC2253NameParser.parse();
                X509Certificate x509Certificate = new X509Certificate();
                x509Certificate.setSubjectDN((Principal)name);
                x509Certificate.setIssuerDN((Principal)name);
                x509Certificate.setPublicKey((PublicKey)rSAPublicKey);
                x509Certificate.setSerialNumber(new BigInteger("1"));
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                x509Certificate.setValidNotBefore(gregorianCalendar.getTime());
                ((Calendar)gregorianCalendar).add(1, 3);
                x509Certificate.setValidNotAfter(gregorianCalendar.getTime());
                BasicConstraints basicConstraints = new BasicConstraints(true);
                x509Certificate.addExtension((V3Extension)basicConstraints);
                KeyUsage keyUsage = new KeyUsage(97);
                x509Certificate.addExtension((V3Extension)keyUsage);
                PolicyQualifierInfo policyQualifierInfo = new PolicyQualifierInfo(null, null, "This certificate may be used for demonstration purposes only.");
                PolicyInformation policyInformation = new PolicyInformation(new ObjectID("1.3.6.1.4.1.2706.2.2.1.1.1.1.1"), new PolicyQualifierInfo[]{policyQualifierInfo});
                CertificatePolicies certificatePolicies2 = certificatePolicies = new CertificatePolicies(new PolicyInformation[]{policyInformation});
                x509Certificate.addExtension((V3Extension)certificatePolicies2);
                TokenPrivateKey tokenPrivateKey = new TokenPrivateKey((iaik.pkcs.pkcs11.objects.PrivateKey)rSAPrivateKey2);
                output_.print("signing certificate... ");
                x509Certificate.sign((AlgorithmID)algorithmIDAdapter, (PrivateKey)tokenPrivateKey);
                output_.println("finished");
                output_.print("writing certificate to file \"");
                output_.print(stringArray[2]);
                output_.print("\"... ");
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[2]);
                x509Certificate.writeTo((OutputStream)fileOutputStream);
                output_.println("finished");
                output_.println("################################################################################");
                mechanismInfo.closeSession();
                module.finalize(null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            Object var2_26 = null;
            output_.close();
        }
        catch (Throwable throwable) {
            Object var2_27 = null;
            output_.close();
            throw throwable;
        }
    }

    public static void printUsage() {
        output_.println("Usage: SelfSignCertificate <PKCS#11 module> <RFC2253 subject name> <DER-encoded certificate output file>");
        output_.println(" e.g.: SelfSignCertificate aetpkss1.dll \"CN=Karl Scheibelhofer,O=IAIK,C=AT,EMAIL=karl.scheibelhofer@iaik.at\" selfSignedCert.der");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

