/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.X942DH2KeyDerivationParameters;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class ParametersTest {
    static PrintWriter output_;
    static BufferedReader input_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            ParametersTest.printUsage();
            System.exit(1);
        }
        try {
            Module module = Module.getInstance((String)stringArray[0]);
            module.initialize(null);
            Slot[] slotArray = module.getSlotList(true);
            if (slotArray.length == 0) {
                output_.println("No slot with present token found!");
                output_.flush();
                System.exit(0);
            }
            Slot slot = slotArray[0];
            Token token = slot.getToken();
            Session session = token.openSession(true, false, null, null);
            output_.println("################################################################################");
            Key key = new Key();
            Key key2 = new Key();
            key.setObjectHandle(1L);
            key2.setObjectHandle(2L);
            output_.print("testing X942DH2KeyDerivationParameters... ");
            long l = 3L;
            byte[] byArray = new byte[8];
            byArray[1] = 1;
            byArray[2] = 2;
            byArray[3] = 3;
            byArray[4] = 4;
            byArray[5] = 5;
            byArray[6] = 6;
            byArray[7] = 7;
            byte[] byArray2 = byArray;
            byte[] byArray3 = new byte[]{8, 9, 10, 11, 12, 13, 14, 15};
            byte[] byArray4 = new byte[]{16, 17, 18, 19, 20, 21, 22, 23};
            long l2 = 16L;
            Key key3 = new Key();
            key3.setObjectHandle(3L);
            X942DH2KeyDerivationParameters x942DH2KeyDerivationParameters = new X942DH2KeyDerivationParameters(l, byArray2, byArray3, l2, (iaik.pkcs.pkcs11.objects.Object)key3, byArray4);
            Mechanism mechanism = (Mechanism)Mechanism.X9_42_DH_HYBRID_DERIVE.clone();
            mechanism.setParameters((Parameters)x942DH2KeyDerivationParameters);
            session.deriveKey(mechanism, key, key2);
            output_.println("finished");
            output_.flush();
            output_.println("################################################################################");
            session.closeSession();
            module.finalize(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        output_.println("press any key to continue...");
        try {
            input_.read();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printUsage() {
        output_.println("Usage: ParametersTest <PKCS#11 module>");
        output_.println(" e.g.: ParametersTest pk2priv.dll");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

