/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import demo.pkcs.pkcs11.Util;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.Name;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.objects.DHPrivateKey;
import iaik.pkcs.pkcs11.objects.DSAPrivateKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import iaik.security.provider.IAIK;
import iaik.x509.X509Certificate;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collection;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

public class ImportCertificate {
    static BufferedReader input_;
    static PrintWriter output_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            ImportCertificate.printUsage();
            System.exit(1);
        }
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Provider provider;
            Module module;
            Security.addProvider((Provider)new IAIK());
            try {
                module = Class.forName("iaik.security.ecc.provider.ECCProvider");
                provider = (Provider)module.newInstance();
                Security.addProvider(provider);
            }
            catch (Exception exception) {}
            module = Module.getInstance((String)stringArray[0]);
            module.initialize(null);
            provider = Util.selectToken(module, output_, input_);
            if (provider == null) {
                output_.println("We have no token to proceed. Finished.");
                output_.flush();
                System.exit(0);
            }
            TokenInfo tokenInfo = provider.getTokenInfo();
            output_.println("################################################################################");
            output_.println("Information of Token:");
            output_.println(tokenInfo);
            output_.println("################################################################################");
            output_.println("################################################################################");
            output_.println("Reading certificate from file: " + stringArray[1]);
            Session session = Util.openAuthorizedSession((Token)provider, true, output_, input_);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "IAIK");
            FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
            Collection<? extends Certificate> collection = certificateFactory.generateCertificates(fileInputStream);
            if (collection.size() < 1) {
                output_.println("Did not find any certificate in the given input file. Finished.");
                output_.flush();
                System.exit(0);
            }
            X509Certificate x509Certificate = (X509Certificate)collection.iterator().next();
            collection.remove(x509Certificate);
            output_.println("################################################################################");
            output_.println("################################################################################");
            output_.println("Searching for corresponding private key on token.");
            PublicKey publicKey = x509Certificate.getPublicKey();
            Object object7 = null;
            if (publicKey.getAlgorithm().equalsIgnoreCase("RSA")) {
                object6 = (RSAPublicKey)publicKey;
                object5 = new RSAPrivateKey();
                object4 = iaik.pkcs.pkcs11.Util.unsignedBigIntergerToByteArray((BigInteger)object6.getModulus());
                object5.getModulus().setByteArrayValue(object4);
                object7 = object5;
            } else if (publicKey.getAlgorithm().equalsIgnoreCase("DSA")) {
                object6 = (DSAPublicKey)publicKey;
                object5 = object6.getParams();
                object4 = new DSAPrivateKey();
                object3 = iaik.pkcs.pkcs11.Util.unsignedBigIntergerToByteArray((BigInteger)object5.getG());
                object2 = iaik.pkcs.pkcs11.Util.unsignedBigIntergerToByteArray((BigInteger)object5.getP());
                object = iaik.pkcs.pkcs11.Util.unsignedBigIntergerToByteArray((BigInteger)object5.getQ());
                object4.getBase().setByteArrayValue(object3);
                object4.getPrime().setByteArrayValue(object2);
                object4.getSubprime().setByteArrayValue(object);
                object7 = object4;
            } else if (publicKey.getAlgorithm().equalsIgnoreCase("DH") || publicKey.getAlgorithm().equalsIgnoreCase("DiffieHellman")) {
                object6 = (DHPublicKey)publicKey;
                object5 = object6.getParams();
                object4 = new DHPrivateKey();
                object3 = iaik.pkcs.pkcs11.Util.unsignedBigIntergerToByteArray((BigInteger)((DHParameterSpec)object5).getG());
                object2 = iaik.pkcs.pkcs11.Util.unsignedBigIntergerToByteArray((BigInteger)((DHParameterSpec)object5).getP());
                object4.getBase().setByteArrayValue(object3);
                object4.getPrime().setByteArrayValue(object2);
                object7 = object4;
            }
            object6 = null;
            if (object7 != null) {
                session.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)object7);
                object5 = session.findObjects(1);
                if (((Object)object5).length > 0) {
                    object4 = (Key)object5[0];
                    object6 = object4.getId().getByteArrayValue();
                    output_.println("found a correponding key on the token: ");
                    output_.println(object4);
                } else {
                    output_.println("found no correponding key on the token.");
                }
                session.findObjectsFinal();
            } else {
                output_.println("public key is neither RSA, DSA nor DH.");
            }
            output_.println("################################################################################");
            output_.println("################################################################################");
            output_.println("Create certificate object(s) on token.");
            object5 = x509Certificate;
            boolean bl = false;
            while (!bl) {
                Object object8;
                Object object9;
                object3 = new X509PublicKeyCertificate();
                object2 = (Name)object5.getSubjectDN();
                object = (Name)object5.getIssuerDN();
                String string = object2.getRDN(ObjectID.commonName);
                String string2 = object.getRDN(ObjectID.commonName);
                char[] cArray = (String.valueOf(string) + "'s " + (string2 != null ? String.valueOf(string2) + " " : "") + "Certificate").toCharArray();
                if (object6 == null) {
                    if (publicKey instanceof RSAPublicKey) {
                        object9 = ((RSAPublicKey)publicKey).getModulus().toByteArray();
                        object8 = MessageDigest.getInstance("SHA-1");
                        object9 = ((MessageDigest)object8).digest((byte[])object9);
                    } else if (publicKey instanceof DSAPublicKey) {
                        object9 = ((DSAPublicKey)publicKey).getY().toByteArray();
                        object8 = MessageDigest.getInstance("SHA-1");
                        object9 = ((MessageDigest)object8).digest((byte[])object9);
                    } else {
                        object9 = object5.getFingerprint("SHA-1");
                    }
                } else {
                    object9 = object6;
                }
                object8 = ((Name)object5.getSubjectDN()).getEncoded();
                byte[] byArray = ((Name)object5.getIssuerDN()).getEncoded();
                byte[] byArray2 = object5.getSerialNumber().toByteArray();
                object3.getToken().setBooleanValue(Boolean.TRUE);
                object3.getPrivate().setBooleanValue(Boolean.FALSE);
                object3.getLabel().setCharArrayValue(cArray);
                object3.getId().setByteArrayValue((byte[])object9);
                object3.getSubject().setByteArrayValue((byte[])object8);
                object3.getIssuer().setByteArrayValue(byArray);
                object3.getSerialNumber().setByteArrayValue(byArray2);
                object3.getValue().setByteArrayValue(object5.getEncoded());
                output_.println(object3);
                output_.println("________________________________________________________________________________");
                session.createObject((iaik.pkcs.pkcs11.objects.Object)object3);
                if (collection.size() > 0) {
                    object5 = (X509Certificate)collection.iterator().next();
                    collection.remove(object5);
                    object6 = null;
                    continue;
                }
                bl = true;
            }
            output_.println("################################################################################");
            session.closeSession();
            module.finalize(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printUsage() {
        output_.println("Usage: ImportCertificate <PKCS#11 module> <DER encoded X.509 certificate, certificate chain, or PKCS#7 certificate chain>");
        output_.println(" e.g.: ImportCertificate pk2priv.dll myCertificate.der");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

