/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import demo.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.KeyPair;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.wrapper.Functions;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Random;

public class GenerateAndSign4096 {
    static BufferedReader input_;
    static PrintWriter output_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            GenerateAndSign4096.printUsage();
            System.exit(1);
        }
        try {
            Module module = Module.getInstance((String)stringArray[0]);
            module.initialize(null);
            Slot[] slotArray = module.getSlotList(true);
            if (slotArray.length == 0) {
                output_.println("No slot with present token found!");
                System.exit(0);
            }
            int n = Integer.parseInt(stringArray[1]);
            Slot slot = slotArray[n];
            Token token = slot.getToken();
            TokenInfo tokenInfo = token.getTokenInfo();
            output_.println("################################################################################");
            output_.println("Information of Token:");
            output_.println(tokenInfo);
            output_.println("################################################################################");
            Session session = Util.openAuthorizedSession(token, true, output_, input_);
            output_.println("################################################################################");
            int n2 = 4096;
            output_.print("Generating new " + n2 + " bit RSA key-pair... ");
            output_.flush();
            Mechanism mechanism = Mechanism.RSA_PKCS_KEY_PAIR_GEN;
            RSAPublicKey rSAPublicKey = new RSAPublicKey();
            RSAPrivateKey rSAPrivateKey = new RSAPrivateKey();
            rSAPublicKey.getModulusBits().setLongValue(new Long(n2));
            byte[] byArray = new byte[3];
            byArray[0] = 1;
            byArray[2] = 1;
            byte[] byArray2 = byArray;
            rSAPublicKey.getPublicExponent().setByteArrayValue(byArray2);
            rSAPublicKey.getToken().setBooleanValue(Boolean.FALSE);
            byte[] byArray3 = new byte[20];
            new Random().nextBytes(byArray3);
            rSAPublicKey.getId().setByteArrayValue(byArray3);
            rSAPrivateKey.getSensitive().setBooleanValue(Boolean.TRUE);
            rSAPrivateKey.getToken().setBooleanValue(Boolean.FALSE);
            rSAPrivateKey.getPrivate().setBooleanValue(Boolean.TRUE);
            rSAPrivateKey.getId().setByteArrayValue(byArray3);
            rSAPrivateKey.getSign().setBooleanValue(Boolean.TRUE);
            rSAPublicKey.getVerify().setBooleanValue(Boolean.TRUE);
            rSAPublicKey.getKeyType().setPresent(false);
            rSAPublicKey.getObjectClass().setPresent(false);
            rSAPrivateKey.getKeyType().setPresent(false);
            rSAPrivateKey.getObjectClass().setPresent(false);
            KeyPair keyPair = session.generateKeyPair(mechanism, (iaik.pkcs.pkcs11.objects.Object)rSAPublicKey, (iaik.pkcs.pkcs11.objects.Object)rSAPrivateKey);
            RSAPublicKey rSAPublicKey2 = (RSAPublicKey)keyPair.getPublicKey();
            RSAPrivateKey rSAPrivateKey2 = (RSAPrivateKey)keyPair.getPrivateKey();
            output_.println("Success");
            output_.println("The public key is");
            output_.println("_______________________________________________________________________________");
            output_.println(rSAPublicKey2);
            output_.println("_______________________________________________________________________________");
            output_.println("The private key is");
            output_.println("_______________________________________________________________________________");
            output_.println(rSAPrivateKey2);
            output_.println("_______________________________________________________________________________");
            output_.println("################################################################################");
            output_.print("Signing Data... ");
            Mechanism mechanism2 = Mechanism.RSA_PKCS;
            session.signInit(mechanism2, (Key)rSAPrivateKey2);
            byte[] byArray4 = "12345678901234567890123456789012345".getBytes("ASCII");
            byte[] byArray5 = session.sign(byArray4);
            output_.println("Finished");
            output_.println("Signature Value: " + Functions.toHexString((byte[])byArray5));
            output_.println("################################################################################");
            session.closeSession();
            module.finalize(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printUsage() {
        output_.println("Usage: GenerateAndSign4096 <PKCS#11 module> <slot index>");
        output_.println(" e.g.: GenerateAndSign4096 cs2_pkcs11.dll 3");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

