/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import demo.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.DefaultInitializeArgs;
import iaik.pkcs.pkcs11.InitializeArgs;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.X509AttributeCertificate;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Hashtable;

public class DumpObjects {
    static PrintWriter output_;
    static BufferedReader input_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length >= 2) {
            String string = stringArray[1];
            File file = new File(string);
            if (file.exists() && !file.isDirectory()) {
                output_.println(String.valueOf(string) + " is not a directory!");
                System.exit(1);
            }
            try {
                Object object;
                Object object2;
                Object object3;
                DefaultInitializeArgs defaultInitializeArgs;
                if (!file.exists()) {
                    file.mkdirs();
                }
                String string2 = stringArray[0];
                output_.println("################################################################################");
                output_.println("load and initialize module: " + string2);
                output_.flush();
                Module module = Module.getInstance((String)string2);
                if (stringArray.length == 2) {
                    module.initialize(null);
                } else {
                    defaultInitializeArgs = new DefaultInitializeArgs();
                    object3 = stringArray[2].getBytes();
                    object2 = new byte[((byte[])object3).length + 5];
                    System.arraycopy(object3, 0, object2, 0, ((byte[])object3).length);
                    defaultInitializeArgs.setReserved(object2);
                    module.initialize((InitializeArgs)defaultInitializeArgs);
                }
                defaultInitializeArgs = module.getInfo();
                output_.println(defaultInitializeArgs);
                output_.println("################################################################################");
                object3 = Util.selectToken(module, output_, input_);
                if (object3 == null) {
                    output_.println("We have no token to proceed. Finished.");
                    output_.flush();
                    System.exit(0);
                }
                output_.println("################################################################################");
                output_.println("dumping objects for token: ");
                object2 = object3.getTokenInfo();
                output_.println(object2);
                Session session = object3.openSession(true, false, null, null);
                if (object2.isLoginRequired()) {
                    if (object2.isProtectedAuthenticationPath()) {
                        session.login(true, null);
                    } else {
                        output_.print("Enter user-PIN or press [return] to list just public objects: ");
                        output_.flush();
                        object = input_.readLine();
                        output_.println();
                        output_.print("listing all" + (((String)object).length() > 0 ? "" : " public") + " objects on token");
                        if (((String)object).length() > 0) {
                            session.login(true, ((String)object).toCharArray());
                        }
                    }
                }
                object = session.getSessionInfo();
                output_.println(" using session:");
                output_.println(object);
                String string3 = System.getProperty("file.separator");
                session.findObjectsInit(null);
                iaik.pkcs.pkcs11.objects.Object[] objectArray = session.findObjects(1);
                while (objectArray.length > 0 && objectArray[0] != null) {
                    ByteArrayAttribute byteArrayAttribute;
                    byte[] byArray;
                    iaik.pkcs.pkcs11.objects.Object object4 = objectArray[0];
                    output_.println("--------------------------------------------------------------------------------");
                    long l = object4.getObjectHandle();
                    output_.println("Dumping object with handle " + l);
                    String string4 = String.valueOf(string) + string3 + l + ".txt";
                    output_.println("Dumping text output to file " + string4);
                    FileOutputStream fileOutputStream = new FileOutputStream(string4);
                    fileOutputStream.write(object4.toString().getBytes("UTF-8"));
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    Hashtable hashtable = object4.getAttributeTable();
                    if (hashtable.containsKey(Attribute.VALUE) && (byArray = (byteArrayAttribute = (ByteArrayAttribute)hashtable.get(Attribute.VALUE)).getByteArrayValue()) != null) {
                        String string5 = String.valueOf(string) + string3 + l + ".value.bin";
                        output_.println("Dumping value attribut to file " + string5);
                        FileOutputStream fileOutputStream2 = new FileOutputStream(string5);
                        fileOutputStream2.write(byArray);
                        fileOutputStream2.flush();
                        fileOutputStream2.close();
                        if (object4 instanceof X509PublicKeyCertificate || object4 instanceof X509AttributeCertificate) {
                            String string6 = String.valueOf(string) + string3 + l + ".der.cer";
                            output_.println("Dumping DER encoding of certificate to file " + string6);
                            FileOutputStream fileOutputStream3 = new FileOutputStream(string6);
                            fileOutputStream3.write(byArray);
                            fileOutputStream3.flush();
                            fileOutputStream3.close();
                        }
                    }
                    output_.println("--------------------------------------------------------------------------------");
                    objectArray = session.findObjects(1);
                }
                session.findObjectsFinal();
                session.closeSession();
                output_.println("################################################################################");
                module.finalize(null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else {
            DumpObjects.printUsage();
        }
        System.gc();
    }

    protected static void printUsage() {
        output_.println("DumpObjects <PKCS#11 module name> <output directory> [<initialization parameters>]");
        output_.println("e.g.: DumpObjects slbck.dll dumpdir");
    }
}

