/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import demo.pkcs.pkcs11.Util;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.Name;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.security.provider.IAIK;
import iaik.x509.X509Certificate;
import iaik.x509.extensions.KeyUsage;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.HashSet;

public class DownloadPrivateKey {
    static BufferedReader input_;
    static PrintWriter output_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            DownloadPrivateKey.printUsage();
            System.exit(1);
        }
        try {
            Security.addProvider((Provider)new IAIK());
            Module module = Module.getInstance((String)stringArray[0]);
            module.initialize(null);
            Token token = Util.selectToken(module, output_, input_);
            if (token == null) {
                output_.println("We have no token to proceed. Finished.");
                output_.flush();
                System.exit(0);
            }
            TokenInfo tokenInfo = token.getTokenInfo();
            output_.println("################################################################################");
            output_.println("Information of Token:");
            output_.println(tokenInfo);
            output_.println("################################################################################");
            output_.println("################################################################################");
            output_.println("Reading private key and certifiacte from: " + stringArray[1]);
            FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
            PKCS12 pKCS12 = new PKCS12((InputStream)fileInputStream);
            char[] cArray = stringArray[2].toCharArray();
            pKCS12.decrypt(cArray);
            KeyBag keyBag = pKCS12.getKeyBag();
            PrivateKey privateKey = keyBag.getPrivateKey();
            if (!privateKey.getAlgorithm().equals("RSA")) {
                output_.println("Private Key in the PKCS#12 file is not a RSA key.");
                System.exit(1);
            }
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)privateKey;
            output_.println("got private key");
            CertificateBag[] certificateBagArray = pKCS12.getCertificateBags();
            X509Certificate[] x509CertificateArray = CertificateBag.getCertificates((CertificateBag[])certificateBagArray);
            x509CertificateArray = iaik.utils.Util.arrangeCertificateChain((X509Certificate[])x509CertificateArray, (boolean)false);
            X509Certificate x509Certificate = x509CertificateArray[0];
            String string = ((Name)x509Certificate.getSubjectDN()).getRDN(ObjectID.commonName).toString();
            byte[] byArray = x509Certificate.getFingerprint("SHA-1");
            KeyUsage keyUsage = (KeyUsage)x509Certificate.getExtension(KeyUsage.oid);
            SubjectKeyIdentifier subjectKeyIdentifier = (SubjectKeyIdentifier)x509Certificate.getExtension(SubjectKeyIdentifier.oid);
            output_.println("got user certifiate");
            output_.println("################################################################################");
            Session session = Util.openAuthorizedSession(token, true, output_, input_);
            output_.println("################################################################################");
            output_.println("creating private key object on the card... ");
            output_.flush();
            HashSet<Mechanism> hashSet = new HashSet<Mechanism>(Arrays.asList(token.getMechanismList()));
            Object object = hashSet.contains(Mechanism.RSA_PKCS) ? token.getMechanismInfo(Mechanism.RSA_PKCS) : (hashSet.contains(Mechanism.RSA_X_509) ? token.getMechanismInfo(Mechanism.RSA_X_509) : (hashSet.contains(Mechanism.RSA_9796) ? token.getMechanismInfo(Mechanism.RSA_9796) : (hashSet.contains(Mechanism.RSA_PKCS_OAEP) ? token.getMechanismInfo(Mechanism.RSA_PKCS_OAEP) : null)));
            iaik.pkcs.pkcs11.objects.RSAPrivateKey rSAPrivateKey2 = new iaik.pkcs.pkcs11.objects.RSAPrivateKey();
            rSAPrivateKey2.getSensitive().setBooleanValue(Boolean.TRUE);
            rSAPrivateKey2.getToken().setBooleanValue(Boolean.TRUE);
            rSAPrivateKey2.getPrivate().setBooleanValue(Boolean.TRUE);
            String string2 = String.valueOf(string) + "'s " + ((Name)x509Certificate.getIssuerDN()).getRDN(ObjectID.organization);
            rSAPrivateKey2.getLabel().setCharArrayValue(string2.toCharArray());
            byte[] byArray2 = subjectKeyIdentifier != null ? subjectKeyIdentifier.get() : byArray;
            rSAPrivateKey2.getId().setByteArrayValue(byArray2);
            rSAPrivateKey2.getSubject().setByteArrayValue(((Name)x509Certificate.getSubjectDN()).getEncoded());
            if (keyUsage != null) {
                int n = keyUsage.get();
                if (object != null) {
                    rSAPrivateKey2.getDecrypt().setBooleanValue(new Boolean(((n & 8) != 0 || (n & 0x20) != 0) && object.isDecrypt()));
                    rSAPrivateKey2.getSign().setBooleanValue(new Boolean(((n & 1) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0 || (n & 2) != 0) && object.isSign()));
                    rSAPrivateKey2.getSignRecover().setBooleanValue(new Boolean(((n & 1) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0 || (n & 2) != 0) && object.isSignRecover()));
                    rSAPrivateKey2.getDerive().setBooleanValue(new Boolean((n & 0x10) != 0 && object.isDerive()));
                    rSAPrivateKey2.getUnwrap().setBooleanValue(new Boolean((n & 4) != 0 && object.isUnwrap()));
                } else {
                    rSAPrivateKey2.getDecrypt().setBooleanValue(new Boolean((n & 8) != 0 || (n & 0x20) != 0));
                    rSAPrivateKey2.getSign().setBooleanValue(new Boolean((n & 1) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0 || (n & 2) != 0));
                    rSAPrivateKey2.getSignRecover().setBooleanValue(new Boolean((n & 1) != 0 || (n & 0x20) != 0 || (n & 0x40) != 0 || (n & 2) != 0));
                    rSAPrivateKey2.getDerive().setBooleanValue(new Boolean((n & 0x10) != 0));
                    rSAPrivateKey2.getUnwrap().setBooleanValue(new Boolean((n & 4) != 0));
                }
            } else if (object != null) {
                rSAPrivateKey2.getSign().setBooleanValue(new Boolean(object.isSign()));
                rSAPrivateKey2.getSignRecover().setBooleanValue(new Boolean(object.isSignRecover()));
                rSAPrivateKey2.getDecrypt().setBooleanValue(new Boolean(object.isDecrypt()));
                rSAPrivateKey2.getDerive().setBooleanValue(new Boolean(object.isDerive()));
                rSAPrivateKey2.getUnwrap().setBooleanValue(new Boolean(object.isUnwrap()));
            } else {
                rSAPrivateKey2.getSign().setBooleanValue(Boolean.TRUE);
                rSAPrivateKey2.getSignRecover().setBooleanValue(Boolean.TRUE);
                rSAPrivateKey2.getDecrypt().setBooleanValue(Boolean.TRUE);
                rSAPrivateKey2.getDerive().setBooleanValue(Boolean.TRUE);
                rSAPrivateKey2.getUnwrap().setBooleanValue(Boolean.TRUE);
            }
            rSAPrivateKey2.getModulus().setByteArrayValue(iaik.pkcs.pkcs11.Util.unsignedBigIntergerToByteArray((BigInteger)rSAPrivateKey.getModulus()));
            rSAPrivateKey2.getPrivateExponent().setByteArrayValue(iaik.pkcs.pkcs11.Util.unsignedBigIntergerToByteArray((BigInteger)rSAPrivateKey.getPrivateExponent()));
            rSAPrivateKey2.getPublicExponent().setByteArrayValue(iaik.pkcs.pkcs11.Util.unsignedBigIntergerToByteArray((BigInteger)((RSAPublicKey)x509Certificate.getPublicKey()).getPublicExponent()));
            if (rSAPrivateKey instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)rSAPrivateKey;
                rSAPrivateKey2.getPrime1().setByteArrayValue(iaik.pkcs.pkcs11.Util.unsignedBigIntergerToByteArray((BigInteger)rSAPrivateCrtKey.getPrimeP()));
                rSAPrivateKey2.getPrime2().setByteArrayValue(iaik.pkcs.pkcs11.Util.unsignedBigIntergerToByteArray((BigInteger)rSAPrivateCrtKey.getPrimeQ()));
                rSAPrivateKey2.getExponent1().setByteArrayValue(iaik.pkcs.pkcs11.Util.unsignedBigIntergerToByteArray((BigInteger)rSAPrivateCrtKey.getPrimeExponentP()));
                rSAPrivateKey2.getExponent2().setByteArrayValue(iaik.pkcs.pkcs11.Util.unsignedBigIntergerToByteArray((BigInteger)rSAPrivateCrtKey.getPrimeExponentQ()));
                rSAPrivateKey2.getCoefficient().setByteArrayValue(iaik.pkcs.pkcs11.Util.unsignedBigIntergerToByteArray((BigInteger)rSAPrivateCrtKey.getCrtCoefficient()));
            }
            output_.println(rSAPrivateKey2);
            session.createObject((iaik.pkcs.pkcs11.objects.Object)rSAPrivateKey2);
            output_.println("################################################################################");
            output_.println("################################################################################");
            output_.println("creating certificate object on the card... ");
            output_.flush();
            X509PublicKeyCertificate x509PublicKeyCertificate = new X509PublicKeyCertificate();
            x509PublicKeyCertificate.getToken().setBooleanValue(Boolean.TRUE);
            x509PublicKeyCertificate.getPrivate().setBooleanValue(Boolean.FALSE);
            x509PublicKeyCertificate.getLabel().setCharArrayValue(string2.toCharArray());
            x509PublicKeyCertificate.getSubject().setByteArrayValue(((Name)x509Certificate.getSubjectDN()).getEncoded());
            x509PublicKeyCertificate.getId().setByteArrayValue(byArray2);
            x509PublicKeyCertificate.getIssuer().setByteArrayValue(((Name)x509Certificate.getIssuerDN()).getEncoded());
            x509PublicKeyCertificate.getSerialNumber().setByteArrayValue(x509Certificate.getSerialNumber().toByteArray());
            x509PublicKeyCertificate.getValue().setByteArrayValue(x509Certificate.getEncoded());
            output_.println(x509PublicKeyCertificate);
            session.createObject((iaik.pkcs.pkcs11.objects.Object)x509PublicKeyCertificate);
            output_.println("################################################################################");
            session.closeSession();
            module.finalize(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printUsage() {
        output_.println("Usage: DownloadPrivateKey <PKCS#11 module> <PKCS#12 encoded private key and certificate> <PKCS#12 password>");
        output_.println(" e.g.: DownloadPrivateKey pk2priv.dll privatekeyAndCert.p12 filepassword");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

