/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import iaik.pkcs.pkcs7.EncryptedContentInfoStream;
import iaik.pkcs.pkcs7.EnvelopedDataStream;
import iaik.pkcs.pkcs7.RecipientInfo;
import iaik.security.provider.IAIK;
import iaik.x509.X509Certificate;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;

public class DecryptPKCS7 {
    static PrintStream output_;
    static BufferedReader input_;

    static {
        try {
            output_ = new PrintStream(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintStream(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2 && stringArray.length != 3) {
            DecryptPKCS7.printUsage();
            System.exit(1);
        }
        try {
            int n;
            Object object;
            Object object2;
            iaik.pkcs.pkcs11.objects.Object[] objectArray;
            Object object3;
            String string;
            TokenInfo tokenInfo;
            Security.addProvider((Provider)new IAIK());
            Module module = Module.getInstance((String)stringArray[0]);
            module.initialize(null);
            output_.println("################################################################################");
            output_.println("getting list of all tokens");
            Slot[] slotArray = module.getSlotList(true);
            Token[] tokenArray = new Token[slotArray.length];
            HashMap<Long, Token> hashMap = new HashMap<Long, Token>(tokenArray.length);
            int n2 = 0;
            while (n2 < slotArray.length) {
                output_.println("________________________________________________________________________________");
                tokenArray[n2] = slotArray[n2].getToken();
                tokenInfo = tokenArray[n2].getTokenInfo();
                long l = tokenArray[n2].getTokenID();
                hashMap.put(new Long(l), tokenArray[n2]);
                output_.println("Token ID: " + l);
                output_.println(tokenInfo);
                output_.println("________________________________________________________________________________");
                ++n2;
            }
            output_.println("################################################################################");
            output_.println("################################################################################");
            tokenInfo = null;
            Long l = null;
            if (tokenArray.length == 0) {
                output_.println("There is no slot with a present token.");
                output_.flush();
                System.exit(0);
            } else if (tokenArray.length == 1) {
                output_.println("Taking token with ID: " + tokenArray[0].getTokenID());
                l = new Long(tokenArray[0].getTokenID());
                tokenInfo = tokenArray[0];
            } else {
                boolean bl = false;
                while (!bl) {
                    output_.print("Enter the ID of the token to use or 'x' to exit: ");
                    output_.flush();
                    string = input_.readLine();
                    if (string.equalsIgnoreCase("x")) {
                        output_.flush();
                        System.exit(0);
                    }
                    try {
                        l = new Long(string);
                        tokenInfo = (Token)hashMap.get(l);
                        if (tokenInfo != null) {
                            bl = true;
                            continue;
                        }
                        output_.println("A token with the entered ID \"" + string + "\" does not exist. Try again.");
                    }
                    catch (NumberFormatException numberFormatException) {
                        output_.println("The entered ID \"" + string + "\" is invalid. Try again.");
                    }
                }
            }
            List<Mechanism> list = Arrays.asList(tokenInfo.getMechanismList());
            if (!list.contains(Mechanism.RSA_PKCS)) {
                output_.print("This token does not support RSA!");
                output_.flush();
                System.exit(0);
            } else {
                string = tokenInfo.getMechanismInfo(Mechanism.RSA_PKCS);
                if (!string.isDecrypt()) {
                    output_.print("This token does not support RSA decryption according to PKCS!");
                    output_.flush();
                    System.exit(0);
                }
            }
            string = tokenInfo.openSession(true, false, null, null);
            TokenInfo tokenInfo2 = tokenInfo.getTokenInfo();
            if (tokenInfo2.isLoginRequired()) {
                if (tokenInfo2.isProtectedAuthenticationPath()) {
                    output_.println("Please enter the user PIN at the PIN-pad of your reader.");
                    string.login(true, null);
                } else {
                    output_.print("Enter user-PIN and press [return key]: ");
                    output_.flush();
                    object3 = input_.readLine();
                    string.login(true, ((String)object3).toCharArray());
                }
            }
            object3 = new Vector();
            X509PublicKeyCertificate x509PublicKeyCertificate = new X509PublicKeyCertificate();
            string.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)x509PublicKeyCertificate);
            while ((objectArray = string.findObjects(1)).length > 0) {
                object3.add(objectArray[0]);
            }
            string.findObjectsFinal();
            output_.println("################################################################################");
            output_.println("################################################################################");
            output_.println("reading encrypted data from file: " + stringArray[1]);
            FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
            EnvelopedDataStream envelopedDataStream = new EnvelopedDataStream((InputStream)fileInputStream);
            RecipientInfo[] recipientInfoArray = envelopedDataStream.getRecipientInfos();
            boolean bl = false;
            InputStream inputStream = null;
            int n3 = 0;
            while (n3 < recipientInfoArray.length) {
                iaik.pkcs.pkcs11.objects.Object[] objectArray2;
                X509PublicKeyCertificate x509PublicKeyCertificate2;
                object2 = recipientInfoArray[n3].getIssuerAndSerialNumber();
                object = null;
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    x509PublicKeyCertificate2 = (X509PublicKeyCertificate)iterator.next();
                    objectArray2 = new X509Certificate(x509PublicKeyCertificate2.getValue().getByteArrayValue());
                    if (!object2.isIssuerOf((java.security.cert.X509Certificate)objectArray2)) continue;
                    output_.println("________________________________________________________________________________");
                    output_.println("Found matching certificate on the token:");
                    output_.println(objectArray2.toString(true));
                    output_.println("________________________________________________________________________________");
                    object = x509PublicKeyCertificate2;
                    break;
                }
                if (object != null) {
                    PrivateKey privateKey;
                    x509PublicKeyCertificate2 = new PrivateKey();
                    x509PublicKeyCertificate2.getId().setByteArrayValue(object.getId().getByteArrayValue());
                    string.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)x509PublicKeyCertificate2);
                    PrivateKey privateKey2 = null;
                    objectArray2 = string.findObjects(1);
                    if (objectArray2.length > 0) {
                        privateKey2 = (PrivateKey)objectArray2[0];
                        output_.println("________________________________________________________________________________");
                        output_.println("Found corresponding private key:");
                        output_.println(privateKey2);
                        output_.println("________________________________________________________________________________");
                    } else {
                        output_.println("Found no private key with the same ID as the matching certificate.");
                    }
                    string.findObjectsFinal();
                    PrivateKey privateKey3 = privateKey = privateKey2 != null && privateKey2.getDecrypt().getBooleanValue() != false ? privateKey2 : null;
                    if (privateKey != null) {
                        bl = true;
                        output_.print("decrypting symmetric key... ");
                        byte[] byArray = recipientInfoArray[n3].getEncryptedKey();
                        string.decryptInit(Mechanism.RSA_PKCS, (iaik.pkcs.pkcs11.objects.Key)privateKey);
                        byte[] byArray2 = string.decrypt(byArray);
                        output_.println("finished");
                        output_.print("constructing symmetric key for software decryption... ");
                        EncryptedContentInfoStream encryptedContentInfoStream = (EncryptedContentInfoStream)envelopedDataStream.getEncryptedContentInfo();
                        AlgorithmID algorithmID = encryptedContentInfoStream.getContentEncryptionAlgorithm();
                        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, algorithmID.getRawImplementationName());
                        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(algorithmID.getRawImplementationName());
                        SecretKey secretKey = secretKeyFactory.generateSecret(secretKeySpec);
                        output_.println("finished");
                        encryptedContentInfoStream.setupCipher((Key)secretKey);
                        inputStream = encryptedContentInfoStream.getInputStream();
                    }
                }
                ++n3;
            }
            if (!bl) {
                output_.print("Found no decryption key that matches any recipient info in the encrypted PKCS#7 object.");
                output_.flush();
                System.exit(0);
            }
            if (inputStream == null) {
                output_.print("Could not decrypt the PKCS#7 object.");
                output_.flush();
                System.exit(0);
            }
            output_.println("################################################################################");
            output_.println("################################################################################");
            object2 = stringArray.length == 3 ? new FileOutputStream(stringArray[2]) : null;
            object = new byte[1024];
            output_.println("The decrypted content data is: ");
            output_.println("________________________________________________________________________________");
            while ((n = inputStream.read((byte[])object)) > 0) {
                output_.write((byte[])object, 0, n);
                if (object2 == null) continue;
                ((OutputStream)object2).write((byte[])object, 0, n);
            }
            output_.println();
            output_.println("________________________________________________________________________________");
            if (object2 != null) {
                output_.println("Decrypted content written to: " + stringArray[2]);
                ((OutputStream)object2).flush();
                ((OutputStream)object2).close();
            }
            output_.println("################################################################################");
            string.closeSession();
            module.finalize(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printUsage() {
        output_.println("Usage: DecryptPKCS7 <PKCS#11 module> <PKCS#7 encrypted data file> [<decrypted content data>]");
        output_.println(" e.g.: DecryptPKCS7 slbck.dll encryptedData.p7 decryptedContent.dat");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

