/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.util;

import java.io.File;
import java.text.MessageFormat;
import javax.swing.filechooser.FileFilter;

public final class ExtensionFileFilter
extends FileFilter {
    private String ext = "";
    private String desc = "";

    public ExtensionFileFilter(String ext, String description) {
        if (ext == null) {
            throw new NullPointerException("File Extensions Cannont Be null");
        }
        if (description == null) {
            throw new NullPointerException("File Description Cannont Be null");
        }
        this.ext = new String(ext);
        this.desc = MessageFormat.format("{0} (*.{1})", description, ext);
    }

    public File applyExtension(File original) {
        return new File(original.getParentFile(), original.getName().concat(".".concat(this.ext)));
    }

    public boolean accept(File f) {
        if (f.canRead() || f.canWrite()) {
            return f.getName().endsWith("." + this.ext) || f.isDirectory() || f.isDirectory() && f.isHidden() && f.getName().startsWith(".");
        }
        return false;
    }

    public String getDescription() {
        return this.desc;
    }
}

