/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui.prefs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.isqlviewer.core.ConfigConstants;
import org.isqlviewer.ui.AbstractPropertyPage;
import org.isqlviewer.util.BasicUtilities;

public final class EditorPropertyPage
extends AbstractPropertyPage
implements ItemListener,
ListSelectionListener,
PropertyChangeListener {
    private boolean isSelecting = false;
    private JLabel lblFontLabel = new JLabel("");
    private JButton btnFntChange = new JButton();
    private JButton btnColor = new JButton(new AbstractPropertyPage.ColorChangeAction(this));
    private JButton btnBgcolor = new JButton();
    private String[] colorIDs = new String[]{BasicUtilities.getString("Editor_Syntax_Keywords"), BasicUtilities.getString("Editor_Syntax_Tablespace"), BasicUtilities.getString("Editor_Syntax_Objects"), BasicUtilities.getString("Editor_Syntax_Functions"), BasicUtilities.getString("Editor_Syntax_Strings"), BasicUtilities.getString("Editor_Syntax_Parameters"), BasicUtilities.getString("Editor_Syntax_Comment"), BasicUtilities.getString("Editor_Syntax_Mutli_Comment"), BasicUtilities.getString("Editor_Syntax_Other")};
    private Hashtable mapColors = new Hashtable();
    private Hashtable mapItalic = new Hashtable();
    private Hashtable mapBolded = new Hashtable();
    private Hashtable mapPrefs = new Hashtable();
    private JCheckBox chkBold = new JCheckBox(BasicUtilities.getString("Editor_Syntax_Bold"));
    private JCheckBox chkItal = new JCheckBox(BasicUtilities.getString("Editor_Syntax_Italic"));
    private JCheckBox chkCaret = new JCheckBox(BasicUtilities.getString("Editor_Enable_Caret_Offset_Txt"));
    private JCheckBox chkHighlight = new JCheckBox(BasicUtilities.getString("Editor_Syntax_Enable_Txt"));
    private JCheckBox chkCntxtHelp = new JCheckBox(BasicUtilities.getString("Editor_Help_Enable_Txt"));
    private JList jlsSyntaxes = new JList<String>(this.colorIDs);

    public EditorPropertyPage() {
        this.mapPrefs.put(this.colorIDs[0], "editor.sql-keywords");
        this.mapPrefs.put(this.colorIDs[1], "editor.tablespace");
        this.mapPrefs.put(this.colorIDs[2], "editor.local-obj");
        this.mapPrefs.put(this.colorIDs[3], "editor.functions");
        this.mapPrefs.put(this.colorIDs[4], "editor.literals");
        this.mapPrefs.put(this.colorIDs[5], "editor.parameters");
        this.mapPrefs.put(this.colorIDs[1], "editor.sline-comments");
        this.mapPrefs.put(this.colorIDs[2], "editor.multicomment-color");
        this.mapPrefs.put(this.colorIDs[6], "editor.default-color");
        try {
            this.initUI();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "initUI()");
        }
    }

    public String getPropertyPageName() {
        return BasicUtilities.getString("Editor_Property_Page");
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Edit16");
    }

    public synchronized void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.isSelecting = true;
        String id = (String)this.jlsSyntaxes.getSelectedValue();
        String preference = (String)this.mapPrefs.get(id);
        if (preference == null) {
            return;
        }
        Color color = null;
        boolean bold = false;
        boolean ital = false;
        String key = preference;
        if (this.mapColors.containsKey(preference)) {
            color = (Color)this.mapColors.get(preference);
        } else {
            key = ConfigConstants.createStyleKey(preference, "color");
            color = prefs.getColor(key);
        }
        if (this.mapBolded.containsKey(preference)) {
            bold = (Boolean)this.mapBolded.get(preference);
        } else {
            key = ConfigConstants.createStyleKey(preference, "bolded");
            bold = prefs.getBoolean(key);
        }
        if (this.mapItalic.containsKey(preference)) {
            ital = (Boolean)this.mapItalic.get(preference);
        } else {
            key = ConfigConstants.createStyleKey(preference, "italics");
            ital = prefs.getBoolean(key);
        }
        this.chkItal.setSelected(ital);
        this.chkBold.setSelected(bold);
        this.btnColor.setForeground(color);
        this.isSelecting = false;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.isSelecting) {
            String id = (String)this.jlsSyntaxes.getSelectedValue();
            String prop = (String)this.mapPrefs.get(id);
            Color color = this.btnColor.getForeground();
            this.setModified(true);
            this.mapColors.put(prop, color);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (!this.isSelecting) {
            String id = (String)this.jlsSyntaxes.getSelectedValue();
            String prop = (String)this.mapPrefs.get(id);
            this.mapItalic.put(prop, this.chkItal.isSelected());
            this.mapBolded.put(prop, this.chkBold.isSelected());
            this.setModified(true);
        }
    }

    public void saveProperties() {
        Boolean bool;
        String property;
        Iterator keys = this.mapColors.keySet().iterator();
        while (keys.hasNext()) {
            property = (String)keys.next();
            Color color = (Color)this.mapColors.get(property = ConfigConstants.createStyleKey(property, "color"));
            if (color == null) continue;
            prefs.putColor(property, color);
        }
        keys = this.mapBolded.keySet().iterator();
        while (keys.hasNext()) {
            property = (String)keys.next();
            bool = (Boolean)this.mapBolded.get(property = ConfigConstants.createStyleKey(property, "bolded"));
            if (bool == null) continue;
            prefs.putBoolean(property, bool);
        }
        keys = this.mapItalic.keySet().iterator();
        while (keys.hasNext()) {
            property = (String)keys.next();
            bool = (Boolean)this.mapItalic.get(property = ConfigConstants.createStyleKey(property, "italics"));
            if (bool == null) continue;
            prefs.putBoolean(property, bool);
        }
        super.saveProperties();
    }

    protected void initUI() {
        this.setLayout(new GridBagLayout());
        this.chkCaret.setToolTipText(BasicUtilities.getString("Editor_Enable_Caret_Offset_Tip"));
        this.chkHighlight.setToolTipText(BasicUtilities.getString("Editor_Syntax_Enable_Tip"));
        this.chkCntxtHelp.setToolTipText(BasicUtilities.getString("Editor_Help_Enable_Tip"));
        this.jlsSyntaxes.addListSelectionListener(this);
        this.chkBold.addItemListener(this);
        this.chkItal.addItemListener(this);
        this.jlsSyntaxes.setSelectedIndex(0);
        this.lblFontLabel.setLabelFor(this.btnFntChange);
        this.lblFontLabel.setName("Editor_Font");
        this.btnFntChange.setFont(prefs.getFont("editor.font"));
        this.btnFntChange.setAction(new AbstractPropertyPage.FontChangeAction(this, this.btnFntChange.getFont(), this.lblFontLabel));
        this.btnColor.addPropertyChangeListener("foreground", this);
        this.setPropertyForComponent(this.chkCaret, "editor.caretoffset-enabled");
        this.setFontPropertyForComponent(this.btnFntChange, "editor.font");
        this.setColorPropertyForComponent(this.btnBgcolor, "editor.background-color");
        this.setPropertyForComponent(this.chkCntxtHelp, "editor.context-help.enabled");
        this.setPropertyForComponent(this.chkHighlight, "editor.syntax-help.enabled");
        EditorPropertyPage.constrain(0, 0, 1, 9, 0.0, 0.0, 10, 0);
        this.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
        EditorPropertyPage.constrain(1, 0, 2, 1, 0.0, 0.0, 17, 0);
        this.add(Box.createVerticalStrut(6), UI_CONSTRAINT);
        EditorPropertyPage.constrain(1, 1, 2, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.lblFontLabel, UI_CONSTRAINT);
        EditorPropertyPage.constrain(3, 1, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.btnFntChange, UI_CONSTRAINT);
        EditorPropertyPage.constrain(1, 2, 2, 1, 0.0, 0.0, 17, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("Editor_Background_Color", null), UI_CONSTRAINT);
        EditorPropertyPage.constrain(3, 2, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.btnBgcolor, UI_CONSTRAINT);
        EditorPropertyPage.constrain(1, 3, 3, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkCaret, UI_CONSTRAINT);
        EditorPropertyPage.constrain(1, 4, 3, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkCntxtHelp, UI_CONSTRAINT);
        EditorPropertyPage.constrain(1, 5, 3, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkHighlight, UI_CONSTRAINT);
        EditorPropertyPage.constrain(1, 6, 2, 1, 0.0, 0.0, 10, 2);
        this.add(EditorPropertyPage.createHorizSeperator(), UI_CONSTRAINT);
        EditorPropertyPage.constrain(1, 6, 2, 1, 0.0, 0.0, 10, 2);
        this.add(Box.createVerticalStrut(16), UI_CONSTRAINT);
        EditorPropertyPage.constrain(1, 7, 3, 1, 0.0, 0.0, 17, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("Editor_Syntax_Options", null), UI_CONSTRAINT);
        JScrollPane jspSyntaxes = new JScrollPane(this.jlsSyntaxes);
        Dimension d = this.jlsSyntaxes.getPreferredSize();
        jspSyntaxes.setPreferredSize(new Dimension(d.width + 24, this.jlsSyntaxes.getCellBounds((int)0, (int)4).height));
        EditorPropertyPage.constrain(1, 8, 2, 4, 0.0, 0.0, 10, 0);
        this.add((Component)jspSyntaxes, UI_CONSTRAINT);
        EditorPropertyPage.constrain(3, 8, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)BasicUtilities.createLocalizedLabel("Color_Label", null), UI_CONSTRAINT);
        EditorPropertyPage.constrain(3, 9, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.btnColor, UI_CONSTRAINT);
        EditorPropertyPage.constrain(3, 10, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkBold, UI_CONSTRAINT);
        EditorPropertyPage.constrain(3, 11, 1, 1, 0.0, 0.0, 17, 0);
        this.add((Component)this.chkItal, UI_CONSTRAINT);
        EditorPropertyPage.constrain(1, 13, 3, 1, 0.0, 1.0, 17, 0);
        this.add(Box.createVerticalGlue(), UI_CONSTRAINT);
        EditorPropertyPage.constrain(4, 0, 1, 12, 1.0, 0.0, 10, 0);
        this.add(Box.createHorizontalGlue(), UI_CONSTRAINT);
    }
}

