/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.isqlviewer.core.CorePlugin;
import org.isqlviewer.core.EnhancedDataRenderer;
import org.isqlviewer.core.HistoryItem;
import org.isqlviewer.core.HistoryManager;
import org.isqlviewer.core.IPCListener;
import org.isqlviewer.core.PluginFactory;
import org.isqlviewer.core.SQLBookmark;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.action.ActionPopupMenu;
import org.isqlviewer.core.model.BookmarkTreeModel;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.core.model.ResultSetTableModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.sql.ResultSetViewer;
import org.isqlviewer.swing.ActionManager;
import org.isqlviewer.swing.ActionToolBar;
import org.isqlviewer.swing.ITabbedPane;
import org.isqlviewer.swing.ITable;
import org.isqlviewer.swing.JCheckBoxAction;
import org.isqlviewer.swing.SortableHeaderRenderer;
import org.isqlviewer.swing.print.PrinterPreview;
import org.isqlviewer.ui.AppController;
import org.isqlviewer.ui.ExportWizard;
import org.isqlviewer.ui.MutableContentViewer;
import org.isqlviewer.ui.SQLEditor;
import org.isqlviewer.ui.SQLWarningViewer;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringUtilities;
import org.isqlviewer.util.UserPreferences;

public final class SQLWorkBench
extends JComponent
implements SwingConstants,
IPCListener {
    private static final String CLIENT_RAW_SQL = "raw-sql";
    private static final GridBagConstraints UI_CONSTRAINT = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 0, 0, new Insets(1, 1, 1, 1), 0, 0);
    private SystemConfig sysConfig = SystemConfig.getInstance();
    private UserPreferences preferences = this.sysConfig.getPreferences();
    private SQLEditor txtSQLEditor = null;
    private ActionPopupMenu tablePopupMenu = new ActionPopupMenu();
    private ResultsetToolbar jtbResultset = null;
    private HistoryToolbar jtbHistory = null;
    private AppController controller = null;
    private ITabbedPane resultPane = new ITabbedPane(1);
    private JSplitPane contentPane = new JSplitPane(0);
    private JPanel resultsPanel = new JPanel(new BorderLayout());
    private BookmarkDnDSupport bookmarkDropper = new BookmarkDnDSupport(this);
    private InputSupport actionHandler = new InputSupport();
    static /* synthetic */ Class class$javax$swing$JFrame;

    public SQLWorkBench(AppController cntrlr) {
        try {
            this.controller = cntrlr;
            this.initUI();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, BasicUtilities.getString("Fatal_Error_Occured"), true);
            System.exit(-1);
        }
    }

    public void executeBookmark(SQLBookmark bmark, AppController ctrlr, boolean refresh) {
        if (bmark != null && this.controller.validateConnection()) {
            SQLBookmark copy = (SQLBookmark)bmark.clone();
            String sql = this.processSQLParameters(copy.getSQL());
            if (sql == null) {
                return;
            }
            copy.setSQL(sql);
            DatabaseConnection connection = ctrlr.getJDBCConnection();
            if (bmark.hasParameters()) {
                try {
                    PreparedStatement ps = copy.toPreparedStatement(connection);
                    ResultSetViewer delegate = this.createResultSetDelegate();
                    bmark.updateLastAcessTime();
                    bmark.updateUseCount();
                    connection.executeStatement(ps, copy.getSQL(), delegate);
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t);
                }
            } else {
                bmark.updateLastAcessTime();
                bmark.updateUseCount();
                this.performQuery(refresh, copy.getSQL(), true);
            }
            copy = null;
        } else {
            BasicUtilities.beep();
        }
    }

    public void receiveMessage(Object src, String topic, Object msg) {
        String sqlCommand = msg.toString().trim();
        if (sqlCommand.length() >= 1 && this.controller.validateConnection()) {
            this.performQuery(sqlCommand, true);
        }
    }

    void restoreSession() {
        this.txtSQLEditor.setText(this.preferences.get("session.".concat("SQLWorkbench.sql.txt")));
        String key = "session.".concat("SQLWorkbench.split.loc");
        int loc = this.preferences.getInt(key);
        if (loc < 0) {
            this.contentPane.setDividerLocation(0.5);
        } else {
            this.contentPane.setDividerLocation(loc);
        }
    }

    void saveSession() {
        int loc = this.contentPane.getDividerLocation();
        this.preferences.putInt("session.".concat("SQLWorkbench.split.loc"), loc);
        this.preferences.put("session.".concat("SQLWorkbench.sql.txt"), this.txtSQLEditor.getText());
    }

    protected ResultSetViewer createResultSetDelegate() {
        return new ResultDelegate(this, this.controller.getJDBCConnection());
    }

    protected void actionRefreshTableView() {
        String tsql;
        String sql = this.txtSQLEditor.getText().trim();
        ITable table = this.getSelectedTable();
        String string = tsql = table == null ? "" : (String)table.getClientProperty(CLIENT_RAW_SQL);
        if (tsql.length() >= 1) {
            if (this.controller.validateConnection()) {
                this.performQuery(true, tsql, false);
            }
        } else if (sql.length() >= 1) {
            if (this.controller.validateConnection()) {
                this.performQuery(true, sql, true);
            }
        } else {
            this.controller.showInvalidConnection();
        }
    }

    protected void showDatarenderer(ITable table, int row, int col, String rendererID) {
        PluginFactory factory = this.sysConfig.getPluginFactory();
        CorePlugin plugin = factory.pluginForName(2, rendererID);
        EnhancedDataRenderer rndr = (EnhancedDataRenderer)plugin;
        if (rndr != null) {
            String title = rndr.getName();
            String tip = rndr.getDescription();
            Icon ico = rndr.getUserIcon();
            MutableContentViewer mcv = new MutableContentViewer();
            Object data = null;
            data = rndr.supportsMultipleSelections() ? table.getSelectedSubModel() : table.getValueAt(row, col);
            mcv.setContent(data, rndr);
            this.resultPane.addTab(title, ico, mcv, tip);
            int index = this.resultPane.indexOfComponent(mcv);
            this.resultPane.setClosableTab(index, true);
            this.resultPane.setSelectedIndex(index);
        }
    }

    protected void toggleResultSetDataView(ResultsetView view, boolean doSwitch) {
        if (view != null) {
            ITable table = view.getTable();
            view.clearFiltering();
            ResultSetToggler delegate = new ResultSetToggler(this.controller, table, this.jtbResultset, doSwitch);
            SwingUtilities.invokeLater(delegate);
        }
    }

    protected void toggleLockAction(int tab, boolean doAction) {
        ActionManager manager = this.controller.getActionManager();
        if (tab >= 0) {
            Action newAction;
            if (this.resultPane.isTabLocked(tab)) {
                if (doAction) {
                    this.resultPane.unlockTab(tab);
                    newAction = manager.getAction(29);
                } else {
                    newAction = manager.getAction(30);
                }
            } else if (doAction) {
                this.resultPane.lockTab(tab);
                newAction = manager.getAction(30);
            } else {
                newAction = manager.getAction(29);
            }
            if (this.jtbResultset != null) {
                this.jtbResultset.toggleAction(29, newAction);
            }
        }
        this.validateTree();
    }

    protected void toggleColumnDeleteAction(final JTable table, boolean doAction) {
        ActionManager manager = this.controller.getActionManager();
        Action newAction = null;
        if (table != null) {
            if (table.getRowSelectionAllowed()) {
                if (doAction) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            BasicUtilities.removeSelectedRows(table);
                        }
                    });
                    return;
                }
                newAction = manager.getAction(19);
            } else if (table.getColumnSelectionAllowed()) {
                if (doAction) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            BasicUtilities.removeSelectedColumns(table);
                        }
                    });
                    return;
                }
                newAction = manager.getAction(20);
            }
            if (this.jtbResultset != null) {
                this.jtbResultset.toggleAction(20, newAction);
            }
        }
    }

    protected void processAction(ActionEvent evt) {
        boolean isShift = (evt.getModifiers() & 1) == 1;
        boolean isCmd = (evt.getModifiers() & BasicUtilities.CMD_MASK) == BasicUtilities.CMD_MASK;
        ITable table = this.getSelectedTable();
        Object source = evt.getSource();
        String command = evt.getActionCommand();
        switch (evt.getID()) {
            case 26: 
            case 27: {
                this.toggleResultSetDataView((ResultsetView)this.resultPane.getSelectedComponent(), true);
                break;
            }
            case 29: 
            case 30: {
                this.toggleLockAction(this.resultPane.getSelectedIndex(), true);
                break;
            }
            case 19: 
            case 20: {
                this.toggleColumnDeleteAction(table, true);
                break;
            }
            case 511: {
                this.toggleColumnDeleteAction(table, false);
                break;
            }
            case 16: {
                this.actionRefreshTableView();
                break;
            }
            case 28: {
                this.resultPane.removeUnlockedTabs();
                break;
            }
            case 35: {
                this.createBookmark();
                break;
            }
            case 45: {
                this.resultPane.removeSelectedTab();
                break;
            }
            case 32: {
                if (table == null) break;
                int col = table.getSelectedColumn();
                int row = table.getSelectedRow();
                JMenuItem mnu = (JMenuItem)source;
                this.showDatarenderer(table, row, col, (String)mnu.getClientProperty("class-name"));
                break;
            }
            case 15: {
                if (!this.controller.validateConnection()) break;
                String sqlCommand = this.txtSQLEditor.getText();
                if (sqlCommand.length() >= 1) {
                    if (isShift) {
                        this.resultPane.removeAllTabs();
                    }
                    this.performQuery(sqlCommand, true);
                    break;
                }
                BasicUtilities.beep();
                break;
            }
            case 47: {
                if (!this.controller.validateConnection()) break;
                String sqlCommand = this.txtSQLEditor.getSelectedText();
                if (sqlCommand.length() >= 1) {
                    if (isShift) {
                        this.resultPane.removeAllTabs();
                    }
                    this.performQuery(sqlCommand, true);
                    break;
                }
                BasicUtilities.beep();
                break;
            }
            case 43: {
                int index = this.resultPane.getSelectedIndex();
                if (index + 1 >= this.resultPane.getTabCount() || this.resultPane.getTabCount() < 1) break;
                this.resultPane.setSelectedIndex(index + 1);
                break;
            }
            case 44: {
                int index = this.resultPane.getSelectedIndex();
                if (index - 1 < 0 || this.resultPane.getTabCount() < 1) break;
                this.resultPane.setSelectedIndex(index - 1);
                break;
            }
            case 64768: {
                if (table == null || !isCmd) break;
                this.txtSQLEditor.setText((String)table.getClientProperty(CLIENT_RAW_SQL));
                break;
            }
            case 64769: {
                if (table == null || this.controller.zoomComponent(this.resultPane) == null) break;
                this.resultsPanel.add((Component)this.resultPane, "Center");
                this.invalidate();
                this.repaint();
                break;
            }
            case 10: {
                if (command.equalsIgnoreCase("dnd-proxy")) {
                    Transferable trx = (Transferable)source;
                    Object data = null;
                    try {
                        data = trx.getTransferData(EnhancedTableModel.FLAVOR_OBJECT);
                    }
                    catch (Throwable t) {
                        BasicUtilities.beep();
                        return;
                    }
                    EnhancedTableModel model = (EnhancedTableModel)data;
                    JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = SQLWorkBench.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, this);
                    ExportWizard wiz = new ExportWizard((Frame)jFrame, model, this.controller.getJDBCConnection());
                    wiz.show();
                    break;
                }
                if (table == null) break;
                JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = SQLWorkBench.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, this);
                ResultSetTableModel rstm = (ResultSetTableModel)table.getModel();
                EnhancedTableModel model = null;
                model = rstm.isShowingMetadata() ? rstm.getMetadataAsModel() : rstm;
                ExportWizard wiz = new ExportWizard((Frame)jFrame, model, this.controller.getJDBCConnection());
                wiz.show();
                break;
            }
            case 1: {
                if (table != null) {
                    String title = (String)table.getClientProperty(CLIENT_RAW_SQL);
                    PrinterPreview.print(table.getModel(), title);
                    break;
                }
                if (this.delegatePrint()) break;
                BasicUtilities.beep();
                break;
            }
            case 5: {
                if (table != null) {
                    String title = (String)table.getClientProperty(CLIENT_RAW_SQL);
                    JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = SQLWorkBench.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, this);
                    PrinterPreview.showPrintPreviewDialog(jFrame, (Object)table.getModel(), title);
                    break;
                }
                if (this.delegatePrintPreview()) break;
                BasicUtilities.beep();
                break;
            }
            case 11: {
                if (table != null) {
                    BasicUtilities.copySelectedCellsToClipBoard(table);
                    break;
                }
                BasicUtilities.beep();
                break;
            }
            case 18: {
                HistoryManager historyManager = this.sysConfig.getHistoryManager();
                HistoryItem item = historyManager.newer();
                if (item == null) break;
                this.txtSQLEditor.setText(item.getSQLData());
                break;
            }
            case 17: {
                HistoryManager historyManager = this.sysConfig.getHistoryManager();
                HistoryItem item = historyManager.older();
                if (item == null) break;
                this.txtSQLEditor.setText(item.getSQLData());
                break;
            }
            case 49: {
                BasicUtilities.beep();
            }
        }
    }

    protected SQLEditor getEditor() {
        return this.txtSQLEditor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ITable getSelectedTable() {
        ITabbedPane iTabbedPane = this.resultPane;
        synchronized (iTabbedPane) {
            try {
                if (this.resultPane.isEmpty()) {
                    return null;
                }
                ResultsetView view = (ResultsetView)this.resultPane.getSelectedComponent();
                return view.getTable();
            }
            catch (Throwable t) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean delegatePrint() {
        ITabbedPane iTabbedPane = this.resultPane;
        synchronized (iTabbedPane) {
            try {
                if (this.resultPane.isEmpty()) {
                    return false;
                }
                MutableContentViewer mcv = (MutableContentViewer)this.resultPane.getSelectedComponent();
                return mcv.performPrint();
            }
            catch (Throwable t) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean delegatePrintPreview() {
        ITabbedPane iTabbedPane = this.resultPane;
        synchronized (iTabbedPane) {
            try {
                if (this.resultPane.getTabCount() <= 0) {
                    return false;
                }
                MutableContentViewer mcv = (MutableContentViewer)this.resultPane.getSelectedComponent();
                return mcv.performPrintPreview();
            }
            catch (Throwable t) {
                return false;
            }
        }
    }

    protected void createResultSetToolBar() {
        this.jtbResultset = new ResultsetToolbar(this.controller.getActionManager());
        String s = this.preferences.get("toolbar.resultset-dock");
        if (s.equalsIgnoreCase("East") || s.equalsIgnoreCase("West")) {
            this.jtbResultset.setOrientation(1);
        } else {
            this.jtbResultset.setOrientation(0);
        }
        this.jtbResultset.setVisible(this.preferences.getBoolean("toolbar.resultset-visible"));
        this.jtbResultset.setName(BasicUtilities.getString("Resultset_Toolbar"));
        JComponent cntr = (JComponent)this.contentPane.getBottomComponent();
        cntr.add((Component)this.jtbResultset, s);
        this.validateTree();
    }

    protected void createHistoryToolBar() {
        this.jtbHistory = new HistoryToolbar(this.txtSQLEditor, this.controller.getActionManager());
        String s = this.preferences.get("toolbar.history-dock");
        if (s.equalsIgnoreCase("East") || s.equalsIgnoreCase("West")) {
            this.jtbHistory.setOrientation(1);
        } else {
            this.jtbHistory.setOrientation(0);
        }
        this.jtbHistory.setVisible(this.preferences.getBoolean("toolbar.history-visible"));
        this.jtbHistory.setName(BasicUtilities.getString("History_Toolbar"));
        JComponent container = (JComponent)this.contentPane.getTopComponent();
        container.add((Component)this.jtbHistory, s);
        this.validateTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeHistoryToolbar() {
        if (this.jtbResultset != null) {
            try {
                JComponent container = (JComponent)this.contentPane.getTopComponent();
                container.remove(this.jtbHistory);
                this.jtbHistory.removeAll();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.jtbHistory = null;
                this.validateTree();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeResultsetToolbar() {
        if (this.jtbResultset != null) {
            try {
                JComponent container = (JComponent)this.contentPane.getBottomComponent();
                container.remove(this.jtbHistory);
                this.jtbResultset.removeAll();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.jtbResultset = null;
                this.validateTree();
            }
        }
    }

    protected String processSQLParameters(String sql) {
        String[] p = StringUtilities.getSQLParameters(sql);
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < p.length; ++i) {
            String key = p[i];
            String val = JOptionPane.showInputDialog(this, (Object)BasicUtilities.getString("SQL_Param_Prompt", key));
            if (val == null) {
                System.out.println(BasicUtilities.getString("Query_Cancelled"));
                map.clear();
                map = null;
                p = null;
                return null;
            }
            map.put(key, val);
        }
        String command = StringUtilities.applySQLParameters(map, sql);
        map.clear();
        map = null;
        p = null;
        return command;
    }

    protected void performQuery(String command, boolean log2History) {
        this.performQuery(false, command, log2History);
    }

    protected void performQuery(boolean isRefresh, String command, boolean log2History) {
        String string = command = command == null ? "" : command;
        if (command.trim().length() == 0) {
            System.out.println(BasicUtilities.getString("Empty_SQL_Error"));
            return;
        }
        DatabaseConnection connection = this.controller.getJDBCConnection();
        try {
            if (!isRefresh && (command = this.processSQLParameters(command)) == null) {
                return;
            }
            if (log2History) {
                this.sysConfig.getHistoryManager().addHistoryItem(command, connection);
            }
            int index = -1;
            if (isRefresh && this.preferences.getBoolean("general.refresh-reuse")) {
                if (this.resultPane.isEmpty()) {
                    index = this.resultPane.getTabCount();
                    this.resultPane.addTab("", new JLabel());
                } else {
                    index = this.resultPane.getSelectedIndex();
                }
            } else {
                index = this.resultPane.getTabCount();
                JLabel label = new JLabel();
                this.resultPane.addTab("", label);
                index = this.resultPane.indexOfComponent(label);
            }
            ResultDelegate pnl = (ResultDelegate)this.createResultSetDelegate();
            this.resultPane.setComponentAt(index, pnl);
            this.resultPane.setClosableTab(index, false);
            this.resultPane.setToolTipTextAt(index, "");
            this.resultPane.setIconAt(index, null);
            this.resultPane.setSelectedIndex(index);
            connection.executeStaticRequest(command, pnl);
        }
        catch (Throwable t) {
            this.txtSQLEditor.requestFocus();
            BasicUtilities.HandleException(t, "SQLWorkbench::performQuery()");
        }
        try {
            SQLWarningViewer.addConnectionWarnings(connection.getWarnings());
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    private void initUI() throws Exception {
        ActionManager manager = this.controller.getActionManager();
        manager.addActionListener(this.actionHandler);
        manager.addItemListener(this.actionHandler);
        this.tablePopupMenu.addAction(manager.getAction(19));
        this.tablePopupMenu.addAction(manager.getAction(16));
        this.tablePopupMenu.addAction(manager.getAction(11));
        JMenu viewMenu = new JMenu(BasicUtilities.getString("Enhance_Data_View_Mnu"));
        viewMenu.setIcon(BasicUtilities.loadIconResource("ZoomIn16"));
        this.tablePopupMenu.add(viewMenu);
        this.sysConfig.getIPCService().subscribe(this, "isql-sql-execute");
        PluginFactory factory = this.sysConfig.getPluginFactory();
        Collection renderers = factory.createDataRenderers();
        Iterator itr = renderers.iterator();
        Action viewAction = manager.getAction(32);
        while (itr.hasNext()) {
            EnhancedDataRenderer edr = (EnhancedDataRenderer)itr.next();
            JMenuItem item = new JMenuItem(viewAction);
            item.setText(edr.getName());
            item.setIcon(edr.getUserIcon());
            item.putClientProperty("class-name", edr.getClass().getName());
            item.setToolTipText(edr.getDescription());
            viewMenu.add(item);
            try {
                edr.destroy();
            }
            catch (Throwable t) {}
        }
        this.txtSQLEditor = new SQLEditor(this.controller);
        this.setLayout(new BorderLayout());
        JPanel editorPanel = new JPanel(new BorderLayout());
        this.resultsPanel.add((Component)this.resultPane, "Center");
        editorPanel.add((Component)this.txtSQLEditor, "Center");
        this.resultPane.addActionListener(this.actionHandler);
        this.resultPane.addChangeListener(this.actionHandler);
        this.add((Component)this.contentPane, "Center");
        this.contentPane.setContinuousLayout(true);
        this.contentPane.setTopComponent(editorPanel);
        this.contentPane.setBottomComponent(this.resultsPanel);
        this.resultPane.setDropTarget(new DropTarget(this.resultPane, this.bookmarkDropper));
        this.resultPane.setMaxTabCount(this.preferences.getInt("general.max-resultsets"));
        this.createResultSetToolBar();
        this.createHistoryToolBar();
        this.actionHandler.stateChanged(new ChangeEvent(this.resultPane));
    }

    private void createBookmark() {
        String name;
        String sql;
        String text = this.txtSQLEditor.getText().trim();
        ITable table = this.getSelectedTable();
        String string = sql = table == null ? "" : (String)table.getClientProperty(CLIENT_RAW_SQL);
        if (text.length() == 0 && sql.length() == 0) {
            BasicUtilities.beep();
            return;
        }
        SQLBookmark bookmark = null;
        if (!sql.equalsIgnoreCase(text) && sql.length() >= 1) {
            Object[] options;
            String msg = BasicUtilities.getString("Choose_SQL_For_Bookmark");
            String choice = (String)JOptionPane.showInputDialog(this, null, msg, 2, null, options = new String[]{BasicUtilities.getString("Select_From_Editor"), BasicUtilities.getString("Select_From_Selected_Tab")}, options[1]);
            if (choice != null) {
                String name2 = JOptionPane.showInputDialog(this, (Object)BasicUtilities.getString("Enter_Name_for_Bookmark"));
                if (name2 == null) {
                    return;
                }
                if (choice.equals(options[0])) {
                    bookmark = new SQLBookmark(name2, text);
                } else if (choice.equals(options[1])) {
                    bookmark = new SQLBookmark(name2, sql);
                }
            }
        } else if (sql.length() >= 1) {
            name = JOptionPane.showInputDialog(this, (Object)BasicUtilities.getString("Enter_Name_for_Bookmark"));
            if (name == null) {
                return;
            }
            bookmark = new SQLBookmark(name, sql);
        } else if (text.length() >= 1) {
            name = JOptionPane.showInputDialog(this, (Object)BasicUtilities.getString("Enter_Name_for_Bookmark"));
            if (name == null) {
                return;
            }
            bookmark = new SQLBookmark(name, text);
        } else {
            BasicUtilities.beep();
            return;
        }
        if (bookmark == null) {
            BasicUtilities.beep();
            return;
        }
        bookmark.setPath("/");
        BookmarkTreeModel model = this.sysConfig.getBookmarks();
        model.addBookmark(bookmark);
        Window owner = SwingUtilities.getWindowAncestor(this);
        this.dispatchEvent(new WindowEvent(owner, 205));
    }

    private static void constrain(int x, int y, int w, int h, double wx, double wy, int a, int f) {
        SQLWorkBench.UI_CONSTRAINT.gridx = x;
        SQLWorkBench.UI_CONSTRAINT.gridy = y;
        SQLWorkBench.UI_CONSTRAINT.gridwidth = w;
        SQLWorkBench.UI_CONSTRAINT.gridheight = h;
        SQLWorkBench.UI_CONSTRAINT.weightx = wx;
        SQLWorkBench.UI_CONSTRAINT.weighty = wy;
        SQLWorkBench.UI_CONSTRAINT.anchor = a;
        SQLWorkBench.UI_CONSTRAINT.fill = f;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ResultsetToolbar
    extends ActionToolBar {
        protected JButton btnColRowDelete;
        protected JButton btnViewToggle;
        protected JButton btnLockToggle;

        public ResultsetToolbar(ActionManager manager) {
            super(manager);
            this.setOrientation(1);
            this.setFloatable(false);
        }

        public void toggleAction(int newAction, Action action) {
            if (action != null) {
                switch (newAction) {
                    case 26: 
                    case 27: {
                        this.toggleAction(this.btnViewToggle, action);
                        break;
                    }
                    case 29: 
                    case 30: {
                        this.toggleAction(this.btnLockToggle, action);
                        break;
                    }
                    case 19: 
                    case 20: {
                        this.toggleAction(this.btnColRowDelete, action);
                    }
                }
            }
        }

        protected void addButtons() {
            this.btnViewToggle = this.addButton(this.manager.getAction(27));
            this.btnColRowDelete = this.addButton(this.manager.getAction(19));
            this.btnLockToggle = this.addButton(this.manager.getAction(29));
            JButton button = this.addButton(this.manager.getAction(10));
            this.addDropActionSupport(button, new DataFlavor[]{EnhancedTableModel.FLAVOR_OBJECT}, 10);
            this.addButton(this.manager.getAction(28));
            if (this.getOrientation() == 1) {
                this.add(Box.createVerticalGlue());
            } else {
                this.add(Box.createHorizontalGlue());
            }
        }

        protected void processDropProxy(Transferable data, int action) {
        }
    }

    private static class HistoryToolbar
    extends ActionToolBar
    implements Runnable,
    MouseListener {
        private boolean pressed = false;
        private JPopupMenu menuNext = new JPopupMenu();
        private Point menuPoint = new Point(0, 0);
        private SQLEditor editor = null;
        private HistoryManager history = SystemConfig.getInstance().getHistoryManager();

        public void run() {
            try {
                Thread.sleep(1250L);
                if (this.pressed) {
                    if (this.menuNext.getComponentCount() >= 1) {
                        this.menuNext.show(this, this.menuPoint.x, this.menuPoint.y);
                    } else {
                        BasicUtilities.beep();
                    }
                }
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            boolean hasHistory;
            if (e.isConsumed()) {
                return;
            }
            this.pressed = true;
            Component target = e.getComponent();
            int x = target.getX();
            int y = target.getY() + target.getHeight();
            int current = this.history.getCursorIndex();
            int size = this.history.size();
            int count = Math.min(5, size - 1);
            boolean bl = hasHistory = this.history.isCircular() && count >= 1 || count >= 1;
            if (!hasHistory) {
                BasicUtilities.beep();
                return;
            }
            boolean goback = target == this.getComponent(0);
            this.menuPoint.move(x, y);
            this.menuNext.removeAll();
            if (goback) {
                for (int i = 0; i < count; ++i) {
                    int index = current - i - 1;
                    if (index < 0) {
                        if (!this.history.isCircular()) {
                            return;
                        }
                        if (i >= 1) {
                            this.menuNext.addSeparator();
                        }
                        index = current = size - 1;
                    }
                    JMenuItem item = this.menuNext.add(this.history.get(index).toMenuString());
                    this.configureMenu(item, index);
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    int index = current + i + 1;
                    if (index >= size) {
                        if (!this.history.isCircular()) {
                            return;
                        }
                        if (i >= 1) {
                            this.menuNext.addSeparator();
                        }
                        current = 0;
                        index = 0;
                    }
                    JMenuItem item = this.menuNext.add(this.history.get(index).toMenuString());
                    this.configureMenu(item, index);
                }
            }
            new Thread(this).start();
        }

        public void mouseReleased(MouseEvent e) {
            this.pressed = false;
            if (!e.isConsumed() && this.menuNext.isShowing()) {
                Component target = e.getComponent();
                e.translatePoint(0, -1 * target.getHeight());
                if (this.menuNext.contains(e.getPoint())) {
                    JMenuItem menu = (JMenuItem)this.menuNext.getComponentAt(e.getPoint());
                    int index = (Integer)menu.getClientProperty("index");
                    HistoryItem item = this.history.get(index);
                    this.editor.setText(item.getSQLData());
                    this.history.setCursorIndex(index);
                    e.consume();
                }
                this.menuNext.setVisible(false);
            }
        }

        public HistoryToolbar(SQLEditor editor, ActionManager manager) {
            super(manager);
            this.editor = editor;
            this.setFloatable(false);
            this.add(this.menuNext);
        }

        protected void addButtons() {
            this.addButton(this.manager.getAction(17)).addMouseListener(this);
            this.addButton(this.manager.getAction(16));
            this.addButton(this.manager.getAction(15));
            this.addButton(this.manager.getAction(18)).addMouseListener(this);
            this.addButton(this.manager.getAction(35));
            this.add(Box.createHorizontalGlue());
            this.addButton(this.manager.getAction(14));
            this.addButton(this.manager.getAction(12));
            this.addButton(this.manager.getAction(13));
        }

        protected void configureMenu(JMenuItem item, int idx) {
            item.putClientProperty("index", new Integer(idx));
            item.setIcon(BasicUtilities.loadIconResource("History16"));
            item.setFont(item.getFont().deriveFont(9.0f));
        }

        protected void processDropProxy(Transferable data, int action) {
        }
    }

    private static class ResultDelegate
    extends JPanel
    implements ActionListener,
    ResultSetViewer {
        private JProgressBar eyecandy = new JProgressBar(0);
        private JLabel lblInfo = new JLabel();
        private JButton btnCancel = new JButton();
        private String sid = null;
        private DatabaseConnection currentConnection = null;
        private SQLWorkBench workbench = null;

        public ResultDelegate(SQLWorkBench bench, DatabaseConnection connection) {
            this.currentConnection = connection;
            this.workbench = bench;
            try {
                this.initUI();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void actionPerformed(ActionEvent event) {
            int index = this.workbench.resultPane.indexOfComponent(this);
            this.btnCancel.setEnabled(false);
            this.workbench.resultPane.setClosableTab(index, true);
            this.eyecandy.setIndeterminate(false);
            this.lblInfo.setText(BasicUtilities.getString("Query_Cancelled"));
            this.eyecandy.setValue(this.eyecandy.getMaximum());
            if (this.currentConnection != null) {
                this.currentConnection.cancelStatement(this.sid);
            }
        }

        public void statementInitialized(String stmtID) {
            this.sid = stmtID;
            int index = this.workbench.resultPane.indexOfComponent(this);
            if (index < 0) {
                index = this.workbench.resultPane.getTabCount();
                this.workbench.resultPane.addTab("", this);
            }
            this.lblInfo.setText(BasicUtilities.getString("Query_Initialized", stmtID));
            this.btnCancel.setEnabled(true);
            this.workbench.resultPane.setClosableTab(index, false);
            this.eyecandy.setIndeterminate(true);
            this.eyecandy.setValue(this.eyecandy.getMinimum());
        }

        public void handleSQLException(ResultSet set, SQLException e) {
            System.out.println(BasicUtilities.getString("Query_Failed"));
            BasicUtilities.HandleException(e, null, this.currentConnection.getDebugOn());
            int index = this.workbench.resultPane.indexOfComponent(this);
            if (index >= 0) {
                this.workbench.resultPane.removeTabAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processResultSet(String stmtID, ResultSet set, String nativeSQL, int count) {
            this.btnCancel.setEnabled(false);
            this.lblInfo.setText(BasicUtilities.getString("Processing_Query_Results"));
            System.out.println(this.lblInfo.getText());
            if (set != null) {
                try {
                    ResultSetTableModel model = new ResultSetTableModel(set, this, true);
                    ResultsetView view = new ResultsetView(this.workbench);
                    ITable table = view.getTable();
                    table.putClientProperty("ITable.JPopupMenu", this.workbench.tablePopupMenu);
                    table.putClientProperty(SQLWorkBench.CLIENT_RAW_SQL, nativeSQL);
                    view.setModel(model);
                    String str = "";
                    Icon ico = null;
                    if (count >= 0) {
                        try {
                            String fmt = this.workbench.preferences.get("general.results-format");
                            str = JDBCUtilities.getResultString(fmt, set, this.currentConnection, model);
                        }
                        catch (Throwable t) {
                            str = JDBCUtilities.getResultString("%s (%r,%c)", set, this.currentConnection, model);
                        }
                        ico = BasicUtilities.loadIconResource("Table16");
                    } else {
                        str = BasicUtilities.getString("Generated_Keys_Txt");
                        ico = BasicUtilities.loadIconResource("KeyTable16");
                    }
                    int index = this.workbench.resultPane.indexOfComponent(this);
                    if (index < 0) {
                        this.workbench.resultPane.addTab("", this);
                        index = this.workbench.resultPane.indexOfComponent(this);
                    }
                    String html = this.addSubText(this.workbench.txtSQLEditor.toHTML(nativeSQL));
                    this.workbench.resultPane.setToolTipTextAt(index, html);
                    this.workbench.resultPane.setTitleAt(index, str);
                    this.workbench.resultPane.setComponentAt(index, view);
                    this.workbench.resultPane.setClosableTab(index, true);
                    this.workbench.resultPane.setIconAt(index, ico);
                    if (this.currentConnection.getQueryEchoOn()) {
                        String rows = Integer.toString(model.getTrueRowCount());
                        String msg = BasicUtilities.getString("Number_Of_Records", rows);
                        System.out.println(msg);
                    }
                    BasicUtilities.optimizeTableView(table);
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t, BasicUtilities.getString("Query_Exception"));
                    int index = this.workbench.resultPane.indexOfComponent(this);
                    if (index >= 0) {
                        this.workbench.resultPane.removeTabAt(index);
                    }
                }
                finally {
                    SQLWarningViewer.addConnectionWarnings(this.currentConnection.getWarnings());
                    this.validateTree();
                }
            }
        }

        public void recieveResultsetWarnings(ResultSet set, SQLWarning warnings) {
            SQLWarningViewer.addResultsetWarnings(warnings);
        }

        public void recieveStatementWarnings(Statement stmt, SQLWarning warnings) {
            SQLWarningViewer.addStatementWarnings(warnings);
        }

        public void processRowUpdates(String stmtID, int updateCount, String nativeSQL) {
            UserPreferences prefs = SystemConfig.getInstance().getPreferences();
            String count = Integer.toString(updateCount);
            boolean keepTab = prefs.getBoolean("general.showupdatetab-enabled");
            if (!keepTab) {
                System.out.println(BasicUtilities.getString("Processing_Update_Count", count));
                int index = this.workbench.resultPane.indexOfComponent(this);
                if (index >= 0) {
                    this.workbench.resultPane.removeTabAt(index);
                }
            } else {
                this.btnCancel.setEnabled(false);
                int index = this.workbench.resultPane.indexOfComponent(this);
                if (index < 0) {
                    index = this.workbench.resultPane.getTabCount();
                    this.workbench.resultPane.addTab("", this);
                }
                this.eyecandy.setIndeterminate(false);
                this.eyecandy.setValue(this.eyecandy.getMaximum());
                String html = this.addSubText(this.workbench.txtSQLEditor.toHTML(nativeSQL));
                this.workbench.resultPane.setToolTipTextAt(index, html);
                this.workbench.resultPane.setClosableTab(index, true);
                this.workbench.resultPane.setTitleAt(index, BasicUtilities.getString("UpdateCount_Tab_Title", count));
                this.workbench.resultPane.setIconAt(index, BasicUtilities.loadIconResource("TableInfo16"));
                this.lblInfo.setText(BasicUtilities.getString("Processing_Update_Count", count));
                this.putClientProperty(SQLWorkBench.CLIENT_RAW_SQL, nativeSQL);
            }
            this.validateTree();
            this.repaint();
        }

        public void handleStatementInterrupted(String stmtID) {
            this.currentConnection = null;
            System.out.println(BasicUtilities.getString("Query_Failed"));
            int index = this.workbench.resultPane.indexOfComponent(this);
            this.workbench.resultPane.setClosableTab(index, true);
            this.eyecandy.setIndeterminate(false);
            this.lblInfo.setText(BasicUtilities.getString("Query_Cancelled"));
            this.eyecandy.setValue(this.eyecandy.getMaximum());
        }

        public void processGeneratedKeys(String stmtID, ResultSet keys, String nativeSQL) {
            this.processResultSet(stmtID, keys, nativeSQL, Integer.MIN_VALUE);
        }

        public boolean supportsGeneratedKeys() {
            return true;
        }

        public boolean supportsUpdateableResultSets() {
            return false;
        }

        private void initUI() {
            this.setLayout(new GridBagLayout());
            this.btnCancel.setText(BasicUtilities.getString("Cancel"));
            this.btnCancel.setToolTipText(BasicUtilities.getString("Cancel_Statement_Tip"));
            this.btnCancel.addActionListener(this);
            SQLWorkBench.constrain(0, 0, 1, 5, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(10), UI_CONSTRAINT);
            SQLWorkBench.constrain(1, 0, 1, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(10), UI_CONSTRAINT);
            SQLWorkBench.constrain(1, 1, 1, 1, 1.0, 0.0, 17, 2);
            this.add((Component)this.lblInfo, UI_CONSTRAINT);
            SQLWorkBench.constrain(1, 2, 1, 1, 1.0, 0.0, 17, 2);
            this.add((Component)this.eyecandy, UI_CONSTRAINT);
            SQLWorkBench.constrain(1, 3, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)this.btnCancel, UI_CONSTRAINT);
            SQLWorkBench.constrain(2, 0, 1, 5, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(10), UI_CONSTRAINT);
            SQLWorkBench.constrain(1, 4, 1, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(10), UI_CONSTRAINT);
        }

        private String addSubText(String sql) {
            StringBuffer html = new StringBuffer(sql);
            String command = InputEvent.getModifiersExText(BasicUtilities.CMD_MASK << 6);
            String msg = BasicUtilities.getString("SQL_TabTip_Text", command);
            html.append("<div align=\"center\"><font size=\"-2\" color=\"");
            html.append(StringUtilities.getHTMLColor(Color.BLACK));
            html.append("\"><tt><var>");
            html.append(msg);
            html.append("</var></tt></font></div>");
            return html.toString();
        }
    }

    private static class BookmarkDnDSupport
    extends DropTargetAdapter {
        private SQLWorkBench workbench = null;

        public BookmarkDnDSupport(SQLWorkBench ref) {
            this.workbench = ref;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetDropEvent dtde) {
            JComponent comp = (JComponent)dtde.getDropTargetContext().getComponent();
            Transferable trx = dtde.getTransferable();
            try {
                if (trx.isDataFlavorSupported(BasicUtilities.bookmarkFlavour)) {
                    SQLBookmark bookmark = (SQLBookmark)trx.getTransferData(BasicUtilities.bookmarkFlavour);
                    boolean refresh = comp instanceof ITable;
                    this.workbench.executeBookmark(bookmark, this.workbench.controller, refresh);
                }
            }
            catch (Throwable t) {
                dtde.rejectDrop();
            }
            finally {
                dtde.dropComplete(true);
            }
        }
    }

    private class InputSupport
    implements ItemListener,
    ActionListener,
    PreferenceChangeListener,
    ChangeListener {
        private InputSupport() {
        }

        public void stateChanged(ChangeEvent e) {
            ActionManager manager = SQLWorkBench.this.controller.getActionManager();
            Object src = e.getSource();
            if (src == SQLWorkBench.this.resultPane) {
                boolean isEmpty;
                boolean bl = isEmpty = SQLWorkBench.this.resultPane.getTabCount() == 0;
                if (!isEmpty) {
                    try {
                        SQLWorkBench.this.toggleResultSetDataView((ResultsetView)SQLWorkBench.this.resultPane.getSelectedComponent(), false);
                        SQLWorkBench.this.toggleColumnDeleteAction(SQLWorkBench.this.getSelectedTable(), false);
                        SQLWorkBench.this.toggleLockAction(SQLWorkBench.this.resultPane.getSelectedIndex(), false);
                    }
                    catch (Exception ex) {}
                } else if (SQLWorkBench.this.resultPane.getParent() != SQLWorkBench.this.resultsPanel && SQLWorkBench.this.controller.zoomComponent(SQLWorkBench.this.resultPane) != null) {
                    SQLWorkBench.this.resultsPanel.add((Component)SQLWorkBench.this.resultPane, "Center");
                    SQLWorkBench.this.invalidate();
                    SQLWorkBench.this.repaint();
                }
                SQLWorkBench.this.jtbResultset.setActionEnabled(!isEmpty);
                manager.setActionEnabled(1, !isEmpty);
                manager.setActionEnabled(5, !isEmpty);
            }
        }

        public void itemStateChanged(ItemEvent e) {
            JCheckBoxAction chkBox = (JCheckBoxAction)e.getItem();
            String actionName = chkBox.getValue("Name").toString();
            boolean selected = chkBox.isSelected();
            if (actionName.equalsIgnoreCase(SQLWorkBench.this.jtbHistory.getName())) {
                SQLWorkBench.this.preferences.putBoolean("toolbar.history-visible", selected);
            } else if (actionName.equalsIgnoreCase(SQLWorkBench.this.jtbResultset.getName())) {
                SQLWorkBench.this.preferences.putBoolean("toolbar.resultset-visible", selected);
            }
        }

        public void preferenceChange(PreferenceChangeEvent event) {
            String key = event.getKey();
            if (key.equals("toolbar.resultset-dock")) {
                SQLWorkBench.this.removeResultsetToolbar();
                SQLWorkBench.this.createResultSetToolBar();
            } else if (key.equals("toolbar.history-dock")) {
                SQLWorkBench.this.removeHistoryToolbar();
                SQLWorkBench.this.createHistoryToolBar();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            SQLWorkBench.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                SQLWorkBench.this.processAction(e);
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "SQLWorkbench::processAction()");
            }
            finally {
                SQLWorkBench.this.setCursor(Cursor.getDefaultCursor());
                System.runFinalization();
            }
        }
    }

    private static class ResultSetToggler
    implements Runnable {
        private ITable table = null;
        private AppController ctrlr = null;
        private ResultsetToolbar toolbar = null;
        private boolean doSwitch = false;

        public ResultSetToggler(AppController cntrlr, ITable table, ResultsetToolbar toolbar, boolean doSwitch) {
            this.table = table;
            this.ctrlr = cntrlr;
            this.doSwitch = doSwitch;
            this.toolbar = toolbar;
        }

        public void run() {
            ActionManager manager = this.ctrlr.getActionManager();
            if (this.table != null) {
                Action newAction;
                ResultSetTableModel model = (ResultSetTableModel)this.table.getModel();
                if (model.isShowingMetadata()) {
                    if (this.doSwitch) {
                        model.showResultSetData();
                        newAction = manager.getAction(27);
                    } else {
                        newAction = manager.getAction(26);
                    }
                } else if (this.doSwitch) {
                    model.showMetaData();
                    newAction = manager.getAction(26);
                } else {
                    newAction = manager.getAction(27);
                }
                if (this.doSwitch) {
                    BasicUtilities.optimizeTableView(this.table);
                }
                if (this.toolbar != null) {
                    this.toolbar.toggleAction(26, newAction);
                }
            }
        }
    }

    private static class ResultsetView
    extends JPanel
    implements ListSelectionListener,
    ActionListener,
    DocumentListener {
        private NumberFormat nf = NumberFormat.getIntegerInstance();
        private SQLWorkBench workbench = null;
        private ITable table = null;
        private JTextField txtFilter = new JTextField();
        private JLabel lblFilter = new JLabel();
        private JScrollPane jspTable = null;
        private Component glue = Box.createHorizontalGlue();
        private JLabel lblLocatr = new JLabel();
        private JLabel lblSearch = new JLabel(BasicUtilities.loadIconResource("Search"));
        private JButton btnHider = new JButton();
        private JButton actionPageUp = new JButton(BasicUtilities.loadIconResource("Up16"));
        private JButton actionPageDown = new JButton(BasicUtilities.loadIconResource("Down16"));

        public ResultsetView(SQLWorkBench swb) {
            this.workbench = swb;
            try {
                this.initUI();
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
            }
        }

        private void initUI() {
            this.table = new ITable(this.workbench.controller.getActionManager());
            this.table.setDropTarget(new DropTarget(this.table, this.workbench.bookmarkDropper));
            this.table.setFont(this.table.getFont().deriveFont(10.0f));
            this.table.putClientProperty("ITable.JPopupMenu", this.workbench.tablePopupMenu);
            this.table.setDragEnabled(true);
            this.table.getSelectionModel().addListSelectionListener(this);
            this.jspTable = new JScrollPane(this.table);
            this.lblLocatr.setBorder(BorderFactory.createEtchedBorder());
            this.btnHider.setIcon(new SortableHeaderRenderer.BasicArrowIcon(1, 4));
            this.btnHider.setBorderPainted(false);
            this.btnHider.setFocusPainted(false);
            this.btnHider.addActionListener(this);
            this.btnHider.setToolTipText(BasicUtilities.getString("Filter_Hide_Tip"));
            this.actionPageUp.addActionListener(this);
            this.actionPageUp.setBorderPainted(false);
            this.actionPageUp.setFocusPainted(false);
            this.actionPageUp.setToolTipText(BasicUtilities.getString("View_Prev"));
            this.actionPageDown.addActionListener(this);
            this.actionPageDown.setBorderPainted(false);
            this.actionPageDown.setFocusPainted(false);
            this.actionPageDown.setToolTipText(BasicUtilities.getString("View_Next"));
            this.txtFilter.setToolTipText(BasicUtilities.getString("Filter_Input_Tip"));
            this.txtFilter.getDocument().addDocumentListener(this);
            this.lblFilter.setFont(this.lblFilter.getFont().deriveFont(9.0f));
            this.setLayout(new GridBagLayout());
            SQLWorkBench.constrain(0, 0, 1, 1, 1.0, 0.0, 10, 2);
            this.add(this.glue, UI_CONSTRAINT);
            SQLWorkBench.constrain(1, 0, 1, 1, 0.0, 0.0, 13, 2);
            this.add((Component)this.lblSearch, UI_CONSTRAINT);
            SQLWorkBench.constrain(2, 0, 1, 1, 0.35, 0.0, 17, 2);
            this.add((Component)this.txtFilter, UI_CONSTRAINT);
            SQLWorkBench.constrain(3, 0, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)this.btnHider, UI_CONSTRAINT);
            SQLWorkBench.constrain(2, 1, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.lblFilter, UI_CONSTRAINT);
            SQLWorkBench.constrain(0, 2, 4, 1, 1.0, 1.0, 10, 1);
            this.add((Component)this.jspTable, UI_CONSTRAINT);
            SQLWorkBench.constrain(1, 3, 4, 1, 1.0, 0.0, 13, 0);
            this.add((Component)this.lblLocatr, UI_CONSTRAINT);
        }

        public void setModel(EnhancedTableModel model) {
            this.table.setModel(model);
            if (model.getTrueRowCount() >= 1) {
                this.table.setRowSelectionInterval(0, 0);
            }
            if (model.getPageCount() > 1) {
                this.jspTable.setHorizontalScrollBarPolicy(32);
                this.jspTable.setVerticalScrollBarPolicy(22);
                this.jspTable.setCorner("UPPER_RIGHT_CORNER", this.actionPageUp);
                this.jspTable.setCorner("LOWER_RIGHT_CORNER", this.actionPageDown);
            } else {
                this.jspTable.setHorizontalScrollBarPolicy(30);
                this.jspTable.setVerticalScrollBarPolicy(20);
                this.jspTable.setCorner("UPPER_RIGHT_CORNER", Box.createHorizontalStrut(0));
                this.jspTable.setCorner("LOWER_RIGHT_CORNER", Box.createHorizontalStrut(0));
            }
        }

        public ITable getTable() {
            return this.table;
        }

        public void clearFiltering() {
            if (this.table != null) {
                ResultSetTableModel model = (ResultSetTableModel)this.table.getModel();
                model.clearFilter();
            }
            this.txtFilter.setText(null);
            this.lblFilter.setText(null);
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            this.doFiltering();
        }

        public void removeUpdate(DocumentEvent e) {
            this.doFiltering();
        }

        private void doFiltering() {
            if (this.table != null) {
                String filter;
                ResultSetTableModel model = (ResultSetTableModel)this.table.getModel();
                int found = model.applyFilter(filter = this.txtFilter.getText().trim());
                if (found >= 1) {
                    String txt = BasicUtilities.getString("Filter_Matches", Integer.toString(found));
                    this.lblFilter.setText(txt);
                } else if (filter.length() >= 1) {
                    this.lblFilter.setText(BasicUtilities.getString("Filter_No_Matches"));
                } else {
                    this.lblFilter.setText(null);
                }
                if (this.table.getRowCount() >= 1) {
                    this.table.setRowSelectionInterval(0, 0);
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == this.btnHider) {
                this.txtFilter.setVisible(!this.txtFilter.isVisible());
                this.lblFilter.setVisible(!this.lblFilter.isVisible());
                this.lblSearch.setVisible(!this.lblSearch.isVisible());
                this.glue.setVisible(!this.glue.isVisible());
                if (this.txtFilter.isVisible()) {
                    this.btnHider.setIcon(new SortableHeaderRenderer.BasicArrowIcon(1, 4));
                    this.btnHider.setToolTipText(BasicUtilities.getString("Filter_Hide_Tip"));
                } else {
                    this.btnHider.setIcon(new SortableHeaderRenderer.BasicArrowIcon(5, 4));
                    this.btnHider.setToolTipText(BasicUtilities.getString("Filter_Show_Tip"));
                }
                this.validateTree();
                this.repaint();
            } else if (src == this.actionPageDown) {
                EnhancedTableModel model = (EnhancedTableModel)this.table.getModel();
                model.pageDown();
            } else if (src == this.actionPageUp) {
                EnhancedTableModel model = (EnhancedTableModel)this.table.getModel();
                model.pageUp();
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            EnhancedTableModel model = (EnhancedTableModel)this.table.getModel();
            String str = this.nf.format(model.translateRow(this.table.getSelectedRow()) + 1);
            str = str.concat("/");
            str = str.concat(this.nf.format(model.getTrueRowCount()));
            str = str.concat(" [");
            str = str.concat(this.nf.format(model.getPageOffset() + 1));
            str = str.concat("/");
            str = str.concat(this.nf.format(model.getPageCount()));
            this.lblLocatr.setText(" ".concat(str).concat("] "));
        }
    }
}

