/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.isqlviewer.core.TableFilter;
import org.isqlviewer.core.jetfire.ImportRunner;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.swing.ImportEditor;
import org.isqlviewer.swing.ProgressPanel;
import org.isqlviewer.swing.TableFilterEditor;
import org.isqlviewer.ui.WizardContainer;
import org.isqlviewer.util.BasicUtilities;

public final class ImportWizard
extends WizardContainer
implements ActionListener {
    private ImportEditor dataMapper = null;
    private ProgressPanel pnlProgress = new ProgressPanel();
    private static final String STEP_SELECT = "SELECT";
    private static final String STEP_IMPORT = "IMPORT";
    private static final String STEP_PROGRESS = "PROGRESS";
    private EnhancedTableModel mdlImportData = new EnhancedTableModel(new String[0]);
    private DatabaseConnection databaseConnection;
    private TableFilterEditor jfeFilterSelector = null;
    private Thread importThread;

    public ImportWizard(Frame parent, DatabaseConnection dbc) {
        super(parent);
        this.setTitle(BasicUtilities.getString("Import_Wizard_Title"));
        try {
            this.databaseConnection = dbc;
            this.jfeFilterSelector = new TableFilterEditor(0, dbc);
            this.initUI();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.pack();
        this.setSize(new Dimension(800, 580));
        this.setLocationRelativeTo(parent);
        this.startWizard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        if (this.importThread != null) {
            this.importThread.interrupt();
            try {
                this.importThread.join(15000L);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.importThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 205) {
            int idx = -1;
            if (idx >= 0) {
                this.jfeFilterSelector.setSelectedFilterIndex(idx);
            } else {
                this.jfeFilterSelector.setSelectedFilterIndex(0);
            }
        } else if (evt.getID() == 201) {
            if (this.importThread != null && this.importThread.isAlive()) {
                if (!this.importThread.isInterrupted()) {
                    this.importThread.interrupt();
                }
                try {
                    this.importThread.join(15000L);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.importThread = null;
                }
            }
            this.jfeFilterSelector.close();
        }
        super.processWindowEvent(evt);
    }

    protected boolean isStepValid(String stepName) {
        if (stepName.equals(STEP_IMPORT)) {
            return !this.dataMapper.getImportConfig().isEmpty();
        }
        return super.isStepValid(stepName);
    }

    protected void processStepChange(String card, boolean isFinal, String previous) {
        if (card.equalsIgnoreCase(STEP_PROGRESS)) {
            this.setPreviousStepEnabled(true);
            this.setBanner(BasicUtilities.getString("Import_Progress_Banner"));
            this.setComment(BasicUtilities.getString("Import_Progress_Comment"));
            this.setIcon(BasicUtilities.loadIconResource("Import24"));
            int mode = previous.equals(STEP_SELECT) ? 1 : 2;
            ImportWorker worker = new ImportWorker(mode);
            String tName = "import:" + this.jfeFilterSelector.getSelectedFilter().getName();
            this.importThread = new Thread((Runnable)worker, tName);
            this.importThread.start();
            return;
        }
        if (card.equalsIgnoreCase(STEP_IMPORT)) {
            this.removeUserComponent(STEP_PROGRESS);
            this.pnlProgress.reset();
            this.addUserComponent(STEP_PROGRESS, this.pnlProgress);
            this.setBanner(BasicUtilities.getString("Import_Map_Banner"));
            this.setComment(BasicUtilities.getString("Import_Map_Comment"));
            this.setIcon(BasicUtilities.loadIconResource("Import24"));
            return;
        }
        if (card.equalsIgnoreCase(STEP_SELECT)) {
            this.removeUserComponent(STEP_IMPORT);
            this.setPreviousStepEnabled(false);
            this.setBanner(BasicUtilities.getString("Import_Select_Banner"));
            this.setComment(BasicUtilities.getString("Import_Select_Comment"));
            this.setIcon(BasicUtilities.loadIconResource("Database24"));
        }
    }

    private void initUI() {
        this.pnlProgress.addActionListener(this);
        this.jfeFilterSelector.setFilterContent(this.mdlImportData);
        this.setDefaultCloseOperation(2);
        this.setHomeAllowable(false);
        this.addUserComponent(STEP_SELECT, this.jfeFilterSelector);
        this.addUserComponent(STEP_PROGRESS, this.pnlProgress);
        this.setSize(800, 570);
    }

    private class ImportWorker
    implements Runnable {
        public static final int MODE_DATA_FILTER = 1;
        public static final int MODE_DATA_IMPORT = 2;
        private int opMode = 0;
        private PrintStream err = ImportWizard.access$000(ImportWizard.this).getErrStream();
        private PrintStream out = ImportWizard.access$000(ImportWizard.this).getOutStream();

        public ImportWorker(int mode) {
            if (mode != 1 && mode != 2) {
                throw new IllegalArgumentException();
            }
            this.opMode = mode;
        }

        public void run() {
            ImportWizard.this.setPreviousStepEnabled(false);
            ImportWizard.this.setNextStepEnabled(false);
            switch (this.opMode) {
                case 1: {
                    try {
                        this.runFilter();
                    }
                    catch (Throwable t) {
                        BasicUtilities.HandleException(t, "ImportProcess:runFilter()");
                    }
                    break;
                }
                case 2: {
                    try {
                        ImportRunner runner = new ImportRunner(ImportWizard.this.dataMapper.getImportConfig(), ImportWizard.this.databaseConnection);
                        runner.setSourceData(ImportWizard.this.mdlImportData);
                        runner.setStdErr(this.err);
                        runner.setStdOut(this.out);
                        runner.runImport();
                    }
                    catch (Throwable t) {
                        BasicUtilities.HandleException(t, "ImportProcess:runImport()");
                    }
                    this.out.println(BasicUtilities.getString("Import_Finish_Info"));
                    break;
                }
            }
            ImportWizard.this.setPreviousStepEnabled(true);
            ImportWizard.this.setNextStepEnabled(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void runFilter() {
            TableFilter filter = ImportWizard.this.jfeFilterSelector.getSelectedFilter();
            InputStream filterInputStream = null;
            File filterFile = null;
            if (filter == null) {
                JOptionPane.showMessageDialog(ImportWizard.this, BasicUtilities.getString("Import_No_Filter_Error"));
                return;
            }
            filter.addProgressListener(ImportWizard.this.pnlProgress);
            filter.setLogStream(new PrintWriter(this.out, true));
            ImportWizard.this.mdlImportData.clearAll();
            if (filter.isFileRequired(0)) {
                FileFilter[] fnf = filter.getSupportedFileTypes(0);
                filterFile = BasicUtilities.getSystemFile(ImportWizard.this, 2, fnf);
                if (filterFile == null) {
                    this.out.println(BasicUtilities.getString("Import_Cancelled"));
                    return;
                }
                if (!filter.accept(0, filterFile)) {
                    this.out.println(BasicUtilities.getString("Import_File_Not_Accepted", filterFile.getAbsolutePath()));
                    ImportWizard.this.setNextStepEnabled(false);
                    return;
                }
                try {
                    if (filterFile.isFile()) {
                        filterInputStream = new FileInputStream(filterFile);
                    }
                }
                catch (Throwable t) {
                    String msg = BasicUtilities.getString("Error_Reading_File", filterFile.getAbsolutePath());
                    BasicUtilities.HandleException(t, msg, true, this.err);
                    ImportWizard.this.setNextStepEnabled(false);
                    return;
                }
            }
            int result = -1;
            Thread.currentThread().setContextClassLoader(filter.getClass().getClassLoader());
            try {
                long epoch = System.currentTimeMillis();
                this.out.println(BasicUtilities.getString("Import_Starting", filter.getName()));
                result = filter.filterIn(ImportWizard.this.mdlImportData, filterFile, filterInputStream);
                epoch = System.currentTimeMillis() - epoch;
                this.out.println(BasicUtilities.getString("Import_Complete", Long.toString(epoch)));
            }
            catch (IOException ioe) {
                result = 0;
                BasicUtilities.HandleException((Throwable)ioe, BasicUtilities.getString("IO_Filter_Error"), true, this.err);
            }
            catch (InterruptedException ie) {
                result = 2;
                BasicUtilities.HandleException((Throwable)ie, BasicUtilities.getString("Interrupted_Filter_Error"), true, this.err);
            }
            catch (Throwable t) {
                result = 0;
                BasicUtilities.HandleException(t, BasicUtilities.getString("Unhandled_Filter_Error"), true, this.err);
            }
            finally {
                try {
                    filterInputStream.close();
                }
                catch (Throwable t) {}
                filterInputStream = null;
            }
            filter.removeProgressListener(ImportWizard.this.pnlProgress);
            switch (result) {
                case 2: {
                    this.err.println(BasicUtilities.getString("Interrupted_Filter_Error"));
                    return;
                }
                case 1: {
                    this.out.println(BasicUtilities.getString("Import_Finished", filter.getName()));
                    return;
                }
                case 3: {
                    if (ImportWizard.this.dataMapper == null) {
                        ImportWizard.this.dataMapper = new ImportEditor(ImportWizard.this.databaseConnection);
                    }
                    ImportWizard.this.addUserComponent(ImportWizard.STEP_IMPORT, ImportWizard.this.dataMapper);
                    ImportWizard.this.dataMapper.setData(ImportWizard.this.mdlImportData);
                    this.out.println(BasicUtilities.getString("Import_Map_Required", filter.getName()));
                    return;
                }
            }
            this.err.println(BasicUtilities.getString("Import_Failed", filter.getName()));
        }
    }
}

