/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import org.isqlviewer.core.TableFilter;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.swing.ITable;
import org.isqlviewer.swing.ProgressPanel;
import org.isqlviewer.swing.TableFilterEditor;
import org.isqlviewer.ui.WizardContainer;
import org.isqlviewer.util.BasicUtilities;

public final class ExportWizard
extends WizardContainer {
    private final String STEP_EXPORT = "EXPORT";
    private final String STEP_SELECT = "SELECT";
    private final String STEP_TAILOR = "TALIOR";
    private EnhancedTableModel mdlData;
    private TableFilterEditor tfEditor = null;
    private Thread exportThread;
    private ProgressPanel pnlProgress = new ProgressPanel();

    public ExportWizard(Frame zParent, EnhancedTableModel data, DatabaseConnection jdbcCnx) {
        super(zParent);
        this.setIcon(BasicUtilities.loadIconResource("Export24"));
        this.mdlData = (EnhancedTableModel)data.clone();
        this.tfEditor = new TableFilterEditor(1, jdbcCnx);
        try {
            this.initUI();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "ExportWizard::initUI()");
            this.dispose();
        }
        this.setSize(new Dimension(640, 480));
        this.setLocationRelativeTo(zParent);
    }

    private void initUI() throws Exception {
        this.setDefaultCloseOperation(2);
        this.setHomeAllowable(false);
        this.setPreviousStepEnabled(false);
        this.addUserComponent("SELECT", this.tfEditor);
        this.addUserComponent("TALIOR", new ExportTailor(this.mdlData));
        this.addUserComponent("EXPORT", this.pnlProgress);
        this.tfEditor.setFilterContent(this.mdlData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 200) {
            this.startWizard();
            int idx = -1;
            if (idx >= 0) {
                this.tfEditor.setSelectedFilterIndex(idx);
            } else {
                this.tfEditor.setSelectedFilterIndex(0);
            }
        } else if (evt.getID() == 201) {
            if (this.exportThread != null && this.exportThread.isAlive()) {
                if (!this.exportThread.isInterrupted()) {
                    this.exportThread.interrupt();
                }
                try {
                    this.exportThread.join(30000L);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.exportThread = null;
                }
            }
            this.tfEditor.close();
        }
        super.processWindowEvent(evt);
    }

    protected boolean isStepValid(String stepName) {
        if (stepName != null && stepName.equals("TALIOR")) {
            this.exportThread = new Thread(new ExportProcess());
            this.exportThread.start();
        }
        return true;
    }

    protected void processStepChange(String stepName, boolean isFinal, String lastStep) {
        if (stepName.equalsIgnoreCase("SELECT")) {
            this.setBanner(BasicUtilities.getString("Export_Filter_Select"));
            this.setComment(BasicUtilities.getString("Export_Select_Comment"));
            return;
        }
        if (stepName.equalsIgnoreCase("TALIOR")) {
            this.setBanner(BasicUtilities.getString("Export_Tailor_Text"));
            this.setComment(BasicUtilities.getString("Export_Tailor_Comment"));
            return;
        }
        if (stepName.equalsIgnoreCase("EXPORT")) {
            this.setBanner(BasicUtilities.getString("Export_Progress_Text"));
            this.setComment(BasicUtilities.getString("Progress_Console_Tip"));
            return;
        }
    }

    private static class ExportTailor
    extends JPanel
    implements ActionListener {
        private ITable table = new ITable();
        private JButton delete = new JButton();

        public ExportTailor(TableModel model) {
            try {
                this.table.setModel(model);
                this.initUI();
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "ExportTailer:initUI()");
            }
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (this.table.getRowSelectionAllowed()) {
                if (src == this.delete) {
                    BasicUtilities.removeSelectedRows(this.table);
                } else {
                    this.delete.setIcon(BasicUtilities.loadToolbarIconResource("RowDelete"));
                }
            } else if (src == this.delete) {
                BasicUtilities.removeSelectedColumns(this.table);
            } else {
                this.delete.setIcon(BasicUtilities.loadToolbarIconResource("ColumnDelete"));
            }
        }

        private void initUI() {
            this.setLayout(new GridBagLayout());
            JScrollPane jsp = new JScrollPane(this.table);
            this.table.addActionListener(this);
            this.table.allowColumnReordering(false);
            this.delete.addActionListener(this);
            this.delete.setIcon(BasicUtilities.loadToolbarIconResource("RowDelete"));
            WizardContainer.constrain(1, 1, 1, 1, 0.0, 0.0, 13, 0);
            this.add((Component)this.delete, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 2, 1, 1, 1.0, 1.0, 10, 1);
            this.add((Component)jsp, WizardContainer.UI_CONSTRAINT);
        }
    }

    private class ExportProcess
    implements Runnable {
        private ExportProcess() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block21: {
                try {
                    TableFilter filter = ExportWizard.this.tfEditor.getSelectedFilter();
                    if (filter == null) {
                        JOptionPane.showMessageDialog(ExportWizard.this, BasicUtilities.getString("Export_No_Filter_Error"));
                        return;
                    }
                    filter.addProgressListener(ExportWizard.this.pnlProgress);
                    filter.setLogStream(new PrintWriter(ExportWizard.this.pnlProgress.getOutStream(), true));
                    int result = 0;
                    File exportFile = null;
                    PrintStream out = ExportWizard.this.pnlProgress.getOutStream();
                    PrintStream err = ExportWizard.this.pnlProgress.getErrStream();
                    if (filter.isFileRequired(1)) {
                        FileFilter[] fnf = filter.getSupportedFileTypes(1);
                        exportFile = BasicUtilities.saveSystemFile(ExportWizard.this, fnf);
                        if (exportFile != null && filter.accept(1, exportFile)) {
                            exportFile.createNewFile();
                            FileOutputStream fos = null;
                            long epoch = System.currentTimeMillis();
                            try {
                                fos = new FileOutputStream(exportFile);
                                String msg = BasicUtilities.getString("Export_Starting", filter.getName());
                                ExportWizard.this.pnlProgress.getOutStream().println(msg);
                                result = filter.filterOut(ExportWizard.this.mdlData, exportFile, fos);
                                if (result != 1) {
                                    msg = BasicUtilities.getString("Export_Failure", filter.getName());
                                    err.println(msg);
                                } else {
                                    msg = BasicUtilities.getString("Export_Success", filter.getName());
                                    out.println(msg);
                                }
                                epoch = System.currentTimeMillis() - epoch;
                                msg = BasicUtilities.getString("Export_Complete", Long.toString(epoch));
                                ExportWizard.this.pnlProgress.getOutStream().println(msg);
                                break block21;
                            }
                            catch (Throwable t) {
                                BasicUtilities.HandleException(t, "filter();", true, ExportWizard.this.pnlProgress.getErrStream());
                                break block21;
                            }
                            finally {
                                try {
                                    fos.close();
                                }
                                catch (Throwable t) {}
                            }
                        }
                        JOptionPane.showMessageDialog(ExportWizard.this, BasicUtilities.getString("Export_Cancelled"));
                        return;
                    }
                    long epoch = System.currentTimeMillis();
                    String msg = BasicUtilities.getString("Export_Starting", filter.getName());
                    ExportWizard.this.pnlProgress.getOutStream().println(msg);
                    result = filter.filterOut(ExportWizard.this.mdlData, exportFile, null);
                    epoch = System.currentTimeMillis() - epoch;
                    if (result == 0) {
                        msg = BasicUtilities.getString("Export_Failed", filter.getName());
                        ExportWizard.this.pnlProgress.getOutStream().println(msg);
                    } else {
                        msg = BasicUtilities.getString("Export_Success", filter.getName());
                        ExportWizard.this.pnlProgress.getOutStream().println(msg);
                    }
                    msg = BasicUtilities.getString("Export_Complete", Long.toString(epoch));
                    ExportWizard.this.pnlProgress.getOutStream().println(msg);
                }
                catch (InterruptedException ie) {
                    JOptionPane.showMessageDialog(ExportWizard.this, BasicUtilities.getString("Export_Cancelled"));
                    return;
                }
                catch (Exception e) {
                    String msg = BasicUtilities.getString("Export_Exception", "" + e);
                    JOptionPane.showMessageDialog(ExportWizard.this, msg);
                    return;
                }
            }
        }
    }
}

