/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.swing.ITable;
import org.isqlviewer.swing.print.DefaultPaperComponent;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.UserPreferences;

public final class JTablePaper
extends DefaultPaperComponent {
    public static final int MODE_OVERDOWN = 0;
    public static final int MODE_DOWNOVER = 1;
    private int printMode = 0;
    private PageCfg[] pageConfig = null;
    private int pageCount = 0;
    private boolean showGridlines = true;
    private JTable table = new ITable();

    public void setContent(Object Data) {
        if (Data instanceof JTable) {
            this.table = (JTable)Data;
        } else if (Data instanceof TableModel) {
            this.table = new ITable();
            this.table.setModel((TableModel)Data);
        } else {
            throw new IllegalArgumentException();
        }
        this.table.setFont(this.table.getFont().deriveFont(9.0f));
        this.table.putClientProperty("isPrinting", Boolean.TRUE);
        this.pageCount = 0;
        this.mCurrentPage = 0;
        this.isValid = false;
        this.invalidate();
    }

    public void initialize(Graphics2D g2) {
        this.firePropertyChange("init", false, true);
        super.initialize(g2);
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0) {
            this.firePropertyChange("init", true, false);
            this.isValid = true;
            return;
        }
        try {
            int hdrSize = this.getHeaderHeight();
            int[] rowSets = this.getRowSet(this.getContentHeight() - hdrSize);
            int[] colSets = this.getColumnSet(this.getContentWidth());
            this.pageCount = colSets.length * rowSets.length;
            this.pageConfig = new PageCfg[this.pageCount];
            int currentColumn = 0;
            int currentRow = 0;
            int maxColumns = this.table.getColumnCount();
            int maxRows = this.table.getRowCount();
            if (this.table.getModel() instanceof EnhancedTableModel) {
                maxRows = ((EnhancedTableModel)this.table.getModel()).getTrueRowCount();
            }
            Dimension ics = this.table.getIntercellSpacing();
            this.showGridlines = ics.height >= 2 && ics.width >= 2;
            int index = 0;
            block5: for (int i = 0; i < this.pageCount; ++i) {
                switch (this.printMode) {
                    case 1: {
                        this.pageConfig[i] = new PageCfg();
                        this.pageConfig[i].columnCount = colSets[index];
                        this.pageConfig[i].columnOffset = currentColumn;
                        this.pageConfig[i].rowOffset = currentRow;
                        this.pageConfig[i].rowCount = rowSets[i % rowSets.length];
                        this.distrbuteWidths(this.getContentWidth(), this.pageConfig[i]);
                        currentRow += this.pageConfig[i].rowCount;
                        if (i % rowSets.length != rowSets.length - 1) continue block5;
                        currentRow = 0;
                        currentColumn += this.pageConfig[i].columnCount;
                        ++index;
                        continue block5;
                    }
                    default: {
                        this.pageConfig[i] = new PageCfg();
                        this.pageConfig[i].columnCount = colSets[i % colSets.length];
                        this.pageConfig[i].columnOffset = currentColumn;
                        this.pageConfig[i].rowOffset = currentRow;
                        this.pageConfig[i].rowCount = rowSets[i % rowSets.length];
                        this.distrbuteWidths(this.getContentWidth(), this.pageConfig[i]);
                        currentRow += this.pageConfig[i].rowCount;
                        if ((currentColumn += this.pageConfig[i].columnCount) >= maxColumns || i % colSets.length == colSets.length - 1) {
                            currentColumn = 0;
                        }
                        if (currentRow < maxRows && i % rowSets.length != rowSets.length - 1) continue block5;
                        currentRow = 0;
                    }
                }
            }
            this.isValid = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.isValid = true;
        this.firePropertyChange("init", true, false);
    }

    public int getPageCount() {
        return this.pageConfig != null ? this.pageConfig.length : 0;
    }

    public void configure(UserPreferences properties) {
        super.configure(properties);
        this.showGridlines = properties.getBoolean("print.grid-enabled");
        this.printMode = properties.getInt("print.table-style");
        this.isValid = false;
        this.invalidate();
    }

    protected void drawPageContents(Graphics2D g, int pageIndex) {
        int offset = this.drawTableColumnHeaders(g, pageIndex);
        this.drawTableContents(offset, g, pageIndex);
        if (this.showGridlines) {
            this.drawGridLines(offset, g, pageIndex);
        }
    }

    protected String getHeaderString(int PageIndex) {
        int maxRows = this.table.getRowCount();
        if (this.table.getModel() instanceof EnhancedTableModel) {
            maxRows = ((EnhancedTableModel)this.table.getModel()).getTrueRowCount();
        }
        return BasicUtilities.getString("Print_Table_Header", Integer.toString(maxRows));
    }

    protected String getFooterString(int PageIndex) {
        PageCfg cfg = this.pageConfig[PageIndex];
        String[] p = new String[]{Integer.toString(cfg.rowOffset + 1), Integer.toString(cfg.rowOffset + cfg.rowCount)};
        return BasicUtilities.getString("Print_Footer_Text", p);
    }

    private int drawTableColumnHeaders(Graphics2D g, int pageIndex) {
        if (this.pageConfig == null) {
            return 0;
        }
        PageCfg page = this.pageConfig[pageIndex];
        int r = -1;
        int cX = page.margin / 2;
        int headerHieght = 0;
        for (int i = 0; i < page.columnCount; ++i) {
            TableColumn column = this.table.getColumnModel().getColumn(page.columnOffset + i);
            TableCellRenderer rndr = column.getHeaderRenderer();
            if (rndr == null) {
                rndr = this.table.getTableHeader().getDefaultRenderer();
            }
            Object o = column.getHeaderValue();
            Component comp = rndr.getTableCellRendererComponent(this.table, o, false, false, r, i);
            Rectangle oldRect = comp.getBounds();
            Dimension oldDim = comp.getSize();
            Dimension size = comp.getPreferredSize();
            size.setSize(column.getPreferredWidth(), size.height);
            comp.setBounds(0, 0, size.width, size.height);
            comp.setSize(size.width, size.height);
            headerHieght = Math.max(headerHieght, size.height);
            comp.validate();
            Graphics2D cmpGraphics = (Graphics2D)g.create(cX, 0, size.width, size.height);
            cX += size.width;
            comp.paint(cmpGraphics);
            comp.setBounds(oldRect);
            comp.setSize(oldDim);
            comp.validate();
        }
        return headerHieght;
    }

    private void drawGridLines(int yOffset, Graphics2D g, int pageIndex) {
        PageCfg cfg = this.pageConfig[pageIndex];
        g.translate(0, yOffset);
        if (this.useColor()) {
            g.setColor(this.table.getGridColor());
        } else {
            g.setColor(Color.darkGray);
        }
        int acumHeight = 0;
        int cX = cfg.margin / 2;
        int r = 0;
        for (r = 1; r <= cfg.rowCount; ++r) {
            int height = r * (this.table.getRowHeight(r) + this.table.getRowMargin());
            acumHeight += height;
            g.drawLine(cfg.margin / 2, height, cfg.realWidth, height);
        }
        int margin = this.table.getIntercellSpacing().width;
        for (int c = 0; c < cfg.columnCount - 1; ++c) {
            int realColumn = cfg.columnOffset + c;
            TableColumn column = this.table.getColumnModel().getColumn(realColumn);
            g.drawLine((cX += column.getPreferredWidth()) - margin / 2, 0, cX - margin / 2, acumHeight);
        }
        g.translate(0, -yOffset);
    }

    private void drawTableContents(int yOffset, Graphics2D g, int pageIndex) {
        if (this.pageConfig == null) {
            return;
        }
        PageCfg page = this.pageConfig[pageIndex];
        int cX = page.margin / 2;
        int cY = 0;
        g.translate(0, yOffset);
        g.setColor(Color.black);
        Dimension ics = this.table.getIntercellSpacing();
        try {
            for (int r = 0; r < page.rowCount; ++r) {
                for (int c = 0; c < page.columnCount; ++c) {
                    int realColumn = page.columnOffset + c;
                    int realRow = page.rowOffset + r;
                    if (realColumn >= this.table.getColumnCount() || realRow >= this.table.getRowCount()) continue;
                    TableColumn column = this.table.getColumnModel().getColumn(realColumn);
                    TableCellRenderer rend = this.table.getCellRenderer(realRow, realColumn);
                    Object o = this.table.getValueAt(realRow, realColumn);
                    Component comp = rend.getTableCellRendererComponent(this.table, o, false, false, realRow, realColumn);
                    Dimension size = comp.getPreferredSize();
                    Rectangle oldRect = comp.getBounds();
                    Dimension oldDim = comp.getSize();
                    size.setSize(column.getPreferredWidth(), this.table.getRowHeight(realRow));
                    comp.setBounds(0, 0, size.width, size.height);
                    comp.setSize(size);
                    comp.validate();
                    Graphics2D cmpGraphics = (Graphics2D)g.create(cX + 1, cY + 1, size.width - 1, size.height - 1);
                    cX += size.width + ics.width / 2;
                    comp.paint(cmpGraphics);
                    comp.setBounds(oldRect);
                    comp.setSize(oldDim);
                    comp.validate();
                }
                cX = page.margin / 2;
                cY += this.table.getRowHeight(page.rowOffset + r) + ics.height;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        g.translate(0, -yOffset);
    }

    private int[] getRowSet(int pageHieght) {
        TableModel mdl = this.table.getModel();
        int[] rowDivisions = new int[]{};
        int currentHieght = 0;
        int setCount = 0;
        int margin = this.table.getRowMargin();
        int rowCount = this.table.getRowCount();
        if (mdl instanceof EnhancedTableModel) {
            rowCount = ((EnhancedTableModel)mdl).getTrueRowCount();
        }
        for (int i = 0; i < rowCount; ++i) {
            int delta = this.table.getRowHeight(i) + margin;
            if ((currentHieght += delta) > pageHieght) {
                int[] temp = new int[rowDivisions.length + 1];
                System.arraycopy(rowDivisions, 0, temp, 0, rowDivisions.length);
                temp[temp.length - 1] = setCount;
                rowDivisions = temp;
                setCount = 1;
                currentHieght = delta;
                continue;
            }
            ++setCount;
        }
        if (setCount >= 1) {
            int[] temp = new int[rowDivisions.length + 1];
            System.arraycopy(rowDivisions, 0, temp, 0, rowDivisions.length);
            temp[temp.length - 1] = setCount;
            rowDivisions = temp;
        }
        return rowDivisions;
    }

    private void distrbuteWidths(int pageWidth, PageCfg page) {
        int margin = this.table.getIntercellSpacing().width;
        int currentWidth = 0;
        int maxColumn = 0;
        int length = page.columnCount;
        int offset = page.columnOffset;
        for (int i = 0; i < length; ++i) {
            TableColumn column = this.table.getColumnModel().getColumn(offset + i);
            int size = column.getPreferredWidth();
            maxColumn = Math.max(size, maxColumn);
            if ((currentWidth += size + margin) <= pageWidth) continue;
            return;
        }
        int residual = pageWidth - currentWidth;
        int avgResid = residual / length;
        currentWidth = 0;
        for (int i = 0; i < length; ++i) {
            TableColumn column = this.table.getColumnModel().getColumn(offset + i);
            int size = column.getPreferredWidth();
            column.setPreferredWidth(size + avgResid);
            currentWidth += size + avgResid;
        }
        page.margin = residual = pageWidth - currentWidth;
        page.realWidth = currentWidth;
    }

    private int getHeaderHeight() {
        TableModel mdl = this.table.getModel();
        int headerHieght = 0;
        int r = -1;
        for (int i = 0; i < mdl.getColumnCount(); ++i) {
            TableColumn column = this.table.getColumnModel().getColumn(i);
            TableCellRenderer rndr = column.getHeaderRenderer();
            if (rndr == null) {
                rndr = this.table.getTableHeader().getDefaultRenderer();
            }
            Object o = column.getHeaderValue();
            Component comp = rndr.getTableCellRendererComponent(this.table, o, false, false, r, i);
            Dimension size = comp.getPreferredSize();
            size.setSize(column.getPreferredWidth(), size.height);
            comp.setBounds(0, 0, size.width, size.height);
            comp.setSize(size.width, size.height);
            headerHieght = Math.max(headerHieght, size.height);
        }
        return headerHieght;
    }

    private int[] getColumnSet(int pageWidth) {
        int[] columnSets = new int[]{};
        int columnCount = this.table.getColumnCount();
        int margin = this.table.getIntercellSpacing().width;
        int currentWidth = 0;
        int setCount = 0;
        for (int i = 0; i < columnCount; ++i) {
            TableColumn column = this.table.getColumnModel().getColumn(i);
            int size = column.getPreferredWidth() + margin;
            if ((currentWidth += size) > pageWidth) {
                int[] temp = new int[columnSets.length + 1];
                System.arraycopy(columnSets, 0, temp, 0, columnSets.length);
                temp[temp.length - 1] = setCount;
                columnSets = temp;
                setCount = 1;
                currentWidth = size;
                continue;
            }
            ++setCount;
        }
        if (setCount >= 1) {
            int[] temp = new int[columnSets.length + 1];
            System.arraycopy(columnSets, 0, temp, 0, columnSets.length);
            temp[temp.length - 1] = setCount;
            columnSets = temp;
        }
        return columnSets;
    }

    private static class PageCfg {
        int columnOffset = 0;
        int columnCount = 0;
        int rowOffset = 0;
        int rowCount = 0;
        int margin = 0;
        int realWidth = 0;

        private PageCfg() {
        }
    }
}

