/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.sql.DriverPropertyInfo;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.isqlviewer.core.PluginFactory;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.TableFilter;
import org.isqlviewer.core.model.DriverPropertyTableModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.swing.ITable;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.UserPreferences;

public final class TableFilterEditor
extends JSplitPane {
    public static final String KEY_SES_EXPORT_FILTER = "session.export-selection";
    public static final String KEY_SES_IMPORT_FILTER = "session.import-selection";
    public static final int FILTER_IMPORT = 0;
    public static final int FILTER_EXPORT = 1;
    private PluginFactory factory = SystemConfig.getInstance().getPluginFactory();
    private UserPreferences preferences = SystemConfig.getInstance().getPreferences();
    private Object filterDataType = new Object();
    private int type = 0;
    private int lastSelection = -1;
    private boolean isChanging = false;
    private DriverPropertyTableModel mdlProperties = new DriverPropertyTableModel();
    private DefaultListModel mdlFilters = new DefaultListModel();
    private JList jlsFilters = new JList(this.mdlFilters);
    private ITable tabProperties = new ITable(this.mdlProperties);
    private JTextArea txtDescription = new JTextArea();
    private JSplitPane jspConfigSplit = new JSplitPane(0, true);
    private JScrollPane jspProperties = new JScrollPane(this.tabProperties);
    private JScrollPane jspFilters = new JScrollPane(this.jlsFilters);
    private JScrollPane jspDescription = new JScrollPane(this.txtDescription);
    private FilterSupport filterSupport = new FilterSupport();
    private TableFilter currentFilter;
    private DatabaseConnection dbc = null;
    static /* synthetic */ Class array$Ljava$lang$String;

    public TableFilterEditor(int filter, DatabaseConnection dbc) {
        super(1, true);
        try {
            this.type = filter;
            this.dbc = dbc;
            this.initUI();
            this.setPreferredSize(new Dimension(512, 348));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setSelectedFilterIndex(int index) {
        this.jlsFilters.setSelectedIndex(index);
        this.changeFilter(index);
    }

    public int getSelectedFilterIndex() {
        return this.jlsFilters.getSelectedIndex();
    }

    public TableFilter getSelectedFilter() {
        this.validateFilter(this.lastSelection);
        return this.currentFilter;
    }

    public void setFilterContent(Object cxt) {
        this.filterDataType = cxt;
        this.loadFilters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object[] filters = this.mdlFilters.toArray();
        for (int i = 0; i < filters.length; ++i) {
            TableFilter filter = (TableFilter)filters[i];
            filter.setDatabaseConnection(null);
            try {
                filter.destroy();
                continue;
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
                continue;
            }
            finally {
                filter = null;
            }
        }
    }

    private void validateFilter(int index) {
        if (index < 0) {
            return;
        }
        this.currentFilter = (TableFilter)this.mdlFilters.get(index);
        if (this.currentFilter != null) {
            this.tabProperties.editingCanceled(new ChangeEvent(this.tabProperties));
        }
    }

    private void loadFilters() {
        this.mdlFilters.clear();
        Collection filters = this.factory.createPluginsForType(1);
        Iterator itr = filters.iterator();
        Preferences rootPreferences = this.preferences.toPreferences();
        while (itr.hasNext()) {
            TableFilter next = (TableFilter)itr.next();
            String nodename = "filters/{0}/{1}";
            nodename = MessageFormat.format(nodename, next.getName(), TableFilterEditor.stringForType(this.type));
            next.initialize(this.type, rootPreferences.node(nodename));
            next.setDatabaseConnection(this.dbc);
            boolean supported = next.isModeSupported(this.type);
            if (supported && this.type == 1) {
                supported = next.canFilter(this.type, this.filterDataType);
            }
            if (!supported) continue;
            this.mdlFilters.addElement(next);
        }
    }

    private static String stringForType(int modetype) {
        switch (modetype) {
            case 1: {
                return "export";
            }
            case 0: {
                return "import";
            }
        }
        return "unknown";
    }

    private void changeFilter(int row) {
        if (this.lastSelection == row) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.isChanging = true;
        try {
            if (this.lastSelection >= 0) {
                this.validateFilter(this.lastSelection);
            }
            this.currentFilter = (TableFilter)this.mdlFilters.get(row);
            DriverPropertyInfo[] p = this.currentFilter.getParameters(this.type);
            this.mdlProperties.setData(p);
            this.mdlProperties.setProperties(this.currentFilter.getConfiguration(this.type));
            this.tabProperties.refreshSorted();
            this.tabProperties.clearSelection();
            this.tabProperties.setEnabled(true);
            this.tabProperties.getSelectionModel().setSelectionInterval(0, 0);
            BasicUtilities.optimizeTableView(this.tabProperties);
            this.setDividerLocation(this.jlsFilters.getPreferredSize().width + 2 * this.getDividerSize() + 1);
            this.jspConfigSplit.setDividerLocation(0.75);
            this.lastSelection = row;
        }
        catch (Throwable t) {
            BasicUtilities.beep();
            BasicUtilities.HandleException(t, "TableFilterEditor::changeFilter(" + row + ")");
        }
        this.isChanging = false;
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void initUI() {
        this.tabProperties.setSelectionToggleEnabled(false);
        this.tabProperties.setModel(this.mdlProperties);
        this.tabProperties.setSelectionMode(0);
        this.tabProperties.setRowSelectionAllowed(true);
        this.tabProperties.setColumnSelectionAllowed(false);
        this.tabProperties.getTableHeader().setReorderingAllowed(false);
        this.tabProperties.getSelectionModel().addListSelectionListener(this.filterSupport);
        this.tabProperties.setDefaultEditor(array$Ljava$lang$String == null ? (array$Ljava$lang$String = TableFilterEditor.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, this.mdlProperties.getChoiceEditor());
        this.txtDescription.setRows(3);
        this.txtDescription.setEditable(false);
        this.txtDescription.setEnabled(false);
        this.txtDescription.setLineWrap(true);
        this.txtDescription.setWrapStyleWord(true);
        this.txtDescription.setDisabledTextColor(Color.black);
        this.jlsFilters.setCellRenderer(this.filterSupport);
        this.jlsFilters.setSelectionMode(0);
        this.jlsFilters.addListSelectionListener(this.filterSupport);
        this.mdlProperties.setToolTipsEnabled(false);
        this.mdlProperties.addTableModelListener(this.filterSupport);
        this.jspConfigSplit.setTopComponent(this.jspProperties);
        this.jspConfigSplit.setBottomComponent(this.jspDescription);
        this.setLeftComponent(this.jspFilters);
        this.setRightComponent(this.jspConfigSplit);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.jspConfigSplit.setBorder(BorderFactory.createEmptyBorder());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FilterSupport
    extends DefaultListCellRenderer
    implements TableModelListener,
    ListSelectionListener {
        private FilterSupport() {
        }

        public void tableChanged(TableModelEvent e) {
            if (TableFilterEditor.this.isChanging) {
                return;
            }
            int row = e.getFirstRow();
            switch (e.getType()) {
                case 0: {
                    String property = (String)TableFilterEditor.this.mdlProperties.getValueAt(row, 1);
                    String value = (String)TableFilterEditor.this.mdlProperties.getValueAt(row, 2);
                    try {
                        Preferences p = TableFilterEditor.this.currentFilter.getConfiguration(TableFilterEditor.this.type);
                        p.put(property, value);
                        break;
                    }
                    catch (Throwable t) {
                        BasicUtilities.HandleException(t);
                        BasicUtilities.beep();
                    }
                }
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (e.getSource() == TableFilterEditor.this.jlsFilters) {
                int index = TableFilterEditor.this.jlsFilters.getSelectedIndex();
                String key = null;
                key = TableFilterEditor.this.type == 0 ? TableFilterEditor.KEY_SES_IMPORT_FILTER : TableFilterEditor.KEY_SES_EXPORT_FILTER;
                SystemConfig.getInstance().getPreferences().putInt(key, index);
                TableFilterEditor.this.changeFilter(index);
            } else {
                int row = TableFilterEditor.this.tabProperties.getSelectedRow();
                if (row >= 0) {
                    TableFilterEditor.this.txtDescription.setText(((TableFilterEditor)TableFilterEditor.this).mdlProperties.getPropertyInfo((int)row).description);
                } else {
                    TableFilterEditor.this.txtDescription.setText("");
                }
            }
        }

        public Component getListCellRendererComponent(JList l, Object o, int r, boolean f, boolean s) {
            super.getListCellRendererComponent((JList<?>)l, o, r, f, s);
            try {
                if (o instanceof TableFilter) {
                    TableFilter filter = (TableFilter)o;
                    this.setText(filter.getName());
                    this.setIcon(filter.getUserIcon());
                    this.setToolTipText(filter.getDescription());
                } else {
                    this.setIcon(null);
                    this.setText(o == null ? "null" : o.toString());
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            return this;
        }
    }
}

