/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.UserPreferences;

public final class SimpleTextEditor
extends JComponent {
    private JEditorPane editor = new JEditorPane("text/plain", "");
    private JLabel lblSrc = new JLabel("");
    private JLabel lblInfo = new JLabel("");
    private JLabel lblCaret = new JLabel("");
    private JPanel statusBar = new JPanel(new GridBagLayout());
    private File file = null;
    private NumberFormat caretFormat = NumberFormat.getIntegerInstance();
    private TextActionHandler textActionHandler = new TextActionHandler();
    boolean isModified = false;
    private UndoManager undo = new UndoManager();

    public SimpleTextEditor(File f, String info) {
        this.initUI();
        this.setFile(f);
        this.setXtraInfo(info);
        this.caretFormat.setMinimumIntegerDigits(3);
    }

    public void requestFocus() {
        this.editor.requestFocus();
    }

    public void reload() {
        try {
            this.editor.setPage(this.file.toURL());
            this.editor.getDocument().addDocumentListener(this.textActionHandler);
            this.editor.getDocument().addUndoableEditListener(this.textActionHandler);
            this.editor.setEditable(this.file.canRead());
            this.editor.setCaretPosition(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isModified = false;
    }

    protected void finalize() {
        BasicUtilities.unlocalizeTextComponent(this.editor, this.undo);
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        Border border = BorderFactory.createLineBorder(this.lblSrc.getForeground());
        this.lblSrc.setBorder(border);
        this.lblInfo.setBorder(border);
        this.lblCaret.setBorder(border);
        Insets ins = new Insets(1, 1, 1, 1);
        this.lblCaret.setHorizontalAlignment(0);
        this.statusBar.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, ins, 1, 1));
        this.statusBar.add((Component)this.lblSrc, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, ins, 1, 1));
        this.statusBar.add((Component)this.lblInfo, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, ins, 1, 1));
        this.statusBar.add((Component)this.lblCaret, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, ins, 1, 1));
        JScrollPane jsp = new JScrollPane(this.editor);
        jsp.setVerticalScrollBarPolicy(22);
        jsp.setHorizontalScrollBarPolicy(32);
        this.add((Component)jsp, "Center");
        this.add((Component)this.statusBar, "South");
        this.statusBar.revalidate();
        this.editor.addCaretListener(this.textActionHandler);
        BasicUtilities.localizeTextComponent(this.editor, this.undo);
    }

    public void setXtraInfo(String info) {
        this.lblInfo.setText(" " + info + " ");
    }

    public String getXtraInfo() {
        return this.lblInfo.getText().trim();
    }

    public String getText() {
        return this.editor.getText();
    }

    public void setFile(File f) {
        this.file = f;
        this.lblSrc.setText(" ".concat(f.getName().concat(" ")));
        this.reload();
    }

    public File getFile() {
        return this.file;
    }

    public boolean isModified() {
        return this.isModified;
    }

    private class TextActionHandler
    implements CaretListener,
    UndoableEditListener,
    DocumentListener {
        private UserPreferences prefs = SystemConfig.getInstance().getPreferences();

        private TextActionHandler() {
        }

        public void insertUpdate(DocumentEvent parm1) {
            if (!SimpleTextEditor.this.isModified) {
                SimpleTextEditor.this.isModified = true;
            }
        }

        public void removeUpdate(DocumentEvent parm1) {
            if (!SimpleTextEditor.this.isModified) {
                SimpleTextEditor.this.isModified = true;
            }
        }

        public void changedUpdate(DocumentEvent parm1) {
            if (!SimpleTextEditor.this.isModified) {
                SimpleTextEditor.this.isModified = true;
            }
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            if (e == null || e.getEdit() == null) {
                return;
            }
            UndoableEdit edit = e.getEdit();
            String name = edit.getPresentationName();
            if (name != null && edit.canUndo()) {
                if (name.indexOf("style") < 0) {
                    SimpleTextEditor.this.undo.addEdit(e.getEdit());
                } else {
                    edit.die();
                }
            } else {
                edit.die();
            }
        }

        public void caretUpdate(CaretEvent e) {
            Object src = e == null ? SimpleTextEditor.this.editor : e.getSource();
            int dot = e == null ? SimpleTextEditor.this.editor.getCaretPosition() : e.getDot();
            try {
                if (src instanceof JTextComponent) {
                    int row = 0;
                    int col = 0;
                    JTextComponent txt = (JTextComponent)src;
                    row = BasicUtilities.getCaretRow(dot, txt) + 1;
                    col = BasicUtilities.getCaretCol(dot, txt) + 1;
                    String str = SimpleTextEditor.this.caretFormat.format(row).concat(" : ").concat(SimpleTextEditor.this.caretFormat.format(col));
                    if (this.prefs.getBoolean("editor.caretoffset-enabled")) {
                        str = str.concat(", ").concat(SimpleTextEditor.this.caretFormat.format(dot + 1));
                    }
                    SimpleTextEditor.this.lblCaret.setText(" ".concat(str).concat(" "));
                }
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
            }
        }
    }
}

