/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.ColumnMetaData;

public class OrderEditor
extends JComponent {
    public static final int ACTION_ADD = 0;
    public static final int ACTION_DELETE = 1;
    public static final int STYLE_ASCENDING = 0;
    public static final int STYLE_DESCENDING = 1;
    private DefaultComboBoxModel mdlColumn = new DefaultComboBoxModel<Object>(new Object[0]);
    private DefaultComboBoxModel mdlStyle = new DefaultComboBoxModel<Object>(new Object[]{BasicUtilities.getString("QBuild_Natural_Ascending"), BasicUtilities.getString("QBuild_Natural_Descending")});
    private JComboBox jcbColumn = new JComboBox(this.mdlColumn);
    private JComboBox jcbStyle = new JComboBox(this.mdlStyle);
    private JButton btnAdd = new JButton(BasicUtilities.getString("QBuild_Natural_Plus"));
    private JButton btnDel = new JButton(BasicUtilities.getString("QBuild_Natural_Minus"));
    private TreeMap meta = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private ArrayList listenerList = null;
    private ActionHandler actionHandler = new ActionHandler();

    public OrderEditor(Map metaMap) {
        this.setLayout(new GridBagLayout());
        this.btnAdd.setMargin(new Insets(0, 0, 0, 0));
        this.btnDel.setMargin(new Insets(0, 0, 0, 0));
        this.btnDel.setPreferredSize(this.btnDel.getMinimumSize());
        this.btnAdd.setPreferredSize(this.btnAdd.getMinimumSize());
        this.add((Component)this.jcbColumn, OrderEditor.constrain(0, 0.0, 17, 2));
        this.add(Box.createHorizontalStrut(8), OrderEditor.constrain(1, 0.0, 17, 0));
        this.add((Component)this.jcbStyle, OrderEditor.constrain(2, 0.0, 17, 0));
        this.add(Box.createHorizontalGlue(), OrderEditor.constrain(3, 1.0, 17, 2));
        this.add((Component)this.btnDel, OrderEditor.constrain(4, 0.0, 17, 0));
        this.add((Component)this.btnAdd, OrderEditor.constrain(5, 0.0, 17, 0));
        this.jcbColumn.addActionListener(this.actionHandler);
        this.jcbStyle.addActionListener(this.actionHandler);
        this.btnDel.addActionListener(this.actionHandler);
        this.btnAdd.addActionListener(this.actionHandler);
        this.updateMetamap(metaMap);
        this.validateTree();
    }

    public int getSelectedStyle() {
        return this.jcbStyle.getSelectedIndex();
    }

    public ColumnMetaData getSelectedColumn() {
        Object key = this.jcbColumn.getSelectedItem();
        return (ColumnMetaData)this.meta.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMetamap(Map data) {
        TreeMap treeMap = this.meta;
        synchronized (treeMap) {
            this.meta.clear();
            if (data != null) {
                this.meta.putAll(data);
            }
        }
        this.loadMap();
    }

    public void setAddEnabled(boolean f) {
        this.btnAdd.setEnabled(f);
    }

    public void setDeleteEnabled(boolean f) {
        this.btnDel.setEnabled(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionListener(ActionListener l) {
        if (this.listenerList != null && this.listenerList.contains(l)) {
            ArrayList arrayList = this.listenerList;
            synchronized (arrayList) {
                this.listenerList.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(ActionListener l) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList(1);
        }
        if (!this.listenerList.contains(l)) {
            ArrayList arrayList = this.listenerList;
            synchronized (arrayList) {
                this.listenerList.add(l);
            }
        }
    }

    private void loadMap() {
        Iterator itr = this.meta.keySet().iterator();
        this.mdlColumn.removeAllElements();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            this.mdlColumn.addElement(key);
        }
    }

    private static Object constrain(int x, double wieght, int anchor, int fill) {
        Insets insets = new Insets(1, 1, 1, 1);
        return new GridBagConstraints(x, 0, 1, 1, wieght, 0.0, anchor, fill, insets, 1, 1);
    }

    protected void forwardEvent(ActionEvent e) {
        if (this.listenerList != null) {
            Iterator itr = this.listenerList.iterator();
            Object src = e.getSource();
            int id = src == this.btnAdd ? 0 : 1;
            ActionEvent evt = new ActionEvent(this, id, e.getActionCommand(), e.getModifiers());
            while (itr.hasNext()) {
                ActionListener l = (ActionListener)itr.next();
                try {
                    l.actionPerformed(evt);
                }
                catch (Throwable t) {}
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.jcbColumn.setEnabled(enabled);
        this.jcbStyle.setEnabled(enabled);
        this.btnAdd.setEnabled(enabled);
        this.btnDel.setEnabled(enabled);
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent ae) {
            Object src = ae.getSource();
            if (src == OrderEditor.this.btnAdd || src == OrderEditor.this.btnDel) {
                OrderEditor.this.forwardEvent(ae);
            }
        }
    }
}

