/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class JDrawer
extends JWindow
implements SwingConstants {
    protected ArrayList changeListeners = null;
    protected Window parentWindow = null;
    protected FrameListener eventHandler = new FrameListener();
    protected ToggleAnimation animator = new ToggleAnimation();
    protected boolean quickToggle = false;
    protected JPanel contentPane = new JPanel(new BorderLayout());
    protected int preferredLoc = 3;
    protected DrawerHandle handleEast = new DrawerHandle(6, true);
    protected DrawerHandle handleWest = new DrawerHandle(6, true);
    protected DrawerHandle handleNorth = new DrawerHandle(6, false);
    protected DrawerHandle handleSouth = new DrawerHandle(6, false);
    protected JComponent userContent = new JPanel(new BorderLayout());
    protected Border contentBdr = BorderFactory.createEtchedBorder(1);
    protected DragHandler dndHandler = new DragHandler();
    protected Dimension userSize = null;
    private ChangeEvent toggleEvent = new ChangeEvent(this);

    public JDrawer() {
        this(null, 3, false);
    }

    public JDrawer(Window owner) {
        this(owner, 3, false);
    }

    public JDrawer(Window owner, int location) {
        this(owner, location, false);
    }

    public JDrawer(Window owner, int location, boolean isVisible) {
        super(owner);
        this.contentPane.add((Component)this.handleWest, "West");
        this.contentPane.add((Component)this.handleEast, "East");
        this.contentPane.add((Component)this.handleSouth, "South");
        this.contentPane.add((Component)this.handleNorth, "North");
        this.contentPane.add((Component)this.userContent, "Center");
        Border bdr = BorderFactory.createLineBorder(this.getForeground(), 1);
        this.contentPane.setBorder(bdr);
        this.userContent.setBorder(this.contentBdr);
        this.setVisible(isVisible);
        super.setContentPane(this.contentPane);
        this.setParentWindow(owner);
        this.setPreferredLocation(location);
        this.pack();
    }

    public synchronized void toggle() {
        if (!this.animator.isToggling()) {
            if (this.quickToggle) {
                this.setVisible(!this.isVisible());
                this.fireStateChanged(this.toggleEvent);
            } else {
                SwingUtilities.invokeLater(this.animator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener cl) {
        if (cl == null) {
            return;
        }
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList();
        }
        if (!this.changeListeners.contains(cl)) {
            ArrayList arrayList = this.changeListeners;
            synchronized (arrayList) {
                this.changeListeners.add(cl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener cl) {
        if (cl == null || this.changeListeners == null) {
            return;
        }
        if (this.changeListeners.contains(cl)) {
            ArrayList arrayList = this.changeListeners;
            synchronized (arrayList) {
                this.changeListeners.remove(cl);
            }
        }
    }

    public boolean isToggled() {
        return this.isVisible();
    }

    public Window getParentWindow() {
        return this.parentWindow;
    }

    public void setPreferredLocation(int location) {
        this.clearHandleListeners(this.preferredLoc, location);
        this.preferredLoc = location;
        this.updateBounds();
    }

    public int getPreferredLocation() {
        return this.preferredLoc;
    }

    public void setParentWindow(Window parentWindow) {
        if (parentWindow == null) {
            throw new NullPointerException();
        }
        if (this.parentWindow != null) {
            this.parentWindow.removeComponentListener(this.eventHandler);
            this.parentWindow.removeWindowListener(this.eventHandler);
        }
        this.parentWindow = parentWindow;
        this.parentWindow.addComponentListener(this.eventHandler);
        this.parentWindow.addWindowListener(this.eventHandler);
        this.updateBounds();
    }

    public void setQuickToggleEnabled(boolean f) {
        this.quickToggle = f;
    }

    public Container getContentPane() {
        return this.userContent;
    }

    public boolean getFocusableWindowState() {
        return false;
    }

    public void setContentPane(Container contentPane) {
        contentPane.remove(this.userContent);
        this.userContent.setBorder(null);
        if (contentPane != null) {
            contentPane.add((Component)contentPane, "Center");
            this.userContent = (JComponent)contentPane;
            this.userContent.setBorder(this.contentBdr);
        }
    }

    protected void clearHandleListeners(int old, int loc) {
        switch (old) {
            case 1: {
                this.handleNorth.removeMouseListener(this.dndHandler);
                this.handleNorth.removeMouseMotionListener(this.dndHandler);
                this.contentPane.add((Component)this.handleSouth, "South");
                break;
            }
            case 5: {
                this.handleSouth.removeMouseListener(this.dndHandler);
                this.handleSouth.removeMouseMotionListener(this.dndHandler);
                this.contentPane.add((Component)this.handleNorth, "North");
                break;
            }
            case 2: 
            case 7: {
                this.handleWest.removeMouseListener(this.dndHandler);
                this.handleWest.removeMouseMotionListener(this.dndHandler);
                this.contentPane.add((Component)this.handleEast, "East");
                break;
            }
            case 3: 
            case 4: {
                this.handleEast.removeMouseListener(this.dndHandler);
                this.handleEast.removeMouseMotionListener(this.dndHandler);
                this.contentPane.add((Component)this.handleWest, "West");
            }
        }
        switch (loc) {
            case 1: {
                this.handleNorth.addMouseListener(this.dndHandler);
                this.handleNorth.addMouseMotionListener(this.dndHandler);
                this.contentPane.remove(this.handleSouth);
                break;
            }
            case 5: {
                this.handleSouth.addMouseListener(this.dndHandler);
                this.handleSouth.addMouseMotionListener(this.dndHandler);
                this.contentPane.remove(this.handleNorth);
                break;
            }
            case 2: 
            case 7: {
                this.handleWest.addMouseListener(this.dndHandler);
                this.handleWest.addMouseMotionListener(this.dndHandler);
                this.contentPane.remove(this.handleEast);
                break;
            }
            case 3: 
            case 4: {
                this.handleEast.addMouseListener(this.dndHandler);
                this.handleEast.addMouseMotionListener(this.dndHandler);
                this.contentPane.remove(this.handleWest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStateChanged(ChangeEvent e) {
        if (this.changeListeners == null) {
            return;
        }
        ArrayList arrayList = this.changeListeners;
        synchronized (arrayList) {
            Iterator itr = this.changeListeners.iterator();
            while (itr.hasNext()) {
                ChangeListener l = (ChangeListener)itr.next();
                try {
                    l.stateChanged(e);
                }
                catch (Throwable t) {}
            }
        }
    }

    protected void updateBounds() {
        if (!this.parentWindow.isShowing()) {
            return;
        }
        int hieght = 0;
        int width = 0;
        int gutter = 0;
        Rectangle r = this.parentWindow.getBounds();
        switch (this.preferredLoc) {
            case 1: {
                hieght = this.isVisible() ? (this.userSize == null ? this.getPreferredSize().height : this.userSize.height) : 0;
                width = r.width;
                gutter = width / 20;
                this.setBounds(r.x + gutter, r.y - hieght, r.width - 2 * gutter, hieght);
                break;
            }
            case 5: {
                hieght = this.isVisible() ? (this.userSize == null ? this.getPreferredSize().height : this.userSize.height) : 0;
                width = r.width;
                gutter = width / 20;
                this.setBounds(r.x + gutter, r.y + r.height, r.width - 2 * gutter, hieght);
                break;
            }
            case 2: 
            case 7: {
                hieght = r.height;
                width = this.isVisible() ? (this.userSize == null ? this.getPreferredSize().width : this.userSize.width) : 0;
                gutter = hieght / 20;
                this.setBounds(r.x - width, r.y + gutter, width, hieght - 2 * gutter);
                break;
            }
            case 3: 
            case 4: {
                hieght = r.height;
                width = this.isVisible() ? (this.userSize == null ? this.getPreferredSize().width : this.userSize.width) : 0;
                gutter = hieght / 20;
                this.setBounds(r.x + r.width, r.y + gutter, width, hieght - 2 * gutter);
                break;
            }
        }
        if (this.isVisible()) {
            this.validateTree();
        }
    }

    protected boolean canExpand(int location) {
        switch (location) {
            case 1: {
                return this.canExpandNorth();
            }
            case 5: {
                return this.canExpandSouth();
            }
            case 2: 
            case 7: {
                return this.canExpandWest();
            }
            case 3: 
            case 4: {
                return this.canExpandWest();
            }
        }
        return false;
    }

    protected Component getActiveHandle() {
        switch (this.preferredLoc) {
            case 1: {
                return this.handleNorth;
            }
            case 5: {
                return this.handleSouth;
            }
            case 2: 
            case 7: {
                return this.handleWest;
            }
            case 3: 
            case 4: {
                return this.handleEast;
            }
        }
        return null;
    }

    private boolean canExpandEast() {
        Rectangle r = this.parentWindow.getBounds();
        int farthestX = r.x + r.width + (this.userSize != null ? this.userSize.width : this.contentPane.getPreferredSize().width);
        Toolkit tk = Toolkit.getDefaultToolkit();
        int maxWidth = tk.getScreenSize().width;
        return farthestX < maxWidth;
    }

    private boolean canExpandSouth() {
        Rectangle r = this.parentWindow.getBounds();
        int farthestY = r.y + r.height + (this.userSize != null ? this.userSize.height : this.contentPane.getPreferredSize().height);
        Toolkit tk = Toolkit.getDefaultToolkit();
        int maxHeight = tk.getScreenSize().height;
        return farthestY < maxHeight;
    }

    private boolean canExpandNorth() {
        Rectangle r = this.parentWindow.getBounds();
        int farthestY = r.y - (this.userSize != null ? this.userSize.height : this.contentPane.getPreferredSize().height);
        return farthestY >= 0;
    }

    private boolean canExpandWest() {
        Rectangle r = this.parentWindow.getBounds();
        int farthestX = r.x - (this.userSize != null ? this.userSize.width : this.contentPane.getPreferredSize().width);
        return farthestX >= 0;
    }

    private class ToggleAnimation
    implements Runnable {
        private boolean isToggling = false;

        private ToggleAnimation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean isToggling() {
            ToggleAnimation toggleAnimation = this;
            synchronized (toggleAnimation) {
                return this.isToggling;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void toggleSouth(boolean isClosing) {
            if (!isClosing && !JDrawer.this.canExpandSouth() && JDrawer.this.canExpandNorth()) {
                JDrawer.this.setVisible(false);
                JDrawer.this.setPreferredLocation(1);
                JDrawer.this.setVisible(true);
                this.toggleNorth(isClosing);
            }
            int height = JDrawer.this.getSize().height;
            int width = JDrawer.this.getSize().width;
            boolean flag = isClosing ? height > 0 : height < JDrawer.this.getPreferredSize().height;
            long delta = JDrawer.this.getPreferredSize().height / 10;
            while (flag) {
                height = isClosing ? (int)((long)height - delta) : (int)((long)height + delta);
                boolean bl = isClosing ? height != 0 : (flag = height < JDrawer.this.getPreferredSize().height);
                if (height < 0) {
                    flag = false;
                    height = 0;
                }
                JDrawer jDrawer = JDrawer.this;
                synchronized (jDrawer) {
                    JDrawer.this.setSize(width, height);
                }
                if (!flag) continue;
                try {
                    Thread.sleep(2L);
                }
                catch (Throwable t) {
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void toggleNorth(boolean isClosing) {
            if (!isClosing && !JDrawer.this.canExpandNorth() && JDrawer.this.canExpandSouth()) {
                JDrawer.this.setVisible(false);
                JDrawer.this.setPreferredLocation(5);
                JDrawer.this.setVisible(true);
                this.toggleSouth(isClosing);
            }
            int height = JDrawer.this.getSize().height;
            int width = JDrawer.this.getSize().width;
            boolean flag = isClosing ? height > 0 : height < JDrawer.this.getPreferredSize().height;
            long delta = JDrawer.this.getPreferredSize().height / 10;
            while (flag) {
                height = isClosing ? (int)((long)height - delta) : (int)((long)height + delta);
                boolean bl = isClosing ? height != 0 : (flag = height < JDrawer.this.getPreferredSize().height);
                if (height < 0) {
                    flag = false;
                    height = 0;
                }
                Rectangle r = JDrawer.this.getBounds();
                JDrawer jDrawer = JDrawer.this;
                synchronized (jDrawer) {
                    JDrawer.this.setBounds(r.x, r.y + 3 * (isClosing ? 1 : -1), width, height);
                }
                if (!flag) continue;
                try {
                    Thread.sleep(2L);
                }
                catch (Throwable t) {
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void toggleWest(boolean isClosing) {
            if (!isClosing && !JDrawer.this.canExpandWest() && JDrawer.this.canExpandEast()) {
                JDrawer.this.setVisible(false);
                JDrawer.this.setPreferredLocation(3);
                JDrawer.this.setVisible(true);
                this.toggleEast(isClosing);
            }
            int height = JDrawer.this.getSize().height;
            int width = JDrawer.this.getSize().width;
            boolean flag = isClosing ? width > 0 : width < JDrawer.this.getPreferredSize().width;
            long delta = JDrawer.this.getPreferredSize().width / 10;
            while (flag) {
                width = isClosing ? (int)((long)width - delta) : (int)((long)width + delta);
                boolean bl = isClosing ? width != 0 : (flag = width < JDrawer.this.getPreferredSize().width);
                if (width < 0) {
                    flag = false;
                    width = 0;
                }
                Rectangle r = JDrawer.this.getBounds();
                JDrawer jDrawer = JDrawer.this;
                synchronized (jDrawer) {
                    JDrawer.this.setBounds(r.x + 3 * (isClosing ? 1 : -1), r.y, width, height);
                }
                if (!flag) continue;
                try {
                    Thread.sleep(2L);
                }
                catch (Throwable t) {
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void toggleEast(boolean isClosing) {
            if (!isClosing && !JDrawer.this.canExpandEast() && JDrawer.this.canExpandWest()) {
                JDrawer.this.setVisible(false);
                JDrawer.this.setPreferredLocation(7);
                JDrawer.this.setVisible(true);
                this.toggleWest(isClosing);
            }
            int height = JDrawer.this.getSize().height;
            int width = JDrawer.this.getSize().width;
            boolean flag = isClosing ? width > 0 : width < JDrawer.this.getPreferredSize().width;
            long delta = JDrawer.this.getPreferredSize().height / 10;
            while (flag) {
                width = isClosing ? (int)((long)width - delta) : (int)((long)width + delta);
                boolean bl = isClosing ? width != 0 : (flag = width < JDrawer.this.getPreferredSize().width);
                if (width < 0) {
                    flag = false;
                    width = 0;
                }
                JDrawer jDrawer = JDrawer.this;
                synchronized (jDrawer) {
                    JDrawer.this.setSize(width, height);
                }
                if (!flag) continue;
                try {
                    Thread.sleep(2L);
                }
                catch (Throwable t) {
                    return;
                }
            }
        }

        public void run() {
            this.isToggling = true;
            boolean isClosing = JDrawer.this.isVisible();
            JDrawer.this.setVisible(true);
            switch (JDrawer.this.preferredLoc) {
                case 1: {
                    this.toggleNorth(isClosing);
                    break;
                }
                case 5: {
                    this.toggleSouth(isClosing);
                    break;
                }
                case 2: 
                case 7: {
                    this.toggleWest(isClosing);
                    break;
                }
                case 3: 
                case 4: {
                    this.toggleEast(isClosing);
                    break;
                }
            }
            if (isClosing) {
                JDrawer.this.setVisible(false);
            }
            JDrawer.this.updateBounds();
            JDrawer.this.fireStateChanged(JDrawer.this.toggleEvent);
            this.isToggling = false;
        }
    }

    private static class DrawerHandle
    extends JComponent {
        private Dimension reqMin;
        private Dimension reqPref;
        private Dimension reqMax;

        public DrawerHandle(int width, boolean vertical) {
            this.reqMin = new Dimension(!vertical ? 0 : width, !vertical ? width : 0);
            this.reqPref = new Dimension(!vertical ? 0 : width, !vertical ? width : 0);
            this.reqMax = new Dimension(!vertical ? Integer.MAX_VALUE : width, !vertical ? width : Integer.MAX_VALUE);
        }

        public void changeShape(Dimension min, Dimension pref, Dimension max) {
            this.reqMin = min;
            this.reqPref = pref;
            this.reqMax = max;
            this.invalidate();
        }

        public Dimension getMinimumSize() {
            return this.reqMin;
        }

        public Dimension getPreferredSize() {
            return this.reqPref;
        }

        public Dimension getMaximumSize() {
            return this.reqMax;
        }
    }

    private class DragHandler
    extends MouseInputAdapter {
        private boolean toggleOnRelease = false;
        private boolean isDragging = false;
        private Dimension originalSize = null;

        private DragHandler() {
        }

        public void mouseEntered(MouseEvent e) {
            switch (JDrawer.this.preferredLoc) {
                case 1: 
                case 5: {
                    JDrawer.this.setCursor(Cursor.getPredefinedCursor(9));
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    JDrawer.this.setCursor(Cursor.getPredefinedCursor(11));
                }
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!this.isDragging) {
                JDrawer.this.setCursor(Cursor.getDefaultCursor());
            } else {
                this.mouseEntered(e);
            }
        }

        public void mouseDragged(MouseEvent e) {
            int ourX = e.getX();
            int ourY = e.getY();
            Rectangle old = JDrawer.this.getBounds();
            JDrawer.this.userContent.invalidate();
            JDrawer.this.validateTree();
            int minH = JDrawer.super.getContentPane().getMinimumSize().height;
            int minW = JDrawer.super.getContentPane().getMinimumSize().width;
            this.toggleOnRelease = false;
            this.isDragging = true;
            switch (JDrawer.this.preferredLoc) {
                case 1: {
                    int yoff = Math.abs(ourY);
                    if (ourY == 0) {
                        return;
                    }
                    if (ourY < 0) {
                        JDrawer.this.setBounds(old.x, old.y - yoff, old.width, old.height + yoff);
                    } else {
                        JDrawer.this.setBounds(old.x, old.y + yoff, old.width, old.height - yoff);
                    }
                    if (JDrawer.this.getBounds().height > minH) {
                        if (JDrawer.this.userSize != null) {
                            JDrawer.this.userSize.setSize(old.width, JDrawer.this.getBounds().height);
                            break;
                        }
                        JDrawer.this.userSize = new Dimension(old.width, JDrawer.this.getBounds().height);
                        break;
                    }
                    if (JDrawer.this.getBounds().height >= minH) break;
                    this.toggleOnRelease = true;
                    break;
                }
                case 5: {
                    if (ourY == 0) {
                        return;
                    }
                    if (ourY < 0) {
                        int height = old.height - Math.abs(ourY);
                        if (height < 0) {
                            height = 0;
                        }
                        JDrawer.this.setBounds(old.x, old.y, old.width, height);
                    } else {
                        JDrawer.this.setBounds(old.x, old.y, old.width, old.height + ourY);
                    }
                    if (JDrawer.this.getBounds().height > minH) {
                        if (JDrawer.this.userSize != null) {
                            JDrawer.this.userSize.setSize(old.width, JDrawer.this.getBounds().height);
                            break;
                        }
                        JDrawer.this.userSize = new Dimension(old.width, JDrawer.this.getBounds().height);
                        break;
                    }
                    if (JDrawer.this.getBounds().height >= minH) break;
                    this.toggleOnRelease = true;
                    break;
                }
                case 3: 
                case 4: {
                    if (ourX == 0 || this.toggleOnRelease) {
                        return;
                    }
                    if (ourX < 0) {
                        int width = old.width - Math.abs(ourX);
                        if (width < 0) {
                            width = 0;
                        }
                        JDrawer.this.setBounds(old.x, old.y, width, old.height);
                    } else {
                        JDrawer.this.setBounds(old.x, old.y, old.width + ourX, old.height);
                    }
                    if (JDrawer.this.getBounds().width > minW) {
                        if (JDrawer.this.userSize != null) {
                            JDrawer.this.userSize.setSize(JDrawer.this.getBounds().width, old.height);
                            break;
                        }
                        JDrawer.this.userSize = new Dimension(JDrawer.this.getBounds().width, old.height);
                        break;
                    }
                    if (JDrawer.this.getBounds().width >= minW) break;
                    this.toggleOnRelease = true;
                    break;
                }
                case 2: 
                case 7: {
                    int xoff = Math.abs(ourX);
                    if (ourX == 0 || this.toggleOnRelease) {
                        return;
                    }
                    if (ourX < 0) {
                        JDrawer.this.setBounds(old.x - xoff, old.y, old.width + xoff, old.height);
                    } else {
                        JDrawer.this.setBounds(old.x + xoff, old.y, old.width - xoff, old.height);
                    }
                    if (JDrawer.this.getBounds().width > minW) {
                        if (JDrawer.this.userSize != null) {
                            JDrawer.this.userSize.setSize(JDrawer.this.getBounds().width, old.height);
                            break;
                        }
                        JDrawer.this.userSize = new Dimension(JDrawer.this.getBounds().width, old.height);
                        break;
                    }
                    if (JDrawer.this.getBounds().width >= minW) break;
                    this.toggleOnRelease = true;
                }
            }
            JDrawer.this.getContentPane().invalidate();
            JDrawer.this.validateTree();
            e.consume();
        }

        public void mouseReleased(MouseEvent e) {
            if (this.toggleOnRelease) {
                JDrawer.this.toggle();
                JDrawer.this.userSize = this.originalSize;
            }
            this.originalSize = null;
            this.isDragging = false;
        }

        public void mousePressed(MouseEvent e) {
            this.originalSize = new Dimension(JDrawer.this.getBounds().width, JDrawer.this.getBounds().height);
        }
    }

    private class FrameListener
    extends ComponentAdapter
    implements WindowListener {
        protected boolean isToggled = false;

        private FrameListener() {
        }

        public void windowActivated(WindowEvent e) {
            if (!JDrawer.this.isEnabled()) {
                JDrawer.this.setEnabled(true);
            }
        }

        public void windowClosed(WindowEvent e) {
            Window window = e.getWindow();
            if (window != JDrawer.this) {
                JDrawer.this.dispatchEvent(new WindowEvent(JDrawer.this, e.getID()));
            }
        }

        public void windowClosing(WindowEvent e) {
            Window window = e.getWindow();
            if (window != JDrawer.this) {
                JDrawer.this.dispatchEvent(new WindowEvent(JDrawer.this, e.getID()));
            }
        }

        public void windowDeactivated(WindowEvent e) {
            JDialog dlg;
            Window other = e.getOppositeWindow();
            if (other instanceof JDialog && other != JDrawer.this.getParentWindow() && (dlg = (JDialog)other).isModal()) {
                JDrawer.this.setEnabled(false);
            }
        }

        public void windowDeiconified(WindowEvent e) {
            if (this.isToggled) {
                JDrawer.this.toggle();
            }
        }

        public void windowIconified(WindowEvent e) {
            this.isToggled = JDrawer.this.isToggled();
            if (this.isToggled) {
                JDrawer.this.setVisible(false);
            }
        }

        public void windowOpened(WindowEvent e) {
            JDrawer.this.updateBounds();
        }

        public void componentResized(ComponentEvent e) {
            JDrawer.this.updateBounds();
        }

        public void componentMoved(ComponentEvent e) {
            JDrawer.this.updateBounds();
        }

        public void componentHidden(ComponentEvent e) {
            JDrawer.this.setVisible(false);
        }

        public void componentShown(ComponentEvent e) {
            JDrawer.this.updateBounds();
        }
    }
}

