/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.action.CoreAction;
import org.isqlviewer.swing.AbstractItemAction;
import org.isqlviewer.swing.ActionManager;
import org.isqlviewer.swing.JCheckBoxAction;
import org.isqlviewer.util.BasicUtilities;

public abstract class ActionToolBar
extends JToolBar
implements ItemListener,
PreferenceChangeListener {
    private static final Insets buttonInsets = BasicUtilities.isMac() ? new Insets(2, 3, 2, 3) : new Insets(1, 1, 1, 1);
    protected ArrayList actionList = new ArrayList(1);
    protected ActionManager manager;

    public static ActionToolBar createNullInstance() {
        return new NullActionToolbar();
    }

    protected ActionToolBar() {
        this((ActionManager)null);
    }

    protected ActionToolBar(ActionManager manager) {
        this.manager = manager;
        this.addButtons();
        SystemConfig.getInstance().getPreferences().addPreferenceChangeListener(this);
        if (manager != null) {
            manager.addItemListener(this);
        }
    }

    public void setActionEnabled(boolean enabled) {
        Iterator itr = this.actionList.iterator();
        while (itr.hasNext()) {
            Action action = (Action)itr.next();
            action.setEnabled(enabled);
        }
    }

    public JButton addButton(Action action) {
        if (action == null) {
            return null;
        }
        JButton button = this.add(action);
        this.configureButton(button, action);
        this.actionList.add(action);
        return button;
    }

    public Component add(Component comp) {
        if (comp instanceof AbstractButton) {
            this.configureButton((AbstractButton)comp, null);
        }
        return super.add(comp);
    }

    public void itemStateChanged(ItemEvent e) {
        JCheckBoxAction chkBox = (JCheckBoxAction)e.getItem();
        String action = chkBox.getValue("Name").toString().trim();
        String name = this.getName();
        boolean selected = chkBox.isSelected();
        if (action.equalsIgnoreCase(name)) {
            this.setVisible(selected);
            this.validateTree();
        }
    }

    public void preferenceChange(PreferenceChangeEvent event) {
        String key = event.getKey();
        if (key.equals("general.large-icons")) {
            this.updateIconSizes(this);
        }
    }

    protected void addToggleButton(AbstractItemAction a) {
        JToggleButton button = new JToggleButton(a);
        button.addItemListener(a);
        button.setSelected(a.isSelected());
        this.add(button);
        this.configureButton(button, a);
    }

    protected void addDropActionSupport(Component view, DataFlavor[] supported, int action) {
        view.setDropTarget(new DropTarget(view, new DropActionProxy(this.manager, supported, action)));
    }

    protected void configureButton(AbstractButton button, Action action) {
        if (action != null) {
            button.setActionCommand(action.getValue("ActionCommandKey").toString());
            button.setText("");
        }
        if (action instanceof CoreAction) {
            try {
                String s = (String)action.getValue("ICON_NAME");
                button.setIcon(BasicUtilities.loadToolbarIconResource(s));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        button.setAlignmentY(0.5f);
        button.setBorderPainted(!BasicUtilities.isMac());
        button.setFocusPainted(false);
        button.setMargin(buttonInsets);
        button.addMouseListener(this.manager);
    }

    protected ActionManager getManager() {
        return this.manager;
    }

    protected void toggleAction(AbstractButton btn, Action a) {
        btn.setIcon(BasicUtilities.loadToolbarIconResource(a.getValue("ICON_NAME").toString()));
        btn.setToolTipText(a.getValue("ShortDescription").toString());
        btn.setActionCommand(a.getValue("ActionCommandKey").toString());
    }

    protected abstract void processDropProxy(Transferable var1, int var2);

    protected void addButtons() {
    }

    protected void updateIconSizes(ActionToolBar tb) {
        int count = tb.getComponentCount();
        for (int i = 0; i < count; ++i) {
            AbstractButton btn;
            Component c = tb.getComponent(i);
            if (!(c instanceof AbstractButton) || (btn = (AbstractButton)c).getIcon() == null) continue;
            Action action = btn.getAction();
            if (action instanceof CoreAction) {
                try {
                    String s = (String)action.getValue("ICON_NAME");
                    btn.setIcon(BasicUtilities.loadToolbarIconResource(s));
                }
                catch (Exception e) {}
                continue;
            }
            String icon = btn.getName();
            if (icon.trim().length() < 1) continue;
            btn.setIcon(BasicUtilities.loadToolbarIconResource(icon));
        }
    }

    protected static class DropActionProxy
    extends DropTargetAdapter {
        private DataFlavor[] acceptable = new DataFlavor[0];
        private int actionIdentifier = Integer.MAX_VALUE;
        private ActionManager delegate = null;

        public void dragEnter(DropTargetDragEvent dtde) {
            List<DataFlavor> flavors = dtde.getCurrentDataFlavorsAsList();
            if (this.acceptable.length >= 1) {
                for (int i = 0; i < this.acceptable.length; ++i) {
                    if (!flavors.contains(this.acceptable[i])) continue;
                    dtde.acceptDrag(dtde.getSourceActions());
                    return;
                }
                dtde.rejectDrag();
            }
        }

        public DropActionProxy(ActionManager handler, DataFlavor[] allowed, int action) {
            this.acceptable = allowed == null ? new DataFlavor[]{} : allowed;
            this.actionIdentifier = action;
            this.delegate = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetDropEvent dtde) {
            boolean supported = false;
            for (int i = 0; i < this.acceptable.length; ++i) {
                if (!dtde.isDataFlavorSupported(this.acceptable[i])) continue;
                supported = true;
                break;
            }
            if (!supported) {
                dtde.rejectDrop();
                return;
            }
            dtde.acceptDrop(dtde.getDropAction());
            try {
                Transferable trx = dtde.getTransferable();
                ActionEvent event = new ActionEvent(trx, this.actionIdentifier, "dnd-proxy");
                this.delegate.forwardAction(event);
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
            }
            finally {
                dtde.dropComplete(true);
            }
        }
    }

    private static class NullActionToolbar
    extends ActionToolBar {
        public NullActionToolbar() {
            super((ActionManager)null);
        }

        protected void processDropProxy(Transferable data, int action) {
        }
    }
}

