/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import org.isqlviewer.swing.ActionManager;
import org.isqlviewer.util.BasicUtilities;

public abstract class ActionPanel
extends JPanel
implements ActionListener {
    private static final ActionManager shared = ActionManager.createDefaultInstance();
    private static final Thread sharedThread = new Thread((Runnable)shared, "shared-action");
    private ActionManager manager = null;
    private ActionListener delegate = new ActionDelegate(this);

    protected ActionPanel(ActionManager mgr) {
        if (mgr == null) {
            throw new NullPointerException();
        }
        this.manager = mgr;
        this.manager.addActionListener(this.delegate);
        if (!sharedThread.isAlive()) {
            sharedThread.setDaemon(true);
            sharedThread.start();
        }
    }

    protected ActionPanel() {
        this(shared);
    }

    protected abstract void processActionEvent(ActionEvent var1);

    protected void finalize() throws Throwable {
        this.manager.removeActionListener(this.delegate);
        super.finalize();
    }

    public final void actionPerformed(ActionEvent event) {
        this.manager.forwardAction(event);
    }

    private static class ActionDelegate
    implements ActionListener {
        private ActionPanel reference = null;

        public ActionDelegate(ActionPanel owner) {
            this.reference = owner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void actionPerformed(ActionEvent event) {
            try {
                try {
                    this.reference.processActionEvent(event);
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t);
                    Object var4_3 = null;
                    this.reference.invalidate();
                    this.reference.validateTree();
                    this.reference.repaint();
                    return;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.reference.invalidate();
                this.reference.validateTree();
                this.reference.repaint();
                throw throwable;
            }
            this.reference.invalidate();
            this.reference.validateTree();
            this.reference.repaint();
        }
    }
}

