/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.isqlviewer.util.BasicUtilities;

public abstract class ActionManager
implements MouseListener,
Runnable {
    public static final String DND_PROXY_COMMAND = "dnd-proxy";
    private String imageLoction = "/images/";
    private Hashtable actions;
    private ActionListener listener = null;
    private ItemListener itemlistener = null;
    private PropertyChangeSupport support;
    private Vector queue = new Vector();

    static ActionManager createDefaultInstance() {
        return new BasicActionManager();
    }

    public ActionManager() {
        this.actions = new Hashtable();
        this.support = new PropertyChangeSupport(this);
    }

    protected abstract void addActions();

    protected void addAction(String cmdname, Action action) {
        this.actions.put(cmdname, action);
    }

    public void addActionListener(ActionListener l) {
        this.listener = AWTEventMulticaster.add(this.listener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listener = AWTEventMulticaster.remove(this.listener, l);
    }

    public final void setImagePath(String path) {
        this.imageLoction = path;
    }

    public void addItemListener(ItemListener l) {
        this.itemlistener = AWTEventMulticaster.add(this.itemlistener, l);
    }

    public void removeItemListener(ItemListener l) {
        this.itemlistener = AWTEventMulticaster.remove(this.itemlistener, l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    public ImageIcon getSmallIcon(String name, String type) {
        return this.getIcon(name, 16, type);
    }

    public ImageIcon getLargeIcon(String name, String type) {
        return this.getIcon(name, 24, type);
    }

    public ImageIcon getIcon(String name, int size, String type) {
        String imagePath = this.imageLoction + name + size + "." + type;
        URL url = this.getClass().getResource(imagePath);
        if (url != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    public Action getAction(String key) {
        if (key != null && key != "") {
            return (Action)this.actions.get(key);
        }
        return null;
    }

    public Action getAction(int keyID) {
        return this.getAction(Integer.toString(keyID));
    }

    public void doAction(ActionEvent evt) {
        if (this.listener != null) {
            this.listener.actionPerformed(evt);
        }
    }

    public void doItemEvent(ItemEvent evt) {
        if (this.itemlistener != null) {
            this.itemlistener.itemStateChanged(evt);
        }
    }

    public void setActionEnabled(String actionKey, boolean f) {
        try {
            this.getAction(actionKey).setEnabled(f);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setActionEnabled(int actionKey, boolean f) {
        try {
            this.getAction(actionKey).setEnabled(f);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void forwardAction(ActionEvent evt) {
        this.addEvent(evt);
    }

    public final void forwardItemEvent(ItemEvent evt) {
        this.addEvent(evt);
    }

    public void mouseEntered(MouseEvent evt) {
        AbstractButton comp;
        Action action;
        if (evt.getSource() instanceof AbstractButton && (action = this.getAction((comp = (AbstractButton)evt.getSource()).getActionCommand())) != null) {
            String message = (String)action.getValue("LongDescription");
            this.support.firePropertyChange("begin-command", "", message);
        }
    }

    public void mouseExited(MouseEvent evt) {
        AbstractButton comp;
        Action action;
        if (evt.getSource() instanceof AbstractButton && (action = this.getAction((comp = (AbstractButton)evt.getSource()).getActionCommand())) != null) {
            String message = (String)action.getValue("LongDescription");
            this.support.firePropertyChange("end-command", message, "");
        }
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!Thread.interrupted()) {
            String message;
            try {
                this.processNextEvent();
            }
            catch (NullPointerException ex2) {
                message = "ActionManager NullPointerException processing event: " + ex2.getMessage();
                this.support.firePropertyChange("message-command", "", message);
            }
            catch (Exception ex) {
                message = "ActionManager fatal exception processing event: " + ex.getMessage();
                this.support.firePropertyChange("message-command", "", message);
                ex.printStackTrace();
            }
            finally {
                System.runFinalization();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEvent(AWTEvent evt) {
        if (!this.isDupe(evt)) {
            this.queue.addElement(evt);
            ActionManager actionManager = this;
            synchronized (actionManager) {
                this.notify();
            }
        } else {
            BasicUtilities.beep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized AWTEvent getNextEvent() {
        if (this.queue.size() == 0) {
            try {
                ActionManager actionManager = this;
                synchronized (actionManager) {
                    this.wait();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            AWTEvent evt = (AWTEvent)this.queue.firstElement();
            return evt;
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNextEvent() {
        AWTEvent evt = this.getNextEvent();
        if (evt == null) {
            return;
        }
        try {
            if (evt instanceof ActionEvent) {
                if (this.listener != null) {
                    this.listener.actionPerformed((ActionEvent)evt);
                }
            } else if (evt instanceof ItemEvent && this.itemlistener != null) {
                this.itemlistener.itemStateChanged((ItemEvent)evt);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this.queue.removeElementAt(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDupe(AWTEvent newEvent) {
        if (this.queue.isEmpty()) {
            return false;
        }
        Vector vector = this.queue;
        synchronized (vector) {
            AWTEvent evt = (AWTEvent)this.queue.firstElement();
            if (evt == null) {
                return false;
            }
            return newEvent.getID() == evt.getID();
        }
    }

    private static class BasicActionManager
    extends ActionManager {
        private BasicActionManager() {
        }

        protected void addActions() {
        }
    }
}

