/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.model;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.util.BasicUtilities;

public class DriverPropertyTableModel
extends EnhancedTableModel {
    private final String[] mColumnNames = new String[]{BasicUtilities.getString("Driver_Property_Required"), BasicUtilities.getString("Driver_Property_Name"), BasicUtilities.getString("Property_Choice_Value")};
    protected DriverPropertyInfo[] data;
    protected boolean tooltips = true;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;

    public DriverPropertyTableModel() {
        this.setColumns(this.mColumnNames);
    }

    public DriverPropertyTableModel(DriverPropertyInfo[] properties) {
        this();
        this.setData(properties);
    }

    public DriverPropertyInfo getPropertyInfo(int row) {
        String property = this.data[row].name;
        String modelProperty = (String)this.getValueAt(row, 1);
        if (!modelProperty.equalsIgnoreCase(property)) {
            row = this.getRealRow(modelProperty);
        }
        return this.data[row];
    }

    public void setData(DriverPropertyInfo[] properties) {
        this.clear();
        this.data = properties;
        if (properties != null) {
            for (int i = 0; i < properties.length; ++i) {
                ArrayList<Object> row = new ArrayList<Object>(3);
                row.add(new Boolean(properties[i].required));
                row.add(properties[i].name);
                row.add(properties[i].value);
                this.addRow(row);
            }
            this.fireTableStructureChanged();
        } else {
            this.data = new DriverPropertyInfo[0];
        }
    }

    public void setToolTipsEnabled(boolean f) {
        this.tooltips = f;
    }

    public void setProperties(Preferences prefs) {
        if (prefs == null) {
            return;
        }
        try {
            String[] keys = prefs.keys();
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                int row = this.getRealRow(key);
                String val = prefs.get(key, "");
                if (val == null || row < 0) continue;
                this.setValueAt(val, row, 2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setProperties(Properties props) {
        if (props == null) {
            return;
        }
        try {
            String[] keys = props.keySet().toArray(new String[0]);
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                int row = this.getRealRow(key);
                String val = props.getProperty(key, "");
                if (val == null || row < 0) continue;
                this.setValueAt(val, row, 2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Properties toProperties() {
        Properties props = new Properties();
        for (int r = 0; r < this.getRowCount(); ++r) {
            String key = (String)this.getValueAt(r, 1);
            String val = (String)this.getValueAt(r, 2);
            if (key == null || val == null) continue;
            props.setProperty(key, val);
        }
        return props;
    }

    public DefaultCellEditor getChoiceEditor() {
        return new ChoiceRenderer();
    }

    public boolean hasRequiredData() {
        try {
            for (int r = 0; r < this.getRowCount(); ++r) {
                try {
                    boolean f = (Boolean)this.getValueAt(r, 0);
                    String s = this.getValueAt(r, 2).toString();
                    if (!f || s != null) continue;
                    return false;
                }
                catch (NullPointerException npe) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            BasicUtilities.HandleException(e);
            return false;
        }
        return true;
    }

    public Class getColumnClass(int idx) {
        switch (idx) {
            case 0: {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = DriverPropertyTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
            default: {
                return class$java$lang$String == null ? (class$java$lang$String = DriverPropertyTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
            case 2: 
        }
        return array$Ljava$lang$String == null ? (array$Ljava$lang$String = DriverPropertyTableModel.class$("[Ljava.lang.String;")) : array$Ljava$lang$String;
    }

    public boolean isCellEditable(int row, int col) {
        return col == 2;
    }

    private int getRealRow(String property) {
        for (int i = 0; i < this.data.length; ++i) {
            if (!this.data[i].name.equalsIgnoreCase(property)) continue;
            return i;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ChoiceRenderer
    extends DefaultCellEditor {
        public ChoiceRenderer() {
            super(new JComboBox());
        }

        private void createChoiceDelegate(JComboBox comboBox) {
            this.delegate = new DefaultCellEditor.EditorDelegate(this, comboBox){
                private final /* synthetic */ JComboBox val$comboBox;
                private final /* synthetic */ ChoiceRenderer this$1;
                {
                    this.this$1 = this$1;
                    this.val$comboBox = val$comboBox;
                }

                public void setValue(Object value) {
                    this.val$comboBox.setSelectedItem(value);
                }

                public Object getCellEditorValue() {
                    return this.val$comboBox.getSelectedItem();
                }

                public boolean shouldSelectCell(EventObject anEvent) {
                    if (anEvent instanceof MouseEvent) {
                        MouseEvent e = (MouseEvent)anEvent;
                        return e.getID() != 506;
                    }
                    return true;
                }
            };
        }

        private void createSingleDelegate(JTextField textField) {
            this.delegate = new DefaultCellEditor.EditorDelegate(this, textField){
                private final /* synthetic */ JTextField val$textField;
                private final /* synthetic */ ChoiceRenderer this$1;
                {
                    this.this$1 = this$1;
                    this.val$textField = val$textField;
                }

                public void setValue(Object value) {
                    if (value != null) {
                        this.val$textField.setText(value.toString());
                    } else {
                        this.val$textField.setText("");
                    }
                }

                public Object getCellEditorValue() {
                    return this.val$textField.getText();
                }

                public boolean shouldSelectCell(EventObject anEvent) {
                    if (anEvent instanceof MouseEvent) {
                        MouseEvent e = (MouseEvent)anEvent;
                        return e.getID() != 506;
                    }
                    return true;
                }
            };
        }

        public Component getTableCellEditorComponent(JTable table, Object obj, boolean isSelected, int row, int col) {
            try {
                String p = (String)DriverPropertyTableModel.this.getValueAt(row, 1);
                row = DriverPropertyTableModel.this.getRealRow(p);
                if (row < 0) {
                    super.getTableCellEditorComponent(table, obj, isSelected, row, col);
                }
                boolean choiceFlag = DriverPropertyTableModel.this.data[row].choices.length >= 0;
                JComboBox<String> component = null;
                if (choiceFlag) {
                    component = new JComboBox<String>(DriverPropertyTableModel.this.data[row].choices);
                    if (DriverPropertyTableModel.this.tooltips) {
                        component.setToolTipText(DriverPropertyTableModel.this.data[row].description);
                    }
                    component.addActionListener(this.delegate);
                    component.setEditable(false);
                    component.setSelectedItem(obj);
                    component.setMaximumRowCount(3);
                    this.createChoiceDelegate(component);
                    this.editorComponent = component;
                    table.setRowHeight(this.editorComponent.getPreferredSize().height);
                }
            }
            catch (Exception e) {
                JTextField txt = new JTextField(obj == null ? DriverPropertyTableModel.this.data[row].value : obj.toString());
                this.createSingleDelegate(txt);
                txt.addActionListener(this.delegate);
                if (DriverPropertyTableModel.this.tooltips) {
                    txt.setToolTipText(DriverPropertyTableModel.this.data[row].description);
                }
                this.editorComponent = txt;
            }
            return super.getTableCellEditorComponent(table, obj, isSelected, row, col);
        }
    }
}

