/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.isqlviewer.core.SQLBookmark;
import org.isqlviewer.util.Base64Decoder;
import org.isqlviewer.util.Base64Encoder;
import org.isqlviewer.util.Base64FormatException;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.StringTokenizer;
import org.isqlviewer.util.StringUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class BookmarkTreeModel
implements TreeModel {
    public static final String ROOT_PATH = "/";
    public static final char SEPERATOR = '/';
    private StringBuffer tabBuffer = new StringBuffer("");
    private Hashtable pathMap = new Hashtable();
    private transient Vector treeModelListeners;
    private boolean isModified = false;
    private final Charset UTF = Charset.forName("UTF8");

    public BookmarkTreeModel() {
        this(new SQLBookmark[0]);
    }

    protected BookmarkTreeModel(SQLBookmark[] bookmarks) {
        this.pathMap.put(ROOT_PATH, new Vector());
        for (int i = 0; i < bookmarks.length; ++i) {
            this.addBookmark(bookmarks[i], false);
        }
    }

    public static TreePath getTreePath(String path) {
        StringBuffer spath = new StringBuffer(ROOT_PATH);
        StringTokenizer st = new StringTokenizer(path, ROOT_PATH, false, false);
        TreePath tp = new TreePath(ROOT_PATH);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals(ROOT_PATH) || s.trim().length() == 0) continue;
            spath.append(s);
            spath.append('/');
            tp = tp.pathByAddingChild(spath.toString());
        }
        return tp;
    }

    public Object getRoot() {
        return ROOT_PATH;
    }

    public Object getChild(Object parent, int index) {
        if (parent instanceof String) {
            Vector list = (Vector)this.pathMap.get(parent);
            return list.get(index);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (parent instanceof String) {
            Vector list = (Vector)this.pathMap.get(parent);
            return list == null ? 0 : list.size();
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        return node instanceof SQLBookmark;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        Object leaf = path.getLastPathComponent();
        if (leaf instanceof String) {
            String folder = newValue.toString();
            String srcpath = (String)leaf;
            String destpath = BookmarkTreeModel.getParentPathElement(srcpath).concat(folder).concat(ROOT_PATH);
            this.movePath(srcpath, destpath);
            return;
        }
        if (leaf instanceof SQLBookmark) {
            String name = newValue.toString();
            SQLBookmark bm = (SQLBookmark)leaf;
            if (!bm.getName().equals(name)) {
                bm.setName(name);
                this.setModified();
                this.fireTreeNodesChanged(new TreeModelEvent((Object)this, bm.toTreePath()));
            }
        }
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent instanceof String) {
            Vector list = (Vector)this.pathMap.get(parent);
            return list.indexOf(child);
        }
        return -1;
    }

    public synchronized void removeTreeModelListener(TreeModelListener l) {
        if (this.treeModelListeners != null && this.treeModelListeners.contains(l)) {
            Vector v = (Vector)this.treeModelListeners.clone();
            v.removeElement(l);
            this.treeModelListeners = v;
        }
    }

    public synchronized void addTreeModelListener(TreeModelListener l) {
        Vector v;
        Vector vector = v = this.treeModelListeners == null ? new Vector(2) : (Vector)this.treeModelListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.treeModelListeners = v;
        }
    }

    public boolean isPath(String path) {
        return this.pathMap.containsKey(path);
    }

    public boolean isEmpty() {
        return this.getChildCount(ROOT_PATH) == 0;
    }

    public boolean isModified() {
        return this.isModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setModified() {
        BookmarkTreeModel bookmarkTreeModel = this;
        synchronized (bookmarkTreeModel) {
            this.isModified = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(XMLReader reader, InputStream is) throws IOException, SAXException {
        reader.setContentHandler(new Parser(this));
        BookmarkTreeModel bookmarkTreeModel = this;
        synchronized (bookmarkTreeModel) {
            this.pathMap.clear();
            this.pathMap.put(ROOT_PATH, new Vector());
            this.isModified = false;
            reader.parse(new InputSource(is));
            reader = null;
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void store(OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, this.UTF);
        PrintWriter pw = new PrintWriter((Writer)writer, false);
        pw.println("<?xml version=\"1.0\" encoding=\"" + this.UTF.name() + "\" standalone='yes' ?>");
        pw.println("<isql-bookmarks>");
        String tab = this.createTabdepth(1);
        Vector list = (Vector)this.pathMap.get(ROOT_PATH);
        for (int i = 0; i < list.size(); ++i) {
            Object o = list.get(i);
            if (o instanceof SQLBookmark) {
                pw.print(tab);
                SQLBookmark bm = (SQLBookmark)o;
                pw.write(this.formatBookmark(bm, tab));
                continue;
            }
            if (!(o instanceof String)) continue;
            this.persistFolder(pw, (String)o, 1);
        }
        pw.println("</isql-bookmarks>");
        pw.flush();
        BookmarkTreeModel bookmarkTreeModel = this;
        synchronized (bookmarkTreeModel) {
            this.isModified = false;
        }
    }

    public void createFolder(String path, String folder) {
        this.addFolder(path, folder, true);
    }

    public void deleteFolder(String path, String folder) {
        this.deleteFolder(path, folder, true);
    }

    public void deleteBookmark(SQLBookmark bookmark) {
        this.deleteBookmark(bookmark, true);
    }

    public void addBookmark(SQLBookmark bookmark) {
        this.addBookmark(bookmark, true);
    }

    public void refresh() {
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new Object[]{ROOT_PATH}, null, null));
    }

    public void refresh(SQLBookmark bm) {
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, bm.toTreePath(), null, null));
    }

    public void moveBookmark(SQLBookmark bmark, String newPath) {
        this.moveBookmark(bmark, newPath.trim(), true);
    }

    public void movePath(String srcPath, String destPath) {
        this.managePath(srcPath.trim(), destPath.trim(), true, false);
    }

    public void copyPath(String srcPath, String destPath) {
        this.managePath(srcPath.trim(), destPath.trim(), true, true);
    }

    public void copyBookmark(SQLBookmark bookmark, String path) {
        this.copyBookmark(bookmark, path, true);
    }

    protected void addFolder(String path, String folder, boolean fire) {
        String newPath = null;
        newPath = folder.charAt(0) == '/' ? path.concat(folder.substring(1).concat(ROOT_PATH)) : path.concat(folder.concat(ROOT_PATH));
        this.ensurePath(newPath);
        Vector lst = (Vector)this.pathMap.get(path);
        int idx = Math.max(0, lst.indexOf(newPath));
        if (fire) {
            this.setModified();
            this.fireTreeNodesInserted(new TreeModelEvent((Object)this, BookmarkTreeModel.getTreePath(path), new int[]{idx}, null));
        }
    }

    protected void addBookmark(SQLBookmark bookmark, boolean fire) {
        String newpath = bookmark.getPath();
        this.ensurePath(newpath);
        Vector lst = (Vector)this.pathMap.get(newpath);
        String name = bookmark.getName();
        int i = 0;
        while (lst.contains(bookmark)) {
            bookmark.setName(name.concat(Integer.toString(i)));
            ++i;
        }
        if (lst.add(bookmark) && fire) {
            int[] idxs = new int[]{lst.indexOf(bookmark)};
            this.fireTreeNodesInserted(new TreeModelEvent((Object)this, BookmarkTreeModel.getTreePath(newpath), idxs, null));
        }
    }

    protected void deleteFolder(String path, String folder, boolean fire) {
        Vector parent;
        int index;
        String srcpath = null;
        String parpath = null;
        if (path.endsWith(ROOT_PATH)) {
            parpath = new String(path);
            srcpath = parpath.concat(folder).concat(ROOT_PATH);
        } else {
            parpath = path.concat(ROOT_PATH);
            srcpath = parpath.concat(folder).concat(ROOT_PATH);
        }
        if (this.pathMap.containsKey(parpath) && (index = (parent = (Vector)this.pathMap.get(parpath)).indexOf(srcpath)) >= 0) {
            parent.remove(index);
            if (fire) {
                this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, BookmarkTreeModel.getTreePath(parpath), new int[]{index}, null));
            }
        }
        if (this.pathMap.containsKey(srcpath)) {
            Vector lst = (Vector)this.pathMap.remove(srcpath);
            lst.clear();
            lst = null;
            if (fire) {
                this.setModified();
                this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, BookmarkTreeModel.getTreePath(srcpath)));
            }
        }
    }

    protected SQLBookmark deleteBookmark(SQLBookmark bookmark, boolean fire) {
        Vector lst;
        int index;
        String path = bookmark.getPath();
        if (this.pathMap.containsKey(path) && (index = (lst = (Vector)this.pathMap.get(path)).indexOf(bookmark)) >= 0) {
            SQLBookmark removed = (SQLBookmark)lst.remove(index);
            this.setModified();
            if (fire) {
                int[] idxs = new int[]{index};
                this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, BookmarkTreeModel.getTreePath(path), idxs, null));
            }
            return removed;
        }
        throw new IllegalArgumentException(path);
    }

    protected void moveBookmark(SQLBookmark bookmark, String newPath, boolean fire) {
        bookmark = this.deleteBookmark(bookmark, fire);
        bookmark.setPath(newPath);
        this.addBookmark(bookmark, fire);
    }

    protected void copyBookmark(SQLBookmark bookmark, String newPath, boolean fire) {
        this.ensurePath(newPath);
        Vector lst = (Vector)this.pathMap.get(newPath);
        SQLBookmark copy = (SQLBookmark)bookmark.clone();
        copy.setPath(newPath);
        String name = copy.getName();
        int i = 0;
        while (lst.contains(copy)) {
            copy.setName(name.concat(Integer.toString(i)));
            ++i;
        }
        if (lst.add(copy) && fire) {
            int[] idxs = new int[]{lst.indexOf(copy)};
            this.fireTreeNodesInserted(new TreeModelEvent((Object)this, BookmarkTreeModel.getTreePath(newPath), idxs, null));
        }
    }

    protected void managePath(String srcPath, String destPath, boolean fire, boolean copy) {
        String srcFolder = BookmarkTreeModel.getLastPathElement(srcPath);
        String parentPath = BookmarkTreeModel.getParentPathElement(srcPath);
        if (copy) {
            destPath = destPath.concat(srcFolder).concat(Character.toString('/'));
        }
        if (srcPath.equalsIgnoreCase(destPath) || srcPath.equalsIgnoreCase(ROOT_PATH)) {
            throw new IllegalArgumentException(srcPath);
        }
        Vector lst = null;
        if (copy) {
            lst = (Vector)this.pathMap.get(srcPath);
        } else {
            Vector plst = (Vector)this.pathMap.get(parentPath);
            if (plst != null) {
                int index = plst.indexOf(srcPath);
                plst.set(index, destPath);
                if (fire) {
                    int[] idxs = new int[]{index};
                    this.fireTreeNodesChanged(new TreeModelEvent((Object)this, BookmarkTreeModel.getTreePath(parentPath), idxs, null));
                }
            }
            lst = (Vector)this.pathMap.remove(srcPath);
            this.pathMap.put(destPath, lst);
        }
        this.ensurePath(destPath);
        Iterator itr = lst.iterator();
        while (itr.hasNext()) {
            Object next = itr.next();
            if (next instanceof SQLBookmark) {
                SQLBookmark bookmark = (SQLBookmark)next;
                if (copy) {
                    this.copyBookmark(bookmark, destPath, false);
                    continue;
                }
                bookmark.setPath(destPath);
                continue;
            }
            String folder = BookmarkTreeModel.getLastPathElement((String)next);
            String srcSub = srcPath.concat(folder).concat(ROOT_PATH);
            if (copy) {
                this.managePath(srcSub, destPath, false, copy);
                continue;
            }
            String destSub = destPath.concat(folder).concat(ROOT_PATH);
            this.managePath(srcSub, destSub, false, copy);
        }
        if (fire) {
            if (!copy) {
                this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, BookmarkTreeModel.getTreePath(srcPath)));
            }
            this.fireTreeNodesInserted(new TreeModelEvent((Object)this, BookmarkTreeModel.getTreePath(destPath)));
        }
        this.setModified();
    }

    protected void fireTreeNodesChanged(TreeModelEvent e) {
        if (this.treeModelListeners != null) {
            Iterator itr = this.treeModelListeners.iterator();
            while (itr.hasNext()) {
                TreeModelListener tml = (TreeModelListener)itr.next();
                try {
                    tml.treeNodesChanged(e);
                }
                catch (Throwable t) {}
            }
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent e) {
        if (this.treeModelListeners != null) {
            Iterator itr = this.treeModelListeners.iterator();
            while (itr.hasNext()) {
                TreeModelListener tml = (TreeModelListener)itr.next();
                try {
                    tml.treeNodesInserted(e);
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t);
                }
            }
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent e) {
        if (this.treeModelListeners != null) {
            Iterator itr = this.treeModelListeners.iterator();
            while (itr.hasNext()) {
                TreeModelListener tml = (TreeModelListener)itr.next();
                try {
                    tml.treeNodesRemoved(e);
                }
                catch (Throwable t) {}
            }
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent e) {
        if (this.treeModelListeners != null) {
            Iterator itr = this.treeModelListeners.iterator();
            while (itr.hasNext()) {
                TreeModelListener tml = (TreeModelListener)itr.next();
                try {
                    tml.treeStructureChanged(e);
                }
                catch (Throwable t) {}
            }
        }
    }

    private void ensurePath(String path) {
        StringTokenizer st = new StringTokenizer(path, ROOT_PATH, false, true);
        StringBuffer accPath = new StringBuffer(ROOT_PATH);
        while (st.hasMoreTokens()) {
            String node = st.nextToken();
            String parentPath = accPath.toString();
            accPath.append(node);
            accPath.append('/');
            if (this.pathMap.get(accPath.toString()) != null) continue;
            this.pathMap.put(accPath.toString(), new Vector());
            Vector list = (Vector)this.pathMap.get(parentPath);
            try {
                list.add(0, accPath.toString());
            }
            catch (ArrayIndexOutOfBoundsException oob) {
                list.add(accPath.toString());
            }
        }
    }

    private String formatBookmark(SQLBookmark bookmark, String tabs) {
        StringBuffer xmlBuff = new StringBuffer("<");
        xmlBuff.append(Parser.TAG_BOOKMARK);
        xmlBuff.append(" ");
        xmlBuff.append(Parser.ATTR_NAME);
        xmlBuff.append("=\"");
        xmlBuff.append(StringUtilities.encodeXMLEntities(bookmark.getName()));
        xmlBuff.append("\" ");
        xmlBuff.append(Parser.ATTR_BM_COUNT);
        xmlBuff.append("=\"");
        xmlBuff.append(Long.toString(bookmark.getUseCount()));
        xmlBuff.append("\" ");
        xmlBuff.append(Parser.ATTR_BM_LAST);
        xmlBuff.append("=\"");
        xmlBuff.append(Long.toString(bookmark.getLastAccessTime().getTime()));
        xmlBuff.append("\" ");
        xmlBuff.append(Parser.ATTR_BM_EPOCH);
        xmlBuff.append("=\"");
        xmlBuff.append(Long.toString(bookmark.getCreationDate().getTime()));
        xmlBuff.append("\">");
        xmlBuff.append(System.getProperty("line.seperator", "\n"));
        if (bookmark.hasParameters()) {
            Iterator itr = bookmark.parameterIterator();
            while (itr.hasNext()) {
                SQLBookmark.Parameter next = (SQLBookmark.Parameter)itr.next();
                xmlBuff.append(tabs);
                xmlBuff.append("\t<");
                xmlBuff.append(Parser.TAG_PARAMETER);
                xmlBuff.append(" ");
                xmlBuff.append(Parser.ATTR_PARAM_TYPE);
                xmlBuff.append("=\"");
                xmlBuff.append(Integer.toString(next.getSQLType()));
                xmlBuff.append("\" ");
                xmlBuff.append(Parser.ATTR_PARAM_VALUE);
                xmlBuff.append("=\"");
                xmlBuff.append(StringUtilities.encodeXMLEntities(next.getValue()));
                xmlBuff.append("\" ");
                xmlBuff.append(Parser.ATTR_PARAM_OPTIONS);
                xmlBuff.append("=\"");
                xmlBuff.append(StringUtilities.encodeXMLEntities(next.getOptions()));
                xmlBuff.append("\"/>");
                xmlBuff.append(System.getProperty("line.seperator", "\n"));
            }
        }
        xmlBuff.append(tabs);
        xmlBuff.append(" ");
        Base64Encoder b64 = new Base64Encoder(bookmark.getSQL().trim());
        xmlBuff.append(StringUtilities.formatBreak(80, b64.processString(), tabs.concat(" "), false));
        xmlBuff.append(System.getProperty("line.seperator", "\n"));
        xmlBuff.append(tabs);
        xmlBuff.append("</");
        xmlBuff.append(Parser.TAG_BOOKMARK);
        xmlBuff.append(">");
        xmlBuff.append(System.getProperty("line.seperator", "\n"));
        return xmlBuff.toString();
    }

    private void persistFolder(PrintWriter ps, String path, int tabDepth) throws IOException {
        Vector list = (Vector)this.pathMap.get(path);
        if (list == null) {
            return;
        }
        String tab = this.createTabdepth(tabDepth);
        ps.print(tab);
        String name = BookmarkTreeModel.getLastPathElement(path);
        name = StringUtilities.encodeXMLEntities(name);
        ps.print("<");
        ps.print(Parser.TAG_FOLDER);
        ps.print(" ");
        ps.print(Parser.ATTR_NAME);
        ps.print("=\"");
        ps.print(StringUtilities.encodeXMLEntities(name));
        ps.println("\" >");
        for (int i = 0; i < list.size(); ++i) {
            Object o = list.get(i);
            if (o instanceof SQLBookmark) {
                ps.print(tab);
                SQLBookmark bm = (SQLBookmark)o;
                ps.write(this.formatBookmark(bm, tab));
                continue;
            }
            if (!(o instanceof String)) continue;
            this.persistFolder(ps, (String)o, tabDepth + 1);
        }
        ps.print(tab);
        ps.print("</");
        ps.print(Parser.TAG_FOLDER);
        ps.println(">");
    }

    private String createTabdepth(int size) {
        this.tabBuffer.setLength(0);
        for (int i = 0; i < size; ++i) {
            this.tabBuffer.append('\t');
        }
        String buff = this.tabBuffer.toString();
        this.tabBuffer.setLength(0);
        return buff;
    }

    private static String getLastPathElement(String path) {
        return path.substring(path.lastIndexOf(47, path.length() - 2) + 1, path.length() - 1);
    }

    private static String getParentPathElement(String path) {
        String child = BookmarkTreeModel.getLastPathElement(path);
        return path.substring(0, path.lastIndexOf(child));
    }

    private static class Parser
    extends DefaultHandler {
        private static String TAG_BOOKMARK = "bookmark";
        private static String TAG_PARAMETER = "parameter";
        private static String TAG_FOLDER = "folder";
        private static String ATTR_NAME = "name";
        private static String ATTR_BM_EPOCH = "created";
        private static String ATTR_BM_LAST = "last";
        private static String ATTR_BM_COUNT = "count";
        private static String ATTR_BM_EPOCH_OLD = "epoch";
        private static String ATTR_BM_LAST_OLD = "last_query";
        private static String ATTR_BM_COUNT_OLD = "use_count";
        private static String ATTR_PARAM_TYPE = "type";
        private static String ATTR_PARAM_VALUE = "value";
        private static String ATTR_PARAM_OPTIONS = "options";
        private StringBuffer pathBuffer = new StringBuffer("/");
        private BookmarkTreeModel model = null;
        private SQLBookmark currentBookmark = null;

        public Parser(BookmarkTreeModel model) {
            this.model = model;
        }

        public void characters(char[] parm1, int parm2, int parm3) {
            String cdata = new String(parm1, parm2, parm3).trim();
            if (this.currentBookmark != null && cdata.length() >= 1) {
                String sql = this.currentBookmark.getSQL();
                this.currentBookmark.setSQL(sql.concat(cdata));
            }
            cdata = null;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String tag = qName.toLowerCase().trim();
            if (tag.equals(TAG_FOLDER) && this.currentBookmark == null) {
                String rootpath = this.pathBuffer.toString();
                String folder = attributes.getValue(ATTR_NAME).trim();
                this.pathBuffer.append(folder);
                if (this.pathBuffer.charAt(this.pathBuffer.length() - 1) != '/') {
                    this.pathBuffer.append('/');
                }
                this.model.addFolder(rootpath, folder, false);
            } else if (tag.equals(TAG_PARAMETER) && this.currentBookmark != null) {
                SQLBookmark.Parameter param = new SQLBookmark.Parameter();
                param.setOptions(attributes.getValue(ATTR_PARAM_OPTIONS).trim());
                param.setValue(attributes.getValue(ATTR_PARAM_VALUE).trim());
                try {
                    String type = attributes.getValue(ATTR_PARAM_TYPE);
                    param.setSQLType(Integer.parseInt(type.trim()));
                }
                catch (NumberFormatException e) {
                    throw new SAXException(e);
                }
                this.currentBookmark.addParameter(param);
            } else if (tag.equals(TAG_BOOKMARK) && this.currentBookmark == null) {
                int idx;
                String name = "";
                long created = System.currentTimeMillis();
                long last = 0L;
                long count = 0L;
                try {
                    idx = attributes.getIndex(ATTR_NAME);
                    if (idx >= 0) {
                        name = attributes.getValue(idx);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    idx = attributes.getIndex(ATTR_BM_EPOCH_OLD);
                    if (idx >= 0) {
                        created = Long.parseLong(attributes.getValue(idx));
                    } else {
                        idx = attributes.getIndex(ATTR_BM_EPOCH);
                        created = Long.parseLong(attributes.getValue(idx));
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    int idx2 = attributes.getIndex(ATTR_BM_COUNT_OLD);
                    if (idx2 >= 0) {
                        count = Long.parseLong(attributes.getValue(idx2));
                    } else {
                        idx2 = attributes.getIndex(ATTR_BM_COUNT);
                        count = Long.parseLong(attributes.getValue(idx2));
                    }
                }
                catch (NumberFormatException e) {
                    throw new SAXException(e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    int idx3 = attributes.getIndex(ATTR_BM_LAST_OLD);
                    if (idx3 >= 0) {
                        last = Long.parseLong(attributes.getValue(idx3));
                    } else {
                        idx3 = attributes.getIndex(ATTR_BM_LAST);
                        last = Long.parseLong(attributes.getValue(idx3));
                    }
                }
                catch (NumberFormatException e) {
                    throw new SAXException(e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                this.currentBookmark = new SQLBookmark(new Date(created), name, "");
                this.currentBookmark.setPath(this.pathBuffer.toString());
                this.currentBookmark.setLastAccessTime(last);
                this.currentBookmark.setUseCount(count);
            }
        }

        public void endElement(String uri, String localName, String qName) {
            String tag = qName.toLowerCase().trim();
            if (tag.equals(TAG_FOLDER)) {
                String str = this.pathBuffer.toString();
                int idx = str.lastIndexOf(47);
                try {
                    idx = str.lastIndexOf(47, idx - 1);
                    this.pathBuffer = this.pathBuffer.delete(idx + 1, this.pathBuffer.length());
                }
                catch (Exception e) {}
            } else if (tag.equals(TAG_BOOKMARK)) {
                Base64Decoder decoder = new Base64Decoder(this.currentBookmark.getSQL());
                try {
                    String decodedSQL = decoder.processString();
                    this.currentBookmark.setSQL(decodedSQL);
                    this.model.addBookmark(this.currentBookmark, false);
                }
                catch (Base64FormatException b64fe) {
                    // empty catch block
                }
                this.currentBookmark = null;
            }
        }
    }
}

