/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.jetfire;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.isqlviewer.core.jetfire.AbstractImportPlugin;
import org.isqlviewer.core.jetfire.ImportConfig;
import org.isqlviewer.core.jetfire.ImportProcessor;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;

public class LookupPlugin
extends AbstractImportPlugin
implements ActionListener {
    private DefaultComboBoxModel mdlColumns = new DefaultComboBoxModel();
    private DefaultComboBoxModel mdlTables = new DefaultComboBoxModel();
    private JComboBox jcbColumns = new JComboBox(this.mdlColumns);
    private JComboBox jcbTables = new JComboBox(this.mdlTables);
    private JTextField txtWhereClause = new JTextField("");
    private JCheckBox chkAllowNulls = new JCheckBox(BasicUtilities.getString("Import_SQL_Allow_Nulls"));
    private static final String KEY_TABLE = "table";
    private static final String KEY_COLUMN = "column";
    private static final String KEY_ALLOW_NULLS = "allow-nulls";
    private static final String KEY_WHERE = "where";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.jcbTables) {
            DatabaseMetaData dmd = this.connection.getDatabaseInformation();
            ResultSet set = null;
            String catalog = this.connection.getCatalog();
            String schema = this.connection.getSchema();
            String table = (String)this.jcbTables.getSelectedItem();
            this.mdlColumns.removeAllElements();
            try {
                set = dmd.getColumns(catalog, schema, table, "%");
                while (set.next()) {
                    this.mdlColumns.addElement(set.getString("COLUMN_NAME"));
                }
            }
            catch (Throwable t) {
                BasicUtilities.beep();
                BasicUtilities.HandleException(t);
            }
            finally {
                try {
                    set.close();
                }
                catch (Throwable t) {}
                set = null;
            }
        }
    }

    public ImportConfig.Entry createEntry() {
        ImportConfig.Entry entry = new ImportConfig.Entry(this);
        entry.put(KEY_ALLOW_NULLS, new Boolean(this.chkAllowNulls.isSelected()));
        Object item = this.jcbColumns.getSelectedItem();
        if (item != null) {
            entry.put(KEY_COLUMN, item);
        } else {
            entry.put(KEY_COLUMN, "");
        }
        item = this.jcbTables.getSelectedItem();
        if (item != null) {
            entry.put(KEY_TABLE, item);
        } else {
            entry.put(KEY_TABLE, "");
        }
        entry.setProperty(KEY_WHERE, this.txtWhereClause.getText());
        return entry;
    }

    public void setEntry(ImportConfig.Entry entry) {
        if (entry.containsKey(KEY_ALLOW_NULLS)) {
            try {
                Boolean bool = (Boolean)entry.get(KEY_ALLOW_NULLS);
                this.chkAllowNulls.setSelected(bool);
            }
            catch (Throwable t) {
                this.chkAllowNulls.setSelected(false);
            }
        }
        this.jcbColumns.setSelectedItem(entry.get(KEY_COLUMN));
        this.jcbTables.setSelectedItem(entry.get(KEY_TABLE));
        this.txtWhereClause.setText(entry.getProperty(KEY_WHERE, ""));
    }

    public void installEditor(Container container) {
        container.setLayout(new GridBagLayout());
        LookupPlugin.constrain(0, 0, 1, 3, 0.0, 0.0, 10, 0);
        container.add(Box.createHorizontalStrut(16), UI_CONSTRAINT);
        LookupPlugin.constrain(1, 0, 1, 1, 0.0, 0.0, 13, 0);
        container.add((Component)new JLabel(BasicUtilities.getString("Import_Lookup_Table")), UI_CONSTRAINT);
        LookupPlugin.constrain(2, 0, 1, 1, 1.0, 0.0, 10, 2);
        container.add((Component)this.jcbTables, UI_CONSTRAINT);
        LookupPlugin.constrain(1, 1, 1, 1, 0.0, 0.0, 13, 0);
        container.add((Component)new JLabel(BasicUtilities.getString("Import_Lookup_Column")), UI_CONSTRAINT);
        LookupPlugin.constrain(2, 1, 1, 1, 1.0, 0.0, 10, 2);
        container.add((Component)this.jcbColumns, UI_CONSTRAINT);
        LookupPlugin.constrain(1, 2, 1, 1, 0.0, 0.0, 10, 0);
        container.add((Component)new JLabel(BasicUtilities.getString("Import_Lookup_Where")), UI_CONSTRAINT);
        LookupPlugin.constrain(2, 2, 1, 1, 1.0, 0.0, 10, 2);
        container.add((Component)this.txtWhereClause, UI_CONSTRAINT);
        LookupPlugin.constrain(2, 3, 1, 1, 1.0, 0.0, 10, 2);
        container.add((Component)this.chkAllowNulls, UI_CONSTRAINT);
        LookupPlugin.constrain(3, 0, 1, 3, 0.0, 0.0, 10, 0);
        container.add(Box.createHorizontalStrut(16), UI_CONSTRAINT);
        LookupPlugin.constrain(0, 4, 4, 1, 1.0, 1.0, 10, 3);
        container.add(Box.createVerticalGlue(), UI_CONSTRAINT);
        this.jcbTables.addActionListener(this);
        Object[] tables = this.connection.getAvailableTables();
        for (int i = 0; i < tables.length; ++i) {
            this.mdlTables.addElement(tables[i]);
        }
        if (this.mdlTables.getSize() >= 1) {
            this.jcbTables.setSelectedIndex(0);
        }
        this.chkAllowNulls.setToolTipText(BasicUtilities.getString("Import_SQL_Allow_Nulls_Tip"));
        this.txtWhereClause.setToolTipText(BasicUtilities.getString("Import_Lookup_Where_Tip"));
        this.jcbColumns.setToolTipText(BasicUtilities.getString("Import_Lookup_Column_Tip"));
        this.jcbTables.setToolTipText(BasicUtilities.getString("Import_Lookup_Table_Tip"));
    }

    public ImportProcessor createProcessor() {
        return new LookupProcessor(this);
    }

    public String getDescription() {
        return BasicUtilities.getString("Import_SQL_Lookup");
    }

    private static class LookupProcessor
    implements ImportProcessor {
        private static final String SELECT = "SELECT {0} FROM {1} {2}";
        private ImportConfig.Entry current = null;
        private LookupPlugin reference = null;

        public LookupProcessor(LookupPlugin owner) {
            this.reference = owner;
        }

        public boolean canSkip() {
            return false;
        }

        /*
         * Unable to fully structure code
         */
        public int prepareImport(int row, int index, Map values, PreparedStatement ps, int type) throws SQLException {
            block27: {
                block23: {
                    block20: {
                        if (!this.current.containsKey("column") || !this.current.containsKey("table")) {
                            this.reference.info(BasicUtilities.getString("Lookup_Bad_Entry"));
                            return 2;
                        }
                        lookup = ps.getConnection().createStatement();
                        set = null;
                        table = this.current.getProperty("table");
                        column = this.current.getProperty("column");
                        where = this.current.getProperty("where", "");
                        if (where.trim().length() >= 1) {
                            where = "WHERE ".concat(where);
                        }
                        p = new String[]{column, table, where};
                        query = MessageFormat.format("SELECT {0} FROM {1} {2}", p);
                        allowNulls = false;
                        try {
                            bool = (Boolean)this.current.get("allow-nulls");
                            allowNulls = bool;
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        this.reference.info(BasicUtilities.getString("Lookup_Query", query));
                        set = lookup.executeQuery(query);
                        if (!set.next()) ** GOTO lbl51
                        md = set.getMetaData();
                        idx = set.findColumn(column);
                        stype = md.getColumnType(idx);
                        data = JDBCUtilities.getValueForType(set, stype, idx);
                        if (allowNulls || data != null) break block20;
                        var18_22 = 1;
                        var20_23 = null;
                        try {
                            set.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        set = null;
                        try {
                            lookup.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        lookup = null;
                        return var18_22;
                    }
                    JDBCUtilities.configurePreparedStatement(ps, index, data, type, false);
                    break block23;
lbl51:
                    // 1 sources

                    var14_18 = allowNulls != false ? 3 : 1;
                    var20_24 = null;
                    try {
                        set.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    set = null;
                    try {
                        lookup.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    lookup = null;
                    return var14_18;
                }
                try {
                    var20_25 = null;
                }
                catch (Throwable var19_31) {
                    var20_26 = null;
                    try {
                        set.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    set = null;
                    try {
                        lookup.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    lookup = null;
                    throw var19_31;
                }
                try {
                    set.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                set = null;
                try {
                    lookup.close();
                    break block27;
                }
                catch (Throwable t) {
                    // empty catch block
                }
                {
                    break block27;
                    catch (SQLException sqle) {
                        throw sqle;
                    }
                    catch (Throwable t) {
                        throw new SQLException(t.getMessage());
                    }
                }
            }
            lookup = null;
            return 0;
        }

        public void setEntry(ImportConfig.Entry entry) {
            this.current = null;
            this.current = entry;
        }
    }
}

