/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.filters;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import javax.swing.filechooser.FileFilter;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.filters.AbstractTableFilter;
import org.isqlviewer.core.model.EnhancedTableModel;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.ExtensionFileFilter;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SolverTableFilter
extends AbstractTableFilter {
    public FileFilter[] getSupportedFileTypes(int mode) {
        return new FileFilter[]{new ExtensionFileFilter(this.getString("Solver_Extension"), this.getString("Solver_Desc"))};
    }

    public Icon getUserIcon() {
        return BasicUtilities.loadIconResource("Solver16");
    }

    public String getName() {
        return BasicUtilities.getString("SolverFilter_Name");
    }

    public boolean isModeSupported(int mode) {
        switch (mode) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    public boolean isFileRequired(int mode) {
        return true;
    }

    public int filterIn(EnhancedTableModel tm, File file, InputStream is) throws IOException, InterruptedException {
        ZipFile zip = new ZipFile(file);
        InputStream zis = zip.getInputStream(new ZipEntry("content.xml"));
        this.checkIfCancelled();
        this.readContent(zis, tm);
        return 3;
    }

    public int filterOut(Object data, File file, OutputStream os) {
        return 0;
    }

    protected void loadProperties(int mode) {
        String key = null;
        String desc = null;
        switch (mode) {
            case 0: {
                key = this.getString("Solver_UseSheet_Name");
                desc = this.getString("Solver_UseSheet_Desc");
                this.addProperty(key, null, "Sheet1", true, desc);
                key = this.getString("Solver_UseRowForColumnNames_Name");
                desc = this.getString("Solver_UseRowForColumnNames_Desc");
                this.addProperty(key, null, "-1", true, desc);
            }
        }
    }

    private void readContent(InputStream is, EnhancedTableModel tm) throws IOException {
        try {
            XMLReader reader = SystemConfig.getInstance().getXMLReader();
            reader.setContentHandler(new SolverParser(tm));
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.parse(new InputSource(is));
        }
        catch (Throwable t) {
            this.info(BasicUtilities.getString("Solver_General_Error"), t);
            throw new IOException(t.getMessage());
        }
    }

    private class SolverParser
    extends DefaultHandler {
        private static final String SHEET_NAME_TAG = "table:table";
        private static final String TABLE_ROW = "table:table-row";
        private static final String TABLE_TEXT = "text:p";
        private static final String SHEET_BODY = "office:body";
        private EnhancedTableModel model = null;
        private boolean inRightSheet = false;
        private boolean inCellText = false;
        private StringBuffer charBuffer = new StringBuffer("");
        private ArrayList currentRow = null;
        private String preferredSheet = "";
        private Preferences prefs = null;

        public void startDocument() {
            String key = null;
            this.prefs = SolverTableFilter.this.getConfiguration(0);
            key = SolverTableFilter.this.getString("Solver_UseSheet_Name");
            this.preferredSheet = this.prefs.get(key, "Sheet1");
        }

        public void characters(char[] ch, int start, int length) {
            if (this.inRightSheet && this.inCellText) {
                this.charBuffer.append(ch, start, length);
            }
        }

        public SolverParser(EnhancedTableModel mdl) {
            this.model = mdl;
        }

        public void endElement(String ln, String ns, String name) throws SAXException {
            String msg;
            if (name.equalsIgnoreCase(TABLE_ROW)) {
                if (this.inRightSheet) {
                    this.model.addRow(this.currentRow);
                    this.model.setColumnCount(this.currentRow.size());
                    this.currentRow = null;
                }
            } else if (name.equalsIgnoreCase(TABLE_TEXT)) {
                if (this.inCellText && this.inRightSheet) {
                    this.currentRow.add(new String(this.charBuffer.toString()));
                    this.charBuffer.setLength(0);
                    this.inCellText = false;
                }
            } else if (name.equalsIgnoreCase(SHEET_NAME_TAG)) {
                if (this.inRightSheet) {
                    msg = BasicUtilities.getString("Solver_Sheet_Finished", this.preferredSheet);
                    SolverTableFilter.this.debug(msg);
                }
            } else if (name.equalsIgnoreCase(SHEET_BODY) && this.model.isEmpty()) {
                msg = BasicUtilities.getString("Solver_Sheet_Empty", this.preferredSheet);
                SolverTableFilter.this.info(msg);
            }
            try {
                SolverTableFilter.this.checkIfCancelled();
            }
            catch (InterruptedException ie) {
                throw new SAXException(ie);
            }
        }

        public void startElement(String ln, String ns, String name, Attributes attr) {
            if (name.equalsIgnoreCase(SHEET_NAME_TAG)) {
                if (this.preferredSheet.equalsIgnoreCase(attr.getValue(ln, "name"))) {
                    this.inRightSheet = true;
                    String msg = BasicUtilities.getString("Solver_Sheet_Found", this.preferredSheet);
                    SolverTableFilter.this.info(msg);
                }
            } else if (this.inRightSheet) {
                if (name.equalsIgnoreCase(TABLE_TEXT)) {
                    this.inCellText = true;
                } else if (name.equalsIgnoreCase(TABLE_ROW)) {
                    this.currentRow = new ArrayList();
                }
            }
        }
    }
}

