/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core.action;

import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.isqlviewer.core.IPCListener;
import org.isqlviewer.core.IPCService;
import org.isqlviewer.core.ServiceProvider;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.action.CoreAction;
import org.isqlviewer.core.action.DefaultActionManager;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.swing.ActionManager;
import org.isqlviewer.swing.ActionMenuBar;
import org.isqlviewer.swing.JCheckBoxAction;
import org.isqlviewer.swing.JTextPopup;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.UserPreferences;

public class DefaultMenuBar
extends ActionMenuBar
implements IPCListener {
    private JMenu mnuService;
    private JMenu mnuCatalog;
    private JMenuItem RowColDeleteAction;
    private JMenuItem ResultToggleAction;
    private JMenuItem LockAction;
    private ButtonGroup grpCatalog;

    public DefaultMenuBar(ActionManager manager) {
        super(manager);
        SystemConfig config = SystemConfig.getInstance();
        IPCService ipc = config.getIPCService();
        ipc.subscribe(this, "isql-service-change");
    }

    public void receiveMessage(Object src, String topic, Object msg) {
        if (topic.equalsIgnoreCase("isql-service-change")) {
            DatabaseConnection connection = (DatabaseConnection)msg;
            int count = this.mnuService.getMenuComponentCount();
            Component c = this.mnuService.getMenuComponent(count - 1);
            c.setEnabled(msg != null);
            this.mnuCatalog.removeAll();
            this.mnuCatalog.setVisible(false);
            this.grpCatalog = null;
            this.grpCatalog = new ButtonGroup();
            if (msg != null) {
                Object[] catalogs = connection.getAvailableCatalogs();
                String active = connection.getCatalog();
                if (catalogs.length >= 2) {
                    this.mnuCatalog.setVisible(true);
                    for (int i = 0; i < catalogs.length; ++i) {
                        String cat = (String)catalogs[i];
                        this.addDynamicAction(this.mnuCatalog, null, this.grpCatalog, -2, cat, false);
                        if (!active.equalsIgnoreCase(cat)) continue;
                        AbstractButton btn = (AbstractButton)this.mnuCatalog.getMenuComponent(i);
                        this.grpCatalog.setSelected(btn.getModel(), true);
                    }
                }
            }
        }
    }

    public void toggleDeleteColumnRowAction(Action action) {
        if (action == null) {
            return;
        }
        this.RowColDeleteAction.setAction(action);
        this.configureMenuItem(this.RowColDeleteAction, action);
    }

    public void toggleLockAction(Action action) {
        if (action == null) {
            return;
        }
        this.LockAction.setAction(action);
        this.configureMenuItem(this.LockAction, action);
    }

    public void toggleResultSetViewAction(Action action) {
        if (action == null) {
            return;
        }
        this.ResultToggleAction.setAction(action);
        this.configureMenuItem(this.ResultToggleAction, action);
    }

    public void refreshServiceMenu() {
        ServiceProvider provider = SystemConfig.getInstance().getServiceProvider();
        this.setServices(provider.getRegisteredServices(true), this.mnuService);
    }

    public void addEditMenu(JTextComponent cmp) {
        JTextPopup pu = new JTextPopup();
        pu.addJTextComponent(cmp, false);
        this.add((Component)pu.toJMenu(), 1);
    }

    protected void configureMenu() {
        this.mnuCatalog = this.createFileMenu(BasicUtilities.getString("Menu_Catalog"), '0');
        this.add(this.createFileMenu(BasicUtilities.getString("MENU_File"), '0'));
        this.add(this.createServiceMenu(BasicUtilities.getString("MENU_Service"), '0'));
        this.add(this.mnuCatalog);
        this.add(this.createViewMenu(BasicUtilities.getString("MENU_View"), '0'));
        this.add(this.createTxMenu());
        this.add(this.createToolMenu(BasicUtilities.getString("MENU_Tool"), '0'));
        if (!BasicUtilities.isMac() || !Boolean.getBoolean("isql.mrj.enabled")) {
            JMenu t = this.createMenu(BasicUtilities.getString("MENU_Help"), '0');
            this.addMenuItem(t, this.manager.getAction(31));
            this.addMenuItem(t, this.manager.getAction(23));
            this.add(t);
        }
        this.receiveMessage(this, "isql-service-change", null);
    }

    protected void setServices(Collection col, JMenu menu) {
        if (menu == null) {
            menu = new JMenu();
        }
        menu.removeAll();
        Iterator itr = col.iterator();
        while (itr.hasNext()) {
            this.addDynamicAction(menu, "Server", null, -1, itr.next().toString(), true);
        }
        menu.addSeparator();
        this.addMenuItem(menu, this.manager.getAction(25));
    }

    protected void addDynamicAction(JMenu menu, String icon, ButtonGroup group, int key, String text, boolean accel) {
        CoreAction action = new CoreAction(text, key, DefaultActionManager.bundle);
        action.putValue("Name", text);
        action.putValue("Default", text);
        action.putValue("ICON_NAME", icon);
        if (accel && menu.getMenuComponentCount() >= 0 && menu.getMenuComponentCount() <= 9) {
            char code = Character.forDigit(menu.getMenuComponentCount(), 10);
            KeyStroke ks = KeyStroke.getKeyStroke(code, BasicUtilities.CMD_MASK, true);
            action.putValue("AcceleratorKey", ks);
        }
        if (group != null) {
            this.addRadioButtonMenuItem(menu, group, action);
        } else {
            this.addMenuItem(menu, (Action)action);
        }
    }

    protected void configureMenuItem(JMenuItem menuItem, Action action) {
        super.configureMenuItem(menuItem, action);
        if (action instanceof CoreAction) {
            CoreAction act = (CoreAction)action;
            try {
                menuItem.setActionCommand((String)act.getValue("Default"));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                menuItem.setText((String)act.getValue("Default"));
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (BasicUtilities.isMac()) {
                    menuItem.setIcon(null);
                } else {
                    String s = (String)action.getValue("ICON_NAME");
                    if (s != null) {
                        menuItem.setIcon(this.manager.getSmallIcon(s, "png"));
                    } else {
                        menuItem.setIcon(this.manager.getSmallIcon("Spacer", "png"));
                    }
                }
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t);
            }
        }
    }

    private JMenu createServiceMenu(String name, char mnemonic) {
        this.mnuService = this.createMenu(name, mnemonic);
        this.refreshServiceMenu();
        return this.mnuService;
    }

    private JMenu createViewMenu(String name, char mnemonic) {
        JMenu vMenu = this.createMenu(name, mnemonic);
        JMenu tbMenu = this.createMenu(BasicUtilities.getString("MENU_Toolbars"), '0');
        JMenu hvMenu = this.createMenu(BasicUtilities.getString("MENU_Goto"), '0');
        JMenu rsMenu = this.createMenu(BasicUtilities.getString("MENU_Resultset"), '0');
        if (!BasicUtilities.isMac()) {
            tbMenu.setIcon(this.manager.getSmallIcon("Spacer", "png"));
            hvMenu.setIcon(this.manager.getSmallIcon("Spacer", "png"));
            rsMenu.setIcon(this.manager.getSmallIcon("Spacer", "png"));
        }
        this.addMenuItem(hvMenu, this.manager.getAction(17));
        this.addMenuItem(hvMenu, this.manager.getAction(18));
        JCheckBoxAction fjca = new JCheckBoxAction(BasicUtilities.getString("File_Toolbar"), "0");
        JCheckBoxAction hjca = new JCheckBoxAction(BasicUtilities.getString("History_Toolbar"), "1");
        JCheckBoxAction rjca = new JCheckBoxAction(BasicUtilities.getString("Resultset_Toolbar"), "2");
        UserPreferences prefs = SystemConfig.getInstance().getPreferences();
        this.addCheckBoxMenuItem(tbMenu, fjca, prefs.getBoolean("toolbar.file-visible"));
        this.addCheckBoxMenuItem(tbMenu, hjca, prefs.getBoolean("toolbar.history-visible"));
        this.addCheckBoxMenuItem(tbMenu, rjca, prefs.getBoolean("toolbar.resultset-visible"));
        vMenu.add(tbMenu);
        vMenu.add(hvMenu);
        vMenu.add(rsMenu);
        vMenu.addSeparator();
        this.addMenuItem(vMenu, this.manager.getAction(43));
        this.addMenuItem(vMenu, this.manager.getAction(44));
        this.addMenuItem(vMenu, this.manager.getAction(45));
        vMenu.addSeparator();
        this.addMenuItem(vMenu, this.manager.getAction(16));
        this.addMenuItem(vMenu, this.manager.getAction(7));
        this.addMenuItem(vMenu, this.manager.getAction(24));
        this.addMenuItem(vMenu, this.manager.getAction(35));
        this.RowColDeleteAction = new JMenuItem(this.manager.getAction(19));
        this.configureMenuItem(this.RowColDeleteAction, this.manager.getAction(19));
        rsMenu.add(this.RowColDeleteAction);
        this.ResultToggleAction = new JMenuItem(this.manager.getAction(27));
        this.configureMenuItem(this.ResultToggleAction, this.manager.getAction(27));
        rsMenu.add(this.ResultToggleAction);
        this.LockAction = new JMenuItem(this.manager.getAction(29));
        this.configureMenuItem(this.LockAction, this.manager.getAction(29));
        rsMenu.add(this.LockAction);
        this.addMenuItem(rsMenu, this.manager.getAction(28));
        return vMenu;
    }

    private JMenu createFileMenu(String name, char mnemonic) {
        JMenu menu = this.createMenu(name, mnemonic);
        JMenu tImpMenu = this.createMenu(BasicUtilities.getString("MENU_Import"), '0');
        JMenu tExpMenu = this.createMenu(BasicUtilities.getString("MENU_Export"), '0');
        if (!BasicUtilities.isMac()) {
            tExpMenu.setIcon(this.manager.getSmallIcon("Spacer", "png"));
            tImpMenu.setIcon(this.manager.getSmallIcon("Spacer", "png"));
        }
        this.addMenuItem(menu, this.manager.getAction(41));
        menu.addSeparator();
        this.addMenuItem(menu, this.manager.getAction(1));
        this.addMenuItem(menu, this.manager.getAction(5));
        menu.addSeparator();
        menu.add(tImpMenu);
        this.addMenuItem(tImpMenu, this.manager.getAction(9));
        this.addMenuItem(tImpMenu, this.manager.getAction(6));
        menu.add(tExpMenu);
        this.addMenuItem(tExpMenu, this.manager.getAction(10));
        if (!BasicUtilities.isMac() || !Boolean.getBoolean("isql.mrj.enabled")) {
            menu.addSeparator();
            this.addMenuItem(menu, this.manager.getAction(8));
        }
        return menu;
    }

    private JMenu createToolMenu(String name, char mnemonic) {
        JMenu menu = this.createMenu(name, mnemonic);
        if (!Boolean.getBoolean("isql.mrj.enabled")) {
            this.addMenuItem(menu, this.manager.getAction(4));
        }
        this.addMenuItem(menu, this.manager.getAction(3));
        this.addMenuItem(menu, this.manager.getAction(34));
        this.addMenuItem(menu, this.manager.getAction(33));
        menu.addSeparator();
        this.addMenuItem(menu, this.manager.getAction(2));
        this.addMenuItem(menu, this.manager.getAction(36));
        this.addMenuItem(menu, this.manager.getAction(42));
        this.addMenuItem(menu, this.manager.getAction(46));
        return menu;
    }

    private JMenu createTxMenu() {
        JMenu menu = new JMenu(BasicUtilities.getString("Transaction"));
        this.addMenuItem(menu, this.manager.getAction(12));
        this.addMenuItem(menu, this.manager.getAction(14));
        this.addMenuItem(menu, this.manager.getAction(13));
        this.addMenuItem(menu, this.manager.getAction(48));
        return menu;
    }
}

